/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;

public final class JSUserObject
extends JSBuiltinObject
implements PrototypeSupplier {
    public static final String TYPE_NAME = "object";
    public static final String CLASS_NAME = "Object";
    public static final String PROTOTYPE_NAME = "Object.prototype";
    public static final JSUserObject INSTANCE = new JSUserObject();

    private JSUserObject() {
    }

    public static DynamicObject create(JSContext context) {
        return JSUserObject.create(context, context.getRealm());
    }

    public static DynamicObject create(JSContext context, JSRealm realm) {
        if (context.isMultiContext()) {
            return JSUserObject.createWithPrototypeInObject(realm.getObjectPrototype(), context);
        }
        return JSObject.createWithRealm(context, context.getOrdinaryObjectFactory(), realm, JSArguments.EMPTY_ARGUMENTS_ARRAY);
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject createWithPrototype(DynamicObject prototype, JSContext context) {
        assert (prototype == Null.instance || JSRuntime.isObject(prototype));
        return JSObject.create(context, prototype, INSTANCE);
    }

    public static DynamicObject createWithNullPrototype(JSContext context) {
        return JSObject.create(context, context.getEmptyShapeNullPrototype());
    }

    public static DynamicObject createWithPrototypeInObject(DynamicObject prototype, JSContext context) {
        assert (prototype == Null.instance || JSRuntime.isObject(prototype));
        Shape shape = context.getEmptyShapePrototypeInObject();
        DynamicObject obj = JSObject.create(context, shape);
        JSObject.PROTO_PROPERTY.setSafe(obj, (Object)prototype, shape);
        return obj;
    }

    public static DynamicObject createInit(JSRealm realm) {
        CompilerAsserts.neverPartOfCompilation();
        return JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)INSTANCE);
    }

    public static DynamicObject createInit(JSRealm realm, DynamicObject prototype) {
        CompilerAsserts.neverPartOfCompilation();
        return JSObject.createInit(realm, prototype, (JSClass)INSTANCE);
    }

    public static boolean isJSUserObject(Object obj) {
        return JSObject.isDynamicObject(obj) && JSUserObject.isJSUserObject((DynamicObject)obj);
    }

    public static boolean isJSUserObject(DynamicObject obj) {
        return JSUserObject.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getClassName(DynamicObject object) {
        Object toStringTag;
        JSContext context = JSObject.getJSContext(object);
        if (context.getEcmaScriptVersion() <= 5 && JSRuntime.isString(toStringTag = this.get(object, Symbol.SYMBOL_TO_STRING_TAG))) {
            return JSRuntime.toStringIsString(toStringTag);
        }
        return CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth) {
        if (JSTruffleOptions.NashornCompatibilityMode) {
            return this.defaultToString(obj);
        }
        return JSRuntime.objectToConsoleString(obj, null, depth);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object get(DynamicObject thisObj, long index) {
        return this.get(thisObj, String.valueOf(index));
    }

    @Override
    public boolean hasOnlyShapeProperties(DynamicObject obj) {
        return true;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getObjectPrototype();
    }
}

