/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionFactory;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.ForInIterator;
import java.util.EnumSet;
import java.util.Iterator;

public final class JSFunction
extends JSBuiltinObject {
    public static final String TYPE_NAME = "function";
    public static final String CLASS_NAME = "Function";
    public static final String CLASS_NAME_NASHORN_COMPAT = "FunctionNashornCompat";
    public static final String PROTOTYPE_NAME = "Function.prototype";
    public static final String GENERATOR_FUNCTION_NAME = "GeneratorFunction";
    public static final String GENERATOR_NAME = "Generator";
    public static final String GENERATOR_PROTOTYPE_NAME = "Generator.prototype";
    public static final String ASYNC_FUNCTION_NAME = "AsyncFunction";
    public static final String ASYNC_GENERATOR_FUNCTION_NAME = "AsyncGeneratorFunction";
    public static final String ASYNC_GENERATOR_NAME = "AsyncGenerator";
    public static final String ASYNC_GENERATOR_PROTOTYPE_NAME = "AsyncGenerator.prototype";
    public static final String ENUMERATE_ITERATOR_PROTOTYPE_NAME = "[[Enumerate]].prototype";
    public static final String FOR_IN_ITERATOR_PROTOYPE_NAME = "%ForInIteratorPrototype%";
    public static final String CALLER = "caller";
    public static final String ARGUMENTS = "arguments";
    public static final String LENGTH = "length";
    public static final String NAME = "name";
    public static final String PROGRAM_FUNCTION_NAME = ":program";
    public static final String BUILTIN_SOURCE_NAME = "<builtin>";
    public static final SourceSection BUILTIN_SOURCE_SECTION = JSFunction.createBuiltinSourceSection("<builtin>");
    public static final HiddenKey ASYNC_FROM_SYNC_ITERATOR_KEY = new HiddenKey("SyncIterator");
    public static final String ASYNC_FROM_SYNC_ITERATOR_PROTOTYPE_NAME = "%AsyncFromSyncIteratorPrototype%";
    private static final Property PROTOTYPE_PROPERTY_WRITABLE;
    private static final Property PROTOTYPE_PROPERTY_NOT_WRITABLE;
    private static final Property LENGTH_PROPERTY;
    private static final Property LENGTH_PROPERTY_NOT_CONFIGURABLE;
    private static final Property NAME_PROPERTY;
    private static final PropertyProxy PROTOTYPE_PROXY;
    private static final PropertyProxy LENGTH_PROXY;
    private static final PropertyProxy NAME_PROXY;
    private static final Object CLASS_PROTOTYPE_PLACEHOLDER;
    public static final JSFunction INSTANCE;
    private static final Property ENCLOSING_FRAME_PROPERTY;
    private static final HiddenKey ENCLOSING_FRAME;
    private static final Property FUNCTION_DATA_PROPERTY;
    private static final HiddenKey FUNCTION_DATA;
    private static final Property CLASS_PROTOTYPE_PROPERTY;
    private static final HiddenKey CLASS_PROTOTYPE;
    public static final HiddenKey REALM_ID;
    private static final Property REALM_PROPERTY;
    public static final HiddenKey HOME_OBJECT_ID;
    public static final HiddenKey GENERATOR_STATE_ID;
    public static final HiddenKey GENERATOR_CONTEXT_ID;
    public static final HiddenKey GENERATOR_TARGET_ID;
    public static final HiddenKey ASYNC_GENERATOR_STATE_ID;
    public static final HiddenKey ASYNC_GENERATOR_CONTEXT_ID;
    public static final HiddenKey ASYNC_GENERATOR_QUEUE_ID;
    public static final HiddenKey ASYNC_GENERATOR_TARGET_ID;
    private static final Property GENERATOR_FUNCTION_MARKER_PROPERTY;
    private static final HiddenKey GENERATOR_FUNCTION_MARKER_ID;
    private static final Property ASYNC_GENERATOR_FUNCTION_MARKER_PROPERTY;
    private static final HiddenKey ASYNC_GENERATOR_FUNCTION_MARKER_ID;
    private static final HiddenKey BOUND_ARGUMENTS;
    private static final HiddenKey BOUND_THIS;
    private static final HiddenKey BOUND_TARGET_FUNCTION;
    private static final Property BOUND_ARGUMENTS_PROPERTY;
    private static final Property BOUND_THIS_PROPERTY;
    private static final Property BOUND_TARGET_FUNCTION_PROPERTY;
    public static final DynamicObject CONSTRUCT;

    private JSFunction() {
    }

    public static CallTarget getCallTarget(DynamicObject obj) {
        return JSFunction.getFunctionData(obj).getCallTarget();
    }

    public static MaterializedFrame getEnclosingFrame(DynamicObject obj) {
        return JSFunction.getEnclosingFrame(obj, JSFunction.isJSFunction(obj));
    }

    public static MaterializedFrame getEnclosingFrame(DynamicObject obj, boolean floatingCondition) {
        assert (JSFunction.isJSFunction(obj));
        return (MaterializedFrame)ENCLOSING_FRAME_PROPERTY.get(obj, floatingCondition);
    }

    public static JSFunctionData getFunctionData(DynamicObject obj) {
        return JSFunction.getFunctionData(obj, JSFunction.isJSFunction(obj));
    }

    public static JSFunctionData getFunctionData(DynamicObject obj, boolean floatingCondition) {
        assert (JSFunction.isJSFunction(obj));
        return (JSFunctionData)FUNCTION_DATA_PROPERTY.get(obj, floatingCondition);
    }

    private static Object getClassPrototypeField(DynamicObject obj) {
        assert (JSFunction.isJSFunction(obj));
        return CLASS_PROTOTYPE_PROPERTY.get(obj, JSFunction.isJSFunction(obj));
    }

    private static void setClassPrototypeField(DynamicObject obj, Object classPrototype) {
        assert (JSFunction.isJSFunction(obj));
        CLASS_PROTOTYPE_PROPERTY.setSafe(obj, classPrototype, null);
    }

    public static JSRealm getRealm(DynamicObject obj) {
        return JSFunction.getRealm(obj, JSFunction.isJSFunction(obj));
    }

    public static JSRealm getRealm(DynamicObject obj, boolean floatingCondition) {
        assert (JSFunction.isJSFunction(obj));
        return (JSRealm)REALM_PROPERTY.get(obj, floatingCondition);
    }

    public static JSRealm getRealm(DynamicObject functionObj, JSContext context) {
        JSRealm realm;
        assert (JSFunction.isJSFunction(functionObj));
        if (context.isSingleRealm()) {
            realm = context.getRealm();
            assert (realm == JSFunction.getRealm(functionObj));
        } else {
            realm = JSFunction.getRealm(functionObj);
        }
        return realm;
    }

    public static DynamicObject create(JSRealm realm, JSFunctionData functionData) {
        return JSFunction.create(realm, functionData, JSFrameUtil.NULL_MATERIALIZED_FRAME);
    }

    public static DynamicObject create(JSRealm realm, JSFunctionData functionData, MaterializedFrame enclosingFrame) {
        return JSFunction.createDefault(functionData, enclosingFrame, CLASS_PROTOTYPE_PLACEHOLDER, realm);
    }

    public static DynamicObject createWithPrototype(JSFunctionFactory factory, JSRealm realm, JSFunctionData functionData, MaterializedFrame enclosingFrame, DynamicObject prototype) {
        return JSFunction.createWithPrototype(factory, functionData, enclosingFrame, CLASS_PROTOTYPE_PLACEHOLDER, realm, prototype);
    }

    public static DynamicObject createLexicalThis(JSRealm realm, JSFunctionData functionData, MaterializedFrame enclosingFrame, Object lexicalThis) {
        return JSFunction.createDefault(functionData, enclosingFrame, lexicalThis, realm);
    }

    private static DynamicObject createDefault(JSFunctionData functionData, MaterializedFrame enclosingFrame, Object classPrototype, JSRealm realm) {
        JSFunctionFactory factory = JSFunction.initialFactory(functionData);
        return factory.create(functionData, enclosingFrame, classPrototype, realm);
    }

    private static DynamicObject createWithPrototype(JSFunctionFactory factory, JSFunctionData functionData, MaterializedFrame enclosingFrame, Object classPrototype, JSRealm realm, DynamicObject prototype) {
        return factory.createWithPrototype(functionData, enclosingFrame, classPrototype, realm, prototype);
    }

    public static DynamicObject createBound(JSContext context, JSRealm realm, JSFunctionData functionData, DynamicObject boundTargetFunction, Object boundThis, Object[] boundArguments, boolean isAnonymous) {
        assert (functionData != null);
        JSFunctionFactory factory = context.getBoundFunctionFactory(functionData, isAnonymous);
        return factory.createBound(functionData, CLASS_PROTOTYPE_PLACEHOLDER, realm, boundTargetFunction, boundThis, boundArguments);
    }

    private static JSFunctionFactory initialFactory(JSFunctionData functionData) {
        return functionData.getContext().getFunctionFactory(functionData);
    }

    public static String getName(DynamicObject obj) {
        return JSFunction.getFunctionData(obj).getName();
    }

    public static Object call(DynamicObject functionObject, Object thisObject, Object[] argumentValues) {
        assert (JSFunction.isJSFunction(functionObject));
        assert (thisObject != null);
        Object[] arguments = JSArguments.create(thisObject, functionObject, argumentValues);
        return JSFunction.getCallTarget(functionObject).call(arguments);
    }

    public static Object call(Object[] jsArguments) {
        assert (JSFunction.isJSFunction(JSArguments.getFunctionObject(jsArguments)));
        assert (JSArguments.getThisObject(jsArguments) != null);
        return JSFunction.getCallTarget((DynamicObject)JSArguments.getFunctionObject(jsArguments)).call(jsArguments);
    }

    public static Object construct(DynamicObject functionObject, Object[] argumentValues) {
        assert (JSFunction.isJSFunction(functionObject) && JSFunction.isConstructor(functionObject));
        Object[] arguments = JSArguments.create(CONSTRUCT, functionObject, argumentValues);
        return JSFunction.getConstructTarget(functionObject).call(arguments);
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject bind(JSRealm realm, DynamicObject thisFnObj, Object thisArg, Object[] boundArguments) {
        String targetName;
        Object targetLen;
        assert (JSFunction.isJSFunction(thisFnObj));
        JSContext context = realm.getContext();
        DynamicObject proto = JSObject.getPrototype(thisFnObj);
        DynamicObject boundFunction = JSFunction.boundFunctionCreate(context, thisFnObj, thisArg, boundArguments, proto, false, null, null);
        long length = 0L;
        boolean targetHasLength = JSObject.hasOwnProperty(thisFnObj, (Object)LENGTH);
        boolean mustSetLength = true;
        if (targetHasLength && JSRuntime.isNumber(targetLen = JSObject.get(thisFnObj, (Object)LENGTH))) {
            long targetLenInt = JSRuntime.toInteger(targetLen);
            length = Math.max(0L, targetLenInt - (long)boundArguments.length);
            if (targetLenInt == (long)JSFunction.getLength(thisFnObj)) {
                mustSetLength = false;
            }
        }
        if (mustSetLength) {
            JSFunction.setFunctionLength(boundFunction, JSRuntime.longToIntOrDouble(length));
        }
        if (!(targetName = JSFunction.getFunctionName(thisFnObj)).equals(JSFunction.getName(thisFnObj))) {
            JSFunction.setBoundFunctionName(boundFunction, targetName);
        }
        return boundFunction;
    }

    public static DynamicObject boundFunctionCreate(JSContext context, DynamicObject boundTargetFunction, Object boundThis, Object[] boundArguments, DynamicObject proto, boolean isAnonymous, ConditionProfile isAsyncProfile, ConditionProfile setProtoProfile) {
        boolean needSetProto;
        assert (JSFunction.isJSFunction(boundTargetFunction));
        CompilerAsserts.partialEvaluationConstant((Object)context);
        boolean constructor = JSFunction.isConstructor(boundTargetFunction);
        JSFunctionData functionData = context.getBoundFunctionData(constructor);
        boolean isAsync = JSFunction.getFunctionData(boundTargetFunction).isAsync();
        if (isAsyncProfile == null ? isAsync : isAsyncProfile.profile(isAsync)) {
            int length = Math.max(0, JSFunction.getLength(boundTargetFunction) - boundArguments.length);
            functionData = JSFunction.makeBoundFunctionData(context, length, constructor, isAsync);
        }
        JSRealm realm = JSFunction.getRealm(boundTargetFunction, context);
        DynamicObject boundFunction = JSFunction.createBound(context, realm, functionData, boundTargetFunction, boundThis, boundArguments, isAnonymous);
        boolean bl = needSetProto = proto != realm.getFunctionPrototype();
        if (setProtoProfile == null ? needSetProto : setProtoProfile.profile(needSetProto)) {
            JSObject.setPrototype(boundFunction, proto);
        }
        assert (JSObject.getPrototype(boundFunction) == proto);
        return boundFunction;
    }

    @CompilerDirectives.TruffleBoundary
    private static JSFunctionData makeBoundFunctionData(JSContext context, int length, boolean constructor, boolean isAsync) {
        return JSFunctionData.create(context, context.getBoundFunctionCallTarget(), context.getBoundFunctionConstructTarget(), context.getBoundFunctionConstructNewTarget(), length, "bound", constructor, false, true, false, false, false, isAsync, false, true, false, true);
    }

    @CompilerDirectives.TruffleBoundary
    private static String getFunctionName(DynamicObject thisFnObj) {
        Object name = JSObject.get(thisFnObj, (Object)NAME);
        if (!JSRuntime.isString(name)) {
            name = "";
        }
        return name.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static void setFunctionLength(DynamicObject functionObj, Number length) {
        JSObject.defineOwnProperty(functionObj, LENGTH, PropertyDescriptor.createData(length, false, false, true));
    }

    @CompilerDirectives.TruffleBoundary
    public static void setBoundFunctionName(DynamicObject boundFunction, String targetName) {
        JSObject.defineOwnProperty(boundFunction, NAME, PropertyDescriptor.createData("bound " + targetName, false, false, true));
    }

    public static boolean isStrict(DynamicObject obj) {
        return JSFunction.getFunctionData(obj).isStrict();
    }

    public static boolean isBuiltin(DynamicObject obj) {
        return JSFunction.getFunctionData(obj).isBuiltin();
    }

    public static boolean isConstructor(DynamicObject obj) {
        assert (JSFunction.isJSFunction(obj));
        return JSFunction.getFunctionData(obj).isConstructor();
    }

    public static boolean isConstructor(Object obj) {
        return JSFunction.isJSFunction(obj) && JSFunction.getFunctionData((DynamicObject)obj).isConstructor();
    }

    public static boolean isGenerator(DynamicObject obj) {
        return JSFunction.getFunctionData(obj).isGenerator();
    }

    public static boolean needsParentFrame(DynamicObject obj) {
        return JSFunction.getFunctionData(obj).needsParentFrame();
    }

    public static int getLength(DynamicObject obj) {
        return JSFunction.getFunctionData(obj).getLength();
    }

    public static boolean isClassPrototypeInitialized(DynamicObject thisObj) {
        return JSFunction.getClassPrototypeField(thisObj) != CLASS_PROTOTYPE_PLACEHOLDER;
    }

    public static boolean isBoundFunction(DynamicObject function) {
        return JSFunction.isJSFunction(function) && JSFunction.getFunctionData(function).isBound();
    }

    public static boolean isAsyncFunction(DynamicObject function) {
        return JSFunction.isJSFunction(function) && JSFunction.getFunctionData(function).isAsync();
    }

    public static Object getBoundThis(DynamicObject function) {
        assert (JSFunction.isBoundFunction(function));
        return BOUND_THIS_PROPERTY.get(function, JSFunction.isBoundFunction(function));
    }

    public static DynamicObject getBoundTargetFunction(DynamicObject function) {
        assert (JSFunction.isBoundFunction(function));
        return (DynamicObject)BOUND_TARGET_FUNCTION_PROPERTY.get(function, JSFunction.isBoundFunction(function));
    }

    public static Object[] getBoundArguments(DynamicObject function) {
        assert (JSFunction.isBoundFunction(function));
        return (Object[])BOUND_ARGUMENTS_PROPERTY.get(function, JSFunction.isBoundFunction(function));
    }

    public static Object getLexicalThis(DynamicObject thisObj) {
        return JSFunction.getClassPrototypeInitialized(thisObj);
    }

    public static Object getClassPrototypeInitialized(DynamicObject thisObj) {
        Object classPrototype = JSFunction.getClassPrototypeField(thisObj);
        assert (classPrototype != CLASS_PROTOTYPE_PLACEHOLDER);
        return classPrototype;
    }

    public static Object getClassPrototype(DynamicObject thisObj) {
        Object classPrototype = JSFunction.getClassPrototypeField(thisObj);
        if (classPrototype == CLASS_PROTOTYPE_PLACEHOLDER) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            JSFunction.initializeClassPrototype(thisObj);
        }
        return JSFunction.getClassPrototypeField(thisObj);
    }

    private static void initializeClassPrototype(DynamicObject thisObj) {
        JSFunction.setClassPrototypeField(thisObj, JSFunction.createPrototype(thisObj));
    }

    private static DynamicObject createPrototype(DynamicObject constructor) {
        JSFunctionData functionData = JSFunction.getFunctionData(constructor);
        JSRealm realm = JSFunction.getRealm(constructor);
        JSContext context = functionData.getContext();
        if (!functionData.isGenerator()) {
            DynamicObject prototype = JSUserObject.create(context, realm);
            JSObjectUtil.putConstructorProperty(context, prototype, constructor);
            return prototype;
        }
        return JSObject.createWithRealm(context, functionData.isAsync() ? context.getAsyncGeneratorObjectFactory() : context.getGeneratorObjectFactory(), realm, new Object[0]);
    }

    public static void setClassPrototype(DynamicObject thisObj, Object value) {
        assert (value != null);
        JSFunction.setClassPrototypeField(thisObj, value);
    }

    public static RootNode createBoundRootNode(JSContext context, boolean construct, boolean newTarget) {
        if (newTarget) {
            return new BoundConstructNewTargetRootNode(context);
        }
        if (construct) {
            return new BoundConstructRootNode(context);
        }
        return new BoundRootNode(context);
    }

    public static DynamicObject createFunctionPrototype(JSRealm realm, DynamicObject objectPrototype) {
        JSContext context = realm.getContext();
        DynamicObject obj = JSObject.createInit(realm, objectPrototype, (JSClass)INSTANCE);
        JSObjectUtil.putHiddenProperty(obj, FUNCTION_DATA_PROPERTY, JSFunction.createEmptyFunctionData(context));
        JSObjectUtil.putHiddenProperty(obj, ENCLOSING_FRAME_PROPERTY, JSFrameUtil.NULL_MATERIALIZED_FRAME);
        JSObjectUtil.putHiddenProperty(obj, CLASS_PROTOTYPE_PROPERTY, CLASS_PROTOTYPE_PLACEHOLDER);
        JSObjectUtil.putHiddenProperty(obj, REALM_PROPERTY, realm);
        JSObjectUtil.putProxyProperty(obj, LENGTH_PROPERTY);
        JSObjectUtil.putProxyProperty(obj, NAME_PROPERTY);
        return obj;
    }

    public static void addRestrictedFunctionProperties(JSRealm realm, DynamicObject obj) {
        if (!realm.getEnv().isPreInitialization()) {
            JSObjectUtil.putConstantAccessorProperty(realm.getContext(), obj, CALLER, realm.getThrowerFunction(), realm.getThrowerFunction());
            JSObjectUtil.putConstantAccessorProperty(realm.getContext(), obj, ARGUMENTS, realm.getThrowerFunction(), realm.getThrowerFunction());
        }
    }

    public static JSFunctionData createNamedEmptyFunctionData(JSContext context, String name) {
        return JSFunctionData.createCallOnly(context, context.getEmptyFunctionCallTarget(), 0, name);
    }

    public static JSFunctionData createEmptyFunctionData(JSContext context) {
        return JSFunction.createNamedEmptyFunctionData(context, "");
    }

    public static DynamicObject createNamedEmptyFunction(JSRealm realm, String name) {
        return JSFunction.create(realm, JSFunction.createNamedEmptyFunctionData(realm.getContext(), name));
    }

    public static DynamicObject createEmptyFunction(JSRealm realm) {
        return JSFunction.create(realm, JSFunction.createEmptyFunctionData(realm.getContext()));
    }

    public static void fillFunctionPrototype(JSRealm realm) {
        JSContext ctx = realm.getContext();
        JSObjectUtil.putConstructorProperty(ctx, realm.getFunctionPrototype(), realm.getFunctionConstructor());
        JSObjectUtil.putFunctionsFromContainer(realm, realm.getFunctionPrototype(), PROTOTYPE_NAME);
        if (ctx.getEcmaScriptVersion() >= 6) {
            JSFunction.addRestrictedFunctionProperties(realm, realm.getFunctionPrototype());
        }
        if (ctx.isOptionNashornCompatibilityMode()) {
            JSObjectUtil.putFunctionsFromContainer(realm, realm.getFunctionPrototype(), CLASS_NAME_NASHORN_COMPAT);
        }
    }

    private static Shape makeBaseFunctionShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = initialShape.reservePrimitiveExtensionArray();
        initialShape = initialShape.addProperty(FUNCTION_DATA_PROPERTY);
        initialShape = initialShape.addProperty(ENCLOSING_FRAME_PROPERTY);
        initialShape = initialShape.addProperty(CLASS_PROTOTYPE_PROPERTY);
        initialShape = initialShape.addProperty(REALM_PROPERTY);
        return initialShape;
    }

    private static Shape addCallerAndArgumentsProperties(Shape initialShape, JSContext context, boolean isStrict) {
        if (context.getEcmaScriptVersion() >= 6) {
            if (!isStrict) {
                return JSFunction.makeNonStrictFunctionShape(initialShape, context);
            }
        } else if (isStrict) {
            return JSFunction.makeES5StrictFunctionShape(initialShape, context);
        }
        return initialShape;
    }

    private static Shape addLengthProxyProperty(Shape initialShape, JSContext context) {
        return initialShape.addProperty(context.getEcmaScriptVersion() < 6 ? LENGTH_PROPERTY_NOT_CONFIGURABLE : LENGTH_PROPERTY);
    }

    private static Shape addNameProxyProperty(Shape initialShape, boolean isAnonymous) {
        return isAnonymous ? initialShape : initialShape.addProperty(NAME_PROPERTY);
    }

    public static Shape makeInitialFunctionShape(JSContext context, DynamicObject prototype, boolean isStrict, boolean isAnonymous) {
        return JSFunction.makeInitialFunctionShape(context, prototype, isStrict, isAnonymous, false, false);
    }

    public static Shape makeInitialFunctionShape(JSContext context, DynamicObject prototype, boolean isStrict, boolean isAnonymous, boolean hasPrototype, boolean prototypeNotWritable) {
        Shape initialShape = JSFunction.makeBaseFunctionShape(context, prototype);
        initialShape = JSFunction.addLengthProxyProperty(initialShape, context);
        if (hasPrototype && prototypeNotWritable) {
            initialShape = JSFunction.addPrototypeProxyProperty(initialShape, prototypeNotWritable);
        }
        initialShape = JSFunction.addNameProxyProperty(initialShape, isAnonymous);
        if (hasPrototype && !prototypeNotWritable) {
            initialShape = JSFunction.addPrototypeProxyProperty(initialShape, prototypeNotWritable);
        }
        initialShape = JSFunction.addCallerAndArgumentsProperties(initialShape, context, isStrict);
        return initialShape;
    }

    private static Shape addPrototypeProxyProperty(Shape functionShape, boolean notWritable) {
        assert (JSShape.getJSClassNoCast(functionShape) == INSTANCE);
        if (notWritable) {
            return functionShape.addProperty(PROTOTYPE_PROPERTY_NOT_WRITABLE);
        }
        return functionShape.addProperty(PROTOTYPE_PROPERTY_WRITABLE);
    }

    private static Shape makeNonStrictFunctionShape(Shape shape, JSContext context) {
        Shape nonStrictShape = shape;
        nonStrictShape = nonStrictShape.addProperty(JSObjectUtil.makeProxyProperty(ARGUMENTS, new ArgumentsProxyProperty(context), JSAttributes.notConfigurableNotEnumerableNotWritable()));
        nonStrictShape = nonStrictShape.addProperty(JSObjectUtil.makeProxyProperty(CALLER, new CallerProxyProperty(context), JSAttributes.notConfigurableNotEnumerableNotWritable()));
        return nonStrictShape;
    }

    private static Shape makeES5StrictFunctionShape(Shape nonStrictShape, JSContext context) {
        assert (context.getEcmaScriptVersion() < 6);
        Shape strictShape = nonStrictShape;
        strictShape = strictShape.addProperty(JSObjectUtil.makeAccessorProperty(ARGUMENTS, strictShape.allocator().locationForType(Accessor.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), JSAttributes.notConfigurableNotEnumerable()));
        strictShape = strictShape.addProperty(JSObjectUtil.makeAccessorProperty(CALLER, strictShape.allocator().locationForType(Accessor.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)), JSAttributes.notConfigurableNotEnumerable()));
        return strictShape;
    }

    public static DynamicObject createFunctionConstructor(JSRealm realm) {
        JSContext ctx = realm.getContext();
        DynamicObject functionConstructor = realm.lookupFunction("%Constructors%", CLASS_NAME);
        JSObjectUtil.putDataProperty(ctx, functionConstructor, "prototype", realm.getFunctionPrototype(), JSAttributes.notConfigurableNotEnumerableNotWritable());
        return functionConstructor;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth) {
        RootNode rn = ((RootCallTarget)JSFunction.getCallTarget(obj)).getRootNode();
        SourceSection ssect = rn.getSourceSection();
        String source = ssect == null || !ssect.isAvailable() || ssect.getSource().isInternal() ? "function " + JSFunction.getName(obj) + "() { [native code] }" : (depth <= 0 ? "function " + JSFunction.getName(obj) + "() {...}" : (ssect.getCharacters().length() > 200 ? ssect.getCharacters().subSequence(0, 195) + "...<omitted>...\n}" : ssect.getCharacters().toString()));
        return source;
    }

    @Override
    public boolean hasOnlyShapeProperties(DynamicObject obj) {
        return true;
    }

    public static CallTarget getConstructTarget(DynamicObject obj) {
        return JSFunction.getFunctionData(obj).getConstructTarget();
    }

    public static CallTarget getConstructNewTarget(DynamicObject obj) {
        return JSFunction.getFunctionData(obj).getConstructNewTarget();
    }

    public static boolean isJSFunction(Object obj) {
        return JSObject.isDynamicObject(obj) && JSFunction.isJSFunction((DynamicObject)obj);
    }

    public static boolean isJSFunction(DynamicObject obj) {
        return JSFunction.isInstance(obj, (JSClass)INSTANCE);
    }

    public static DynamicObject createGeneratorFunctionPrototype(JSRealm realm, DynamicObject constructor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getFunctionPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putDataProperty(ctx, prototype, "constructor", constructor, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(ctx, prototype, "prototype", JSFunction.createGeneratorPrototype(realm, prototype), JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_TO_STRING_TAG, GENERATOR_FUNCTION_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    private static DynamicObject createGeneratorPrototype(JSRealm realm, DynamicObject constructor) {
        JSContext ctx = realm.getContext();
        DynamicObject generatorPrototype = JSObject.createInit(realm, realm.getIteratorPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(realm, generatorPrototype, GENERATOR_PROTOTYPE_NAME);
        JSObjectUtil.putDataProperty(ctx, generatorPrototype, "constructor", constructor, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(ctx, generatorPrototype, Symbol.SYMBOL_TO_STRING_TAG, GENERATOR_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return generatorPrototype;
    }

    public static JSConstructor createGeneratorFunctionConstructor(JSRealm realm) {
        JSContext ctx = realm.getContext();
        DynamicObject constructor = realm.lookupFunction("%Constructors%", GENERATOR_FUNCTION_NAME);
        JSObject.setPrototype(constructor, realm.getFunctionConstructor());
        DynamicObject prototype = JSFunction.createGeneratorFunctionPrototype(realm, constructor);
        JSObjectUtil.putDataProperty(ctx, constructor, "prototype", prototype, JSAttributes.notConfigurableNotEnumerableNotWritable());
        return new JSConstructor(constructor, prototype);
    }

    static Shape makeInitialGeneratorFunctionShape(JSContext context, DynamicObject prototype, boolean isAsync, boolean isAnonymous) {
        Shape initialShape = JSFunction.makeBaseFunctionShape(context, prototype);
        initialShape = initialShape.addProperty(isAsync ? ASYNC_GENERATOR_FUNCTION_MARKER_PROPERTY : GENERATOR_FUNCTION_MARKER_PROPERTY);
        initialShape = JSFunction.addLengthProxyProperty(initialShape, context);
        initialShape = JSFunction.addPrototypeProxyProperty(initialShape, false);
        initialShape = JSFunction.addNameProxyProperty(initialShape, isAnonymous);
        return initialShape;
    }

    public static DynamicObject createAsyncFunctionPrototype(JSRealm realm, DynamicObject constructor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getFunctionPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putDataProperty(ctx, prototype, "constructor", constructor, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_TO_STRING_TAG, ASYNC_FUNCTION_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    public static JSConstructor createAsyncFunctionConstructor(JSRealm realm) {
        JSContext ctx = realm.getContext();
        DynamicObject constructor = realm.lookupFunction("%Constructors%", ASYNC_FUNCTION_NAME);
        JSObject.setPrototype(constructor, realm.getFunctionConstructor());
        DynamicObject prototype = JSFunction.createAsyncFunctionPrototype(realm, constructor);
        JSObjectUtil.putDataProperty(ctx, constructor, "prototype", prototype, JSAttributes.notConfigurableNotEnumerableNotWritable());
        return new JSConstructor(constructor, prototype);
    }

    public static DynamicObject createAsyncIteratorPrototype(JSRealm realm) {
        JSContext context = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSFunctionData functionData = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.FunctionAsyncIterator, c -> JSFunctionData.createCallOnly(context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                return JSFrameUtil.getThisObj((Frame)frame);
            }
        }), 0, Symbol.SYMBOL_ASYNC_ITERATOR.toFunctionNameString()));
        DynamicObject asyncIterator = JSFunction.create(realm, functionData);
        JSObjectUtil.putDataProperty(context, prototype, Symbol.SYMBOL_ASYNC_ITERATOR, asyncIterator, JSAttributes.getDefaultNotEnumerable());
        return prototype;
    }

    public static DynamicObject createAsyncFromSyncIteratorPrototype(JSRealm realm) {
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, ASYNC_FROM_SYNC_ITERATOR_PROTOTYPE_NAME);
        return prototype;
    }

    public static DynamicObject createAsyncGeneratorFunctionPrototype(JSRealm realm, DynamicObject constructor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getFunctionPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putDataProperty(ctx, prototype, "constructor", constructor, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(ctx, prototype, "prototype", JSFunction.createAsyncGeneratorPrototype(realm, prototype), JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_TO_STRING_TAG, ASYNC_GENERATOR_FUNCTION_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    private static DynamicObject createAsyncGeneratorPrototype(JSRealm realm, DynamicObject constructor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getAsyncIteratorPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, ASYNC_GENERATOR_PROTOTYPE_NAME);
        JSObjectUtil.putDataProperty(ctx, prototype, "constructor", constructor, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_TO_STRING_TAG, ASYNC_GENERATOR_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return prototype;
    }

    public static JSConstructor createAsyncGeneratorFunctionConstructor(JSRealm realm) {
        JSContext ctx = realm.getContext();
        DynamicObject constructor = realm.lookupFunction("%Constructors%", ASYNC_GENERATOR_FUNCTION_NAME);
        JSObject.setPrototype(constructor, realm.getFunctionConstructor());
        DynamicObject prototype = JSFunction.createAsyncGeneratorFunctionPrototype(realm, constructor);
        JSObjectUtil.putDataProperty(ctx, constructor, "prototype", prototype, JSAttributes.notConfigurableNotEnumerableNotWritable());
        return new JSConstructor(constructor, prototype);
    }

    public static DynamicObject createEnumerateIteratorPrototype(JSRealm realm) {
        DynamicObject iteratorPrototype = realm.getIteratorPrototype();
        DynamicObject enumerateIteratorPrototype = JSObject.createInit(realm, iteratorPrototype, (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(realm, enumerateIteratorPrototype, ENUMERATE_ITERATOR_PROTOTYPE_NAME);
        return enumerateIteratorPrototype;
    }

    public static Shape makeInitialEnumerateIteratorShape(JSContext context, DynamicObject enumerateIteratorPrototype) {
        Property iteratorProperty = JSObjectUtil.makeHiddenProperty(JSRuntime.ENUMERATE_ITERATOR_ID, JSShape.makeAllocator(JSObject.LAYOUT).locationForType(Iterator.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        return JSObjectUtil.getProtoChildShape(enumerateIteratorPrototype, JSUserObject.INSTANCE, context).addProperty(iteratorProperty);
    }

    public static DynamicObject createForInIteratorPrototype(JSRealm realm) {
        DynamicObject iteratorPrototype = realm.getIteratorPrototype();
        DynamicObject enumerateIteratorPrototype = JSObject.createInit(realm, iteratorPrototype, (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(realm, enumerateIteratorPrototype, FOR_IN_ITERATOR_PROTOYPE_NAME);
        return enumerateIteratorPrototype;
    }

    public static Shape makeInitialForInIteratorShape(JSContext context, DynamicObject iteratorPrototype) {
        Property iteratorProperty = JSObjectUtil.makeHiddenProperty(JSRuntime.FOR_IN_ITERATOR_ID, JSShape.makeAllocator(JSObject.LAYOUT).locationForType(ForInIterator.class));
        return JSObjectUtil.getProtoChildShape(iteratorPrototype, JSUserObject.INSTANCE, context).addProperty(iteratorProperty);
    }

    public static Shape makeInitialBoundFunctionShape(JSContext context, DynamicObject prototype, boolean isAnonymous) {
        Shape initialShape = JSFunction.makeBaseFunctionShape(context, prototype);
        initialShape = initialShape.addProperty(BOUND_TARGET_FUNCTION_PROPERTY);
        initialShape = initialShape.addProperty(BOUND_THIS_PROPERTY);
        initialShape = initialShape.addProperty(BOUND_ARGUMENTS_PROPERTY);
        initialShape = JSFunction.addLengthProxyProperty(initialShape, context);
        initialShape = JSFunction.addNameProxyProperty(initialShape, isAnonymous);
        initialShape = JSFunction.addCallerAndArgumentsProperties(initialShape, context, true);
        return initialShape;
    }

    private static RootNode getFrameRootNode(FrameInstance frameInstance) {
        Node callNode = frameInstance.getCallNode();
        if (callNode != null) {
            return callNode.getRootNode();
        }
        CallTarget callTarget = frameInstance.getCallTarget();
        if (callTarget instanceof RootCallTarget) {
            return ((RootCallTarget)callTarget).getRootNode();
        }
        return null;
    }

    public static SourceSection createBuiltinSourceSection(String name) {
        return Source.newBuilder((String)"js", (CharSequence)"", (String)name).internal(true).build().createUnavailableSection();
    }

    public static boolean isBuiltinSourceSection(SourceSection sourceSection) {
        return sourceSection == BUILTIN_SOURCE_SECTION;
    }

    public static boolean isBuiltinThatShouldNotAppearInStackTrace(JSRealm realm, DynamicObject function) {
        return function == realm.getApplyFunctionObject() || function == realm.getCallFunctionObject() || function == realm.getReflectApplyFunctionObject() || function == realm.getReflectConstructFunctionObject();
    }

    public static boolean isStrictBuiltin(DynamicObject function) {
        JSFunctionData functionData = JSFunction.getFunctionData(function);
        JSRealm realm = functionData.getContext().getRealm();
        PropertyDescriptor desc = JSObject.getOwnProperty(realm.getArrayPrototype(), functionData.getName());
        return desc != null && desc.isDataDescriptor() && desc.getValue() == function;
    }

    static {
        PROTOTYPE_PROXY = new ClassPrototypeProxyProperty();
        LENGTH_PROXY = new FunctionLengthPropertyProxy();
        NAME_PROXY = new FunctionNamePropertyProxy();
        CLASS_PROTOTYPE_PLACEHOLDER = new Object();
        INSTANCE = new JSFunction();
        ENCLOSING_FRAME = new HiddenKey("enclosingFrame");
        FUNCTION_DATA = new HiddenKey("functionData");
        CLASS_PROTOTYPE = new HiddenKey("classPrototype");
        REALM_ID = new HiddenKey("Realm");
        HOME_OBJECT_ID = new HiddenKey("HomeObject");
        GENERATOR_STATE_ID = new HiddenKey("GeneratorState");
        GENERATOR_CONTEXT_ID = new HiddenKey("GeneratorContext");
        GENERATOR_TARGET_ID = new HiddenKey("GeneratorTarget");
        ASYNC_GENERATOR_STATE_ID = new HiddenKey("AsyncGeneratorState");
        ASYNC_GENERATOR_CONTEXT_ID = new HiddenKey("AsyncGeneratorContext");
        ASYNC_GENERATOR_QUEUE_ID = new HiddenKey("AsyncGeneratorQueue");
        ASYNC_GENERATOR_TARGET_ID = new HiddenKey("AsyncGeneratorTarget");
        GENERATOR_FUNCTION_MARKER_ID = new HiddenKey("generator function");
        ASYNC_GENERATOR_FUNCTION_MARKER_ID = new HiddenKey("async generator function");
        BOUND_ARGUMENTS = new HiddenKey("BoundArguments");
        BOUND_THIS = new HiddenKey("BoundThis");
        BOUND_TARGET_FUNCTION = new HiddenKey("BoundTargetFunction");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        FUNCTION_DATA_PROPERTY = JSObjectUtil.makeHiddenProperty(FUNCTION_DATA, allocator.locationForType(JSFunctionData.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        ENCLOSING_FRAME_PROPERTY = JSObjectUtil.makeHiddenProperty(ENCLOSING_FRAME, allocator.locationForType(MaterializedFrame.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        CLASS_PROTOTYPE_PROPERTY = JSObjectUtil.makeHiddenProperty(CLASS_PROTOTYPE, allocator.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)));
        REALM_PROPERTY = JSObjectUtil.makeHiddenProperty(REALM_ID, allocator.locationForType(JSRealm.class, EnumSet.of(LocationModifier.NonNull)));
        BOUND_TARGET_FUNCTION_PROPERTY = JSObjectUtil.makeHiddenProperty(BOUND_TARGET_FUNCTION, allocator.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)));
        BOUND_THIS_PROPERTY = JSObjectUtil.makeHiddenProperty(BOUND_THIS, allocator.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)));
        BOUND_ARGUMENTS_PROPERTY = JSObjectUtil.makeHiddenProperty(BOUND_ARGUMENTS, allocator.locationForType(Object[].class, EnumSet.of(LocationModifier.NonNull)));
        PROTOTYPE_PROPERTY_WRITABLE = JSObjectUtil.makeProxyProperty("prototype", PROTOTYPE_PROXY, JSAttributes.notConfigurableNotEnumerableWritable());
        PROTOTYPE_PROPERTY_NOT_WRITABLE = JSObjectUtil.makeProxyProperty("prototype", PROTOTYPE_PROXY, JSAttributes.notConfigurableNotEnumerableNotWritable());
        LENGTH_PROPERTY = JSObjectUtil.makeProxyProperty(LENGTH, LENGTH_PROXY, JSAttributes.configurableNotEnumerableNotWritable());
        LENGTH_PROPERTY_NOT_CONFIGURABLE = JSObjectUtil.makeProxyProperty(LENGTH, LENGTH_PROXY, JSAttributes.notConfigurableNotEnumerableNotWritable());
        NAME_PROPERTY = JSObjectUtil.makeProxyProperty(NAME, NAME_PROXY, JSAttributes.configurableNotEnumerableNotWritable());
        GENERATOR_FUNCTION_MARKER_PROPERTY = JSObjectUtil.makeHiddenProperty(GENERATOR_FUNCTION_MARKER_ID, allocator.constantLocation(null));
        ASYNC_GENERATOR_FUNCTION_MARKER_PROPERTY = JSObjectUtil.makeHiddenProperty(ASYNC_GENERATOR_FUNCTION_MARKER_ID, allocator.constantLocation(null));
        CONSTRUCT = JSObject.createStatic(JSShape.makeStaticRoot(JSObject.LAYOUT, new JSBuiltinObject(){
            public static final String CLASS_NAME = "CONSTRUCT";

            @Override
            public String getClassName(DynamicObject object) {
                return CLASS_NAME;
            }

            @Override
            public String toString() {
                return CLASS_NAME;
            }
        }, 0));
    }

    private static class CallerProxyProperty
    implements PropertyProxy {
        private final JSContext context;

        CallerProxyProperty(JSContext context) {
            this.context = context;
        }

        @Override
        public Object get(DynamicObject thiz) {
            if (this.context.isOptionV8CompatibilityMode()) {
                return JSRuntime.toJSNull(CallerProxyProperty.findCaller(thiz));
            }
            return Undefined.instance;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object findCaller(final DynamicObject thiz) {
            return Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(){
                private boolean seenThis = false;

                public Object visitFrame(FrameInstance frameInstance) {
                    RootNode rootNode = JSFunction.getFrameRootNode(frameInstance);
                    if (JSRuntime.isJSFunctionRootNode(rootNode)) {
                        Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE);
                        DynamicObject function = (DynamicObject)JSArguments.getFunctionObject(frame.getArguments());
                        if (this.seenThis) {
                            SourceSection ss = rootNode.getSourceSection();
                            if (ss == null) {
                                return null;
                            }
                            if (ss.getSource().isInternal() && !JSFunction.isBuiltinSourceSection(ss)) {
                                return null;
                            }
                            String sourceName = ss.getSource().getName();
                            if ("<eval>".equals(sourceName) || sourceName.startsWith("eval at ")) {
                                return null;
                            }
                            JSFunctionData functionData = JSFunction.getFunctionData(function);
                            if (JSFunction.isBuiltinSourceSection(ss)) {
                                JSRealm realm = functionData.getContext().getRealm();
                                if (JSFunction.isBuiltinThatShouldNotAppearInStackTrace(realm, function)) {
                                    return null;
                                }
                                if (functionData.getName().startsWith("[Symbol.")) {
                                    return null;
                                }
                                if (JSFunction.isStrictBuiltin(function)) {
                                    return Null.instance;
                                }
                            } else if (functionData.isStrict()) {
                                return Null.instance;
                            }
                            if (!JSFunction.PROGRAM_FUNCTION_NAME.equals(rootNode.getName())) {
                                return function;
                            }
                        } else if (function == thiz) {
                            this.seenThis = true;
                        }
                    }
                    return null;
                }
            });
        }
    }

    private static class ArgumentsProxyProperty
    implements PropertyProxy {
        private final JSContext context;

        ArgumentsProxyProperty(JSContext context) {
            this.context = context;
        }

        @Override
        public Object get(DynamicObject thiz) {
            if (this.context.isOptionV8CompatibilityMode()) {
                return JSRuntime.toJSNull(ArgumentsProxyProperty.createArguments(thiz));
            }
            return Undefined.instance;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object createArguments(final DynamicObject thiz) {
            return Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Object>(){

                public Object visitFrame(FrameInstance frameInstance) {
                    Frame frame;
                    DynamicObject function;
                    RootNode rootNode = JSFunction.getFrameRootNode(frameInstance);
                    if (JSRuntime.isJSFunctionRootNode(rootNode) && (function = (DynamicObject)JSArguments.getFunctionObject((frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE)).getArguments())) == thiz) {
                        JSFunctionData functionData = JSFunction.getFunctionData(function);
                        JSContext context = functionData.getContext();
                        JSRealm realm = context.getRealm();
                        Object[] userArguments = JSArguments.extractUserArguments(frame.getArguments());
                        return JSArgumentsObject.createNonStrict(context, realm, userArguments, function);
                    }
                    return null;
                }
            });
        }
    }

    static final class BoundConstructNewTargetRootNode
    extends BoundRootNode {
        BoundConstructNewTargetRootNode(JSContext context) {
            super(context);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] originalArguments = frame.getArguments();
            DynamicObject boundFunction = BoundConstructNewTargetRootNode.castBoundFunction(JSArguments.getFunctionObject(originalArguments));
            DynamicObject boundTargetFunction = JSFunction.getBoundTargetFunction(boundFunction);
            Object[] boundArguments = JSFunction.getBoundArguments(boundFunction);
            Object[] argumentValues = JSArguments.extractUserArguments(originalArguments, 1);
            Object[] arguments = BoundConstructNewTargetRootNode.prependBoundArguments(boundArguments, argumentValues);
            Object originalThis = JSArguments.getThisObject(originalArguments);
            Object newTarget = JSArguments.getNewTarget(originalArguments);
            if (newTarget == boundFunction) {
                newTarget = boundTargetFunction;
            }
            Object[] newArguments = JSArguments.createWithNewTarget(originalThis, boundTargetFunction, newTarget, arguments);
            return this.callNode.call(JSFunction.getFunctionData(boundTargetFunction).getConstructNewTarget(this.initProfile), newArguments);
        }
    }

    static final class BoundConstructRootNode
    extends BoundRootNode {
        BoundConstructRootNode(JSContext context) {
            super(context);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] originalArguments = frame.getArguments();
            DynamicObject boundFunction = BoundConstructRootNode.castBoundFunction(JSArguments.getFunctionObject(originalArguments));
            DynamicObject boundTargetFunction = JSFunction.getBoundTargetFunction(boundFunction);
            Object[] boundArguments = JSFunction.getBoundArguments(boundFunction);
            Object[] argumentValues = JSArguments.extractUserArguments(originalArguments);
            Object[] arguments = BoundConstructRootNode.prependBoundArguments(boundArguments, argumentValues);
            Object originalThis = JSArguments.getThisObject(originalArguments);
            Object[] newArguments = JSArguments.create(originalThis, boundTargetFunction, arguments);
            return this.callNode.call(JSFunction.getFunctionData(boundTargetFunction).getConstructTarget(this.initProfile), newArguments);
        }
    }

    static class BoundRootNode
    extends JavaScriptRootNode {
        private static final SourceSection SOURCE_SECTION = JSFunction.createBuiltinSourceSection("bound function");
        @Node.Child
        protected IndirectCallNode callNode;
        protected final BranchProfile initProfile = BranchProfile.create();

        BoundRootNode(JSContext context) {
            super(context.getLanguage(), SOURCE_SECTION, null);
            this.callNode = Truffle.getRuntime().createIndirectCallNode();
        }

        public Object execute(VirtualFrame frame) {
            Object[] originalArguments = frame.getArguments();
            DynamicObject boundFunction = BoundRootNode.castBoundFunction(JSArguments.getFunctionObject(originalArguments));
            DynamicObject boundTargetFunction = JSFunction.getBoundTargetFunction(boundFunction);
            Object[] boundArguments = JSFunction.getBoundArguments(boundFunction);
            Object boundThis = JSFunction.getBoundThis(boundFunction);
            Object[] argumentValues = JSArguments.extractUserArguments(originalArguments);
            Object[] arguments = BoundRootNode.prependBoundArguments(boundArguments, argumentValues);
            Object[] newArguments = JSArguments.create(boundThis, boundTargetFunction, arguments);
            return this.callNode.call(JSFunction.getFunctionData(boundTargetFunction).getCallTarget(this.initProfile), newArguments);
        }

        protected static Object[] prependBoundArguments(Object[] boundArguments, Object[] argumentValues) {
            Object[] arguments = new Object[boundArguments.length + argumentValues.length];
            System.arraycopy(boundArguments, 0, arguments, 0, boundArguments.length);
            System.arraycopy(argumentValues, 0, arguments, boundArguments.length, argumentValues.length);
            return arguments;
        }

        protected static DynamicObject castBoundFunction(Object functionObj) {
            DynamicObject boundFunction = (DynamicObject)functionObj;
            if (!JSFunction.isBoundFunction(boundFunction)) {
                throw Errors.shouldNotReachHere();
            }
            return boundFunction;
        }
    }

    public static final class ClassPrototypeProxyProperty
    implements PropertyProxy {
        private ClassPrototypeProxyProperty() {
        }

        @Override
        public boolean set(DynamicObject store, Object value) {
            assert (JSFunction.isJSFunction(store));
            JSFunction.setClassPrototype(store, value);
            return true;
        }

        @Override
        public Object get(DynamicObject store) {
            assert (JSFunction.isJSFunction(store));
            return JSFunction.getClassPrototype(store);
        }
    }

    public static enum AsyncGeneratorState {
        SuspendedStart,
        SuspendedYield,
        Executing,
        AwaitingReturn,
        Completed;

    }

    public static enum GeneratorState {
        SuspendedStart,
        SuspendedYield,
        Executing,
        Completed;

    }

    public static class FunctionNamePropertyProxy
    implements PropertyProxy {
        @Override
        public Object get(DynamicObject store) {
            assert (JSFunction.isJSFunction(store));
            if (JSFunction.isBoundFunction(store)) {
                return this.getBoundFunctionName(store);
            }
            return JSFunction.getName(store);
        }

        public String getProfiled(DynamicObject store, BranchProfile isBoundBranch) {
            assert (JSFunction.isJSFunction(store));
            if (JSFunction.isBoundFunction(store)) {
                isBoundBranch.enter();
                return this.getBoundFunctionName(store);
            }
            return JSFunction.getName(store);
        }

        @CompilerDirectives.TruffleBoundary
        private String getBoundFunctionName(DynamicObject store) {
            if (JSFunction.isBoundFunction(store)) {
                return "bound " + this.getBoundFunctionName(JSFunction.getBoundTargetFunction(store));
            }
            return JSFunction.getName(store);
        }
    }

    public static class FunctionLengthPropertyProxy
    implements PropertyProxy {
        @Override
        public Object get(DynamicObject store) {
            assert (JSFunction.isJSFunction(store));
            if (JSFunction.isBoundFunction(store)) {
                return this.getBoundFunctionLength(store);
            }
            return JSFunction.getLength(store);
        }

        public int getProfiled(DynamicObject store, BranchProfile isBoundBranch) {
            assert (JSFunction.isJSFunction(store));
            if (JSFunction.isBoundFunction(store)) {
                isBoundBranch.enter();
                return this.getBoundFunctionLength(store);
            }
            return JSFunction.getLength(store);
        }

        @CompilerDirectives.TruffleBoundary
        private int getBoundFunctionLength(DynamicObject store) {
            if (JSFunction.isBoundFunction(store)) {
                return Math.max(0, this.getBoundFunctionLength(JSFunction.getBoundTargetFunction(store)) - JSFunction.getBoundArguments(store).length);
            }
            return JSFunction.getLength(store);
        }
    }
}

