/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSContextOptions;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.EnumSet;
import java.util.Objects;

public final class JSError
extends JSBuiltinObject {
    public static final String MESSAGE = "message";
    public static final String NAME = "name";
    public static final String CLASS_NAME = "Error";
    public static final String CLASS_NAME_NASHORN_COMPAT = "ErrorNashornCompat";
    public static final String PROTOTYPE_NAME = "Error.prototype";
    public static final HiddenKey EXCEPTION_PROPERTY_NAME = new HiddenKey("Exception");
    public static final String STACK_NAME = "stack";
    public static final HiddenKey FORMATTED_STACK_NAME = new HiddenKey("FormattedStack");
    public static final String PREPARE_STACK_TRACE_NAME = "prepareStackTrace";
    public static final String LINE_NUMBER_PROPERTY_NAME = "lineNumber";
    public static final String COLUMN_NUMBER_PROPERTY_NAME = "columnNumber";
    public static final int DEFAULT_COLUMN_NUMBER = -1;
    public static final String STACK_TRACE_LIMIT_PROPERTY_NAME = "stackTraceLimit";
    public static final String ANONYMOUS_FUNCTION_NAME_STACK_TRACE = JSTruffleOptions.NashornCompatibilityMode ? "<program>" : "<anonymous>";
    public static final JSError INSTANCE = new JSError();
    private static final Property MESSAGE_PROPERTY;
    private static final String CALL_SITE_CLASS_NAME = "CallSite";
    public static final String CALL_SITE_PROTOTYPE_NAME = "CallSite.prototype";
    public static final HiddenKey STACK_TRACE_ELEMENT_PROPERTY_NAME;
    private static final Property STACK_TRACE_ELEMENT_PROPERTY;
    public static final PropertyProxy STACK_PROXY;

    private JSError() {
    }

    public static DynamicObject create(JSErrorType errorType, JSRealm realm, Object message) {
        String msg;
        DynamicObject obj;
        assert (message instanceof String || message == Undefined.instance);
        JSContext context = realm.getContext();
        DynamicObject prototype = realm.getErrorPrototype(errorType);
        if (message == Undefined.instance) {
            obj = JSObject.createWithPrototype(context, context.getErrorFactory(errorType, false), realm, prototype, new Object[0]);
            msg = null;
        } else {
            obj = JSObject.createWithPrototype(context, context.getErrorFactory(errorType, true), realm, prototype, message);
            msg = (String)message;
        }
        JSError.setException(realm, obj, JSException.createCapture(errorType, msg, obj), false);
        return obj;
    }

    public static DynamicObject createFromJSException(JSException exception, JSRealm realm, String message) {
        JSErrorType errorType = exception.getErrorType();
        JSContext context = realm.getContext();
        DynamicObject prototype = realm.getErrorPrototype(errorType);
        DynamicObject obj = JSObject.createWithPrototype(context, context.getErrorFactory(errorType, true), realm, prototype, Objects.requireNonNull(message));
        JSError.setException(realm, obj, exception, JSTruffleOptions.NashornCompatibilityMode);
        return obj;
    }

    private static DynamicObject createErrorPrototype(JSRealm realm, JSErrorType errorType) {
        JSContext ctx = realm.getContext();
        DynamicObject proto = errorType == JSErrorType.Error ? realm.getObjectPrototype() : realm.getErrorPrototype(JSErrorType.Error);
        DynamicObject errorPrototype = JSObject.createInit(realm, proto, (JSClass)(ctx.getEcmaScriptVersion() < 6 ? INSTANCE : JSUserObject.INSTANCE));
        JSObjectUtil.putDataProperty(ctx, errorPrototype, MESSAGE, "", JSAttributes.getDefaultNotEnumerable());
        if (errorType == JSErrorType.Error) {
            JSObjectUtil.putFunctionsFromContainer(realm, errorPrototype, PROTOTYPE_NAME);
            if (ctx.isOptionNashornCompatibilityMode()) {
                JSObjectUtil.putFunctionsFromContainer(realm, errorPrototype, CLASS_NAME_NASHORN_COMPAT);
            }
        }
        return errorPrototype;
    }

    public static JSConstructor createErrorConstructor(JSRealm realm, JSErrorType errorType) {
        JSContext context = realm.getContext();
        String name = errorType.toString();
        DynamicObject errorConstructor = realm.lookupFunction("%Constructors%", name);
        DynamicObject classPrototype = JSError.createErrorPrototype(realm, errorType);
        if (errorType != JSErrorType.Error) {
            JSObject.setPrototype(errorConstructor, realm.getErrorConstructor(JSErrorType.Error));
        }
        JSObjectUtil.putConstructorProperty(context, classPrototype, errorConstructor);
        JSObjectUtil.putDataProperty(context, classPrototype, NAME, name, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putConstructorPrototypeProperty(context, errorConstructor, classPrototype);
        if (errorType == JSErrorType.Error) {
            JSObjectUtil.putFunctionsFromContainer(realm, errorConstructor, CLASS_NAME);
            JSObjectUtil.putDataProperty(context, errorConstructor, STACK_TRACE_LIMIT_PROPERTY_NAME, JSContextOptions.STACK_TRACE_LIMIT.getValue(realm.getOptions()), JSAttributes.getDefault());
        }
        return new JSConstructor(errorConstructor, classPrototype);
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject errorPrototype) {
        return JSObjectUtil.getProtoChildShape(errorPrototype, INSTANCE, context);
    }

    public static Shape addMessagePropertyToShape(Shape shape) {
        return shape.addProperty(MESSAGE_PROPERTY);
    }

    private static DynamicObject createCallSitePrototype(JSRealm realm) {
        DynamicObject proto = realm.getObjectPrototype();
        DynamicObject callSitePrototype = JSObject.createInit(realm, proto, (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(realm, callSitePrototype, CALL_SITE_PROTOTYPE_NAME);
        return callSitePrototype;
    }

    public static JSConstructor createCallSiteConstructor(JSRealm realm) {
        JSContext context = realm.getContext();
        DynamicObject constructor = JSFunction.createNamedEmptyFunction(realm, CALL_SITE_CLASS_NAME);
        DynamicObject prototype = JSError.createCallSitePrototype(realm);
        JSObjectUtil.putConstructorProperty(context, prototype, constructor);
        JSObjectUtil.putConstructorPrototypeProperty(context, constructor, prototype);
        return new JSConstructor(constructor, prototype);
    }

    public static Shape makeInitialCallSiteShape(JSContext context, DynamicObject callSitePrototype) {
        return JSObjectUtil.getProtoChildShape(callSitePrototype, JSUserObject.INSTANCE, context).addProperty(STACK_TRACE_ELEMENT_PROPERTY);
    }

    public static void setLineNumber(JSContext context, DynamicObject errorObj, Object lineNumber) {
        JSError.setErrorProperty(context, errorObj, LINE_NUMBER_PROPERTY_NAME, lineNumber);
    }

    public static void setColumnNumber(JSContext context, DynamicObject errorObj, Object columnNumber) {
        JSError.setErrorProperty(context, errorObj, COLUMN_NUMBER_PROPERTY_NAME, columnNumber);
    }

    public static GraalJSException getException(DynamicObject errorObj) {
        Object exception = errorObj.get((Object)EXCEPTION_PROPERTY_NAME);
        return exception instanceof GraalJSException ? (GraalJSException)exception : null;
    }

    @CompilerDirectives.TruffleBoundary
    private static DynamicObject setException(JSRealm realm, DynamicObject errorObj, GraalJSException exception, boolean defaultColumnNumber) {
        assert (JSError.isJSError(errorObj));
        JSError.defineStackProperty(realm, errorObj, exception);
        if (JSTruffleOptions.NashornCompatibilityMode && exception.getJSStackTrace().length > 0) {
            JSContext context = realm.getContext();
            GraalJSException.JSStackTraceElement topStackTraceElement = exception.getJSStackTrace()[0];
            JSError.setLineNumber(context, errorObj, topStackTraceElement.getLineNumber());
            JSError.setColumnNumber(context, errorObj, defaultColumnNumber ? -1 : topStackTraceElement.getColumnNumber());
        }
        return errorObj;
    }

    private static void setErrorProperty(JSContext context, DynamicObject errorObj, Object key, Object value) {
        if (!errorObj.set(key, value)) {
            JSObjectUtil.putDataProperty(context, errorObj, key, value, JSAttributes.getDefaultNotEnumerable());
        }
    }

    private static void defineStackProperty(JSRealm realm, DynamicObject errorObj, GraalJSException exception) {
        JSContext context = realm.getContext();
        JSError.setErrorProperty(context, errorObj, EXCEPTION_PROPERTY_NAME, exception);
        errorObj.define((Object)FORMATTED_STACK_NAME, null);
        JSObjectUtil.defineProxyProperty(errorObj, STACK_NAME, STACK_PROXY, JSAttributes.getDefaultNotEnumerable() | 0x10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static Object prepareStack(JSRealm realm, DynamicObject errorObj, GraalJSException exception) {
        boolean inPrepareStackTrace;
        DynamicObject error = realm.getErrorConstructor(JSErrorType.Error);
        Object prepareStackTrace = JSObject.get(error, (Object)PREPARE_STACK_TRACE_NAME);
        GraalJSException.JSStackTraceElement[] jsStackTrace = exception.getJSStackTrace();
        if (JSFunction.isJSFunction(prepareStackTrace) && !(inPrepareStackTrace = realm.isPreparingStackTrace())) {
            try {
                realm.setPreparingStackTrace(true);
                Object object = JSError.prepareStackWithUserFunction(realm, (DynamicObject)prepareStackTrace, errorObj, jsStackTrace);
                return object;
            }
            finally {
                realm.setPreparingStackTrace(false);
            }
        }
        return JSError.formatStackTrace(jsStackTrace, errorObj, realm);
    }

    private static Object prepareStackWithUserFunction(JSRealm realm, DynamicObject prepareStackTraceFun, DynamicObject errorObj, GraalJSException.JSStackTraceElement[] stackTrace) {
        Object[] elements = new Object[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            elements[i] = JSError.prepareStackElement(realm, stackTrace[i]);
        }
        DynamicObject structuredStackTrace = JSArray.createConstant(realm.getContext(), elements);
        try {
            return JSFunction.call(prepareStackTraceFun, errorObj, new Object[]{errorObj, structuredStackTrace});
        }
        catch (Exception ex) {
            return JSError.formatStackTrace(stackTrace, errorObj, realm);
        }
    }

    private static Object prepareStackElement(JSRealm realm, GraalJSException.JSStackTraceElement stackTraceElement) {
        return JSObject.createWithRealm(realm.getContext(), realm.getContext().getCallSiteFactory(), realm, stackTraceElement);
    }

    private static String getMessage(DynamicObject errorObj) {
        Object message = JSObject.get(errorObj, (Object)MESSAGE);
        return message == Undefined.instance ? null : JSRuntime.toString(message);
    }

    private static String getName(DynamicObject errorObj) {
        Object name = JSObject.get(errorObj, (Object)NAME);
        return name == Undefined.instance ? null : JSRuntime.toString(name);
    }

    private static boolean isInstanceOfJSError(DynamicObject errorObj, JSRealm realm) {
        DynamicObject errorPrototype = realm.getErrorPrototype(JSErrorType.Error);
        return JSRuntime.isPrototypeOf(errorObj, errorPrototype);
    }

    @CompilerDirectives.TruffleBoundary
    private static String formatStackTrace(GraalJSException.JSStackTraceElement[] stackTrace, DynamicObject errObj, JSRealm realm) {
        StringBuilder builder = new StringBuilder();
        if (!JSTruffleOptions.NashornCompatibilityMode || JSError.isInstanceOfJSError(errObj, realm)) {
            String name = JSError.getName(errObj);
            String message = JSError.getMessage(errObj);
            if (name != null) {
                builder.append(name);
            } else {
                builder.append(CLASS_NAME);
            }
            if (message != null && message.length() > 0) {
                if (builder.length() != 0) {
                    builder.append(": ");
                }
                builder.append(message);
            }
        } else {
            builder.append(JSObject.defaultToString(errObj));
        }
        JSError.formatStackTraceIntl(stackTrace, builder, realm.getContext());
        return builder.toString();
    }

    private static void formatStackTraceIntl(GraalJSException.JSStackTraceElement[] stackTrace, StringBuilder builder, JSContext context) {
        for (GraalJSException.JSStackTraceElement elem : stackTrace) {
            String fileName;
            boolean includeMethodName;
            builder.append('\n');
            builder.append(JSTruffleOptions.NashornCompatibilityMode ? "\tat " : "    at ");
            if (context.isOptionV8CompatibilityMode()) {
                builder.append(elem.toString());
                continue;
            }
            String className = JSTruffleOptions.NashornCompatibilityMode ? null : elem.getClassName();
            String methodName = JSError.correctMethodName(elem.getFunctionName());
            boolean bl = includeMethodName = JSTruffleOptions.NashornCompatibilityMode || className != null || !ANONYMOUS_FUNCTION_NAME_STACK_TRACE.equals(methodName);
            if (includeMethodName) {
                if (className != null) {
                    builder.append(className).append('.');
                }
                builder.append(methodName);
                builder.append(" (");
            }
            if ("<builtin>".equals(fileName = elem.getFileName())) {
                builder.append("native");
            } else {
                builder.append(fileName);
                builder.append(":");
                builder.append(elem.getLineNumber());
                if (!JSTruffleOptions.NashornCompatibilityMode) {
                    builder.append(":");
                    builder.append(elem.getColumnNumber());
                }
            }
            if (!includeMethodName) continue;
            builder.append(")");
        }
    }

    public static String correctMethodName(String methodName) {
        int idx;
        if (methodName == null) {
            return "";
        }
        if (methodName.isEmpty()) {
            return ANONYMOUS_FUNCTION_NAME_STACK_TRACE;
        }
        if (Boundaries.stringEndsWith(methodName, "]") && (idx = Boundaries.stringLastIndexOf(methodName, '[')) >= 0) {
            return Boundaries.substring(methodName, idx);
        }
        idx = Boundaries.stringLastIndexOf(methodName, '.');
        if (idx >= 0) {
            return Boundaries.substring(methodName, idx + 1);
        }
        return methodName;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    public static boolean isJSError(Object obj) {
        return JSObject.isDynamicObject(obj) && JSError.isJSError((DynamicObject)obj);
    }

    public static boolean isJSError(DynamicObject obj) {
        return JSError.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth) {
        String messageStr;
        if (JSTruffleOptions.NashornCompatibilityMode) {
            return super.safeToString(obj, depth);
        }
        Object name = JSError.getPropertyWithoutSideEffect(obj, NAME);
        Object message = JSError.getPropertyWithoutSideEffect(obj, MESSAGE);
        String nameStr = name != null ? JSRuntime.safeToString(name, depth, obj, false) : CLASS_NAME;
        String string = messageStr = message != null ? JSRuntime.safeToString(message, depth, obj, false) : "";
        if (nameStr.isEmpty()) {
            if (messageStr.isEmpty()) {
                return CLASS_NAME;
            }
            return messageStr;
        }
        if (messageStr.isEmpty()) {
            return nameStr;
        }
        return nameStr + ": " + messageStr;
    }

    private static Object getPropertyWithoutSideEffect(DynamicObject obj, String key) {
        Object value = obj.get((Object)key);
        if (value == null) {
            if (!JSProxy.isProxy(obj)) {
                return JSError.getPropertyWithoutSideEffect(JSObject.getPrototype(obj), key);
            }
            return null;
        }
        if (value instanceof Accessor) {
            return "{Accessor}";
        }
        if (value instanceof PropertyProxy) {
            return null;
        }
        return value;
    }

    @Override
    public boolean hasOnlyShapeProperties(DynamicObject obj) {
        return true;
    }

    static {
        STACK_TRACE_ELEMENT_PROPERTY_NAME = new HiddenKey("StackTraceElement");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        MESSAGE_PROPERTY = JSObjectUtil.makeDataProperty(MESSAGE, allocator.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), JSAttributes.getDefaultNotEnumerable());
        allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        STACK_TRACE_ELEMENT_PROPERTY = JSObjectUtil.makeHiddenProperty(STACK_TRACE_ELEMENT_PROPERTY_NAME, allocator.locationForType(Object.class));
        STACK_PROXY = new PropertyProxy(){

            @Override
            public Object get(DynamicObject store) {
                Object value = store.get((Object)FORMATTED_STACK_NAME);
                if (value == null) {
                    GraalJSException truffleException = JSError.getException(store);
                    if (truffleException == null) {
                        value = Undefined.instance;
                    } else {
                        JSRealm realm = this.currentRealm(store);
                        value = JSError.prepareStack(realm, store, truffleException);
                    }
                    Object currentValue = store.get((Object)FORMATTED_STACK_NAME);
                    if (currentValue == null) {
                        store.set((Object)FORMATTED_STACK_NAME, value);
                    } else {
                        value = currentValue;
                    }
                }
                return value;
            }

            private JSRealm currentRealm(DynamicObject store) {
                return JSObject.getJSContext(store).getRealm();
            }

            @Override
            public boolean set(DynamicObject store, Object value) {
                store.set((Object)FORMATTED_STACK_NAME, value);
                return true;
            }
        };
    }
}

