/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSPrimitiveObject;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import java.util.EnumSet;

public final class JSBigInt
extends JSPrimitiveObject
implements JSConstructorFactory.Default.WithFunctions {
    public static final String TYPE_NAME = "bigint";
    public static final String CLASS_NAME = "BigInt";
    public static final String PROTOTYPE_NAME = "BigInt.prototype";
    public static final JSBigInt INSTANCE = new JSBigInt();
    private static final Property VALUE_PROPERTY;
    private static final HiddenKey VALUE_ID;

    private JSBigInt() {
    }

    public static DynamicObject create(JSContext context, BigInt value) {
        DynamicObject objBigInt = JSObject.create(context, context.getBigIntFactory(), value);
        assert (JSBigInt.isJSBigInt(objBigInt));
        return objBigInt;
    }

    private static BigInt getBigIntegerField(DynamicObject obj) {
        assert (JSBigInt.isJSBigInt(obj));
        return (BigInt)VALUE_PROPERTY.get(obj, JSBigInt.isJSBigInt(obj));
    }

    public static BigInt valueOf(DynamicObject obj) {
        return JSBigInt.getBigIntegerField(obj);
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext context = realm.getContext();
        DynamicObject bigIntPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(context, bigIntPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, bigIntPrototype, PROTOTYPE_NAME);
        JSObjectUtil.putDataProperty(context, bigIntPrototype, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return bigIntPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = initialShape.addProperty(VALUE_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static boolean isJSBigInt(Object obj) {
        return JSObject.isDynamicObject(obj) && JSBigInt.isJSBigInt((DynamicObject)obj);
    }

    public static boolean isJSBigInt(DynamicObject obj) {
        return JSBigInt.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth) {
        if (JSTruffleOptions.NashornCompatibilityMode) {
            return super.safeToString(obj, depth);
        }
        BigInt primitiveValue = JSBigInt.valueOf(obj);
        return JSRuntime.objectToConsoleString(obj, this.getBuiltinToStringTag(obj), depth, new String[]{"PrimitiveValue"}, new Object[]{primitiveValue});
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getBigIntPrototype();
    }

    static {
        VALUE_ID = new HiddenKey("value");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        VALUE_PROPERTY = JSObjectUtil.makeHiddenProperty(VALUE_ID, allocator.locationForType(BigInt.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
    }
}

