/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedJSObjectArray;

public final class ContiguousJSObjectArray
extends AbstractContiguousJSObjectArray {
    private static final ContiguousJSObjectArray CONTIGUOUS_JSOBJECT_ARRAY = new ContiguousJSObjectArray(0, ContiguousJSObjectArray.createCache());

    public static ContiguousJSObjectArray makeContiguousJSObjectArray(DynamicObject object, long length, DynamicObject[] array, long indexOffset, int arrayOffset, int usedLength, int integrityLevel) {
        ContiguousJSObjectArray arrayType = (ContiguousJSObjectArray)ContiguousJSObjectArray.createContiguousJSObjectArray().setIntegrityLevel(integrityLevel);
        ContiguousJSObjectArray.setArrayProperties(object, array, length, usedLength, indexOffset, arrayOffset);
        return arrayType;
    }

    private static ContiguousJSObjectArray createContiguousJSObjectArray() {
        return CONTIGUOUS_JSOBJECT_ARRAY;
    }

    private ContiguousJSObjectArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    protected int prepareInBounds(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.prepareInBoundsContiguous(object, index, condition, profile);
    }

    @Override
    protected int prepareSupported(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.prepareSupportedContiguous(object, index, condition, profile);
    }

    @Override
    public boolean isSupported(DynamicObject object, long index, boolean condition) {
        return this.isSupportedContiguous(object, index, condition);
    }

    @Override
    public HolesJSObjectArray toHoles(DynamicObject object, long index, Object value, boolean condition) {
        DynamicObject[] array = ContiguousJSObjectArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ContiguousJSObjectArray.getUsedLength(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        long indexOffset = this.getIndexOffset(object, condition);
        HolesJSObjectArray newArray = HolesJSObjectArray.makeHolesJSObjectArray(object, length, array, indexOffset, arrayOffset, usedLength, 0, this.integrityLevel);
        if (JSTruffleOptions.TraceArrayTransitions) {
            ContiguousJSObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ZeroBasedJSObjectArray toNonContiguous(DynamicObject object, int index, Object value, boolean condition, ScriptArray.ProfileHolder profile) {
        this.setSupported(object, index, (DynamicObject)value, condition, profile);
        DynamicObject[] array = ContiguousJSObjectArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ContiguousJSObjectArray.getUsedLength(object, condition);
        ZeroBasedJSObjectArray newArray = ZeroBasedJSObjectArray.makeZeroBasedJSObjectArray(object, length, usedLength, array, this.integrityLevel);
        if (JSTruffleOptions.TraceArrayTransitions) {
            ContiguousJSObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ContiguousObjectArray toObject(DynamicObject object, long index, Object value, boolean condition) {
        DynamicObject[] array = ContiguousJSObjectArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ContiguousJSObjectArray.getUsedLength(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        long indexOffset = this.getIndexOffset(object, condition);
        Object[] doubleCopy = ArrayCopy.jsobjectToObject(array, arrayOffset, usedLength);
        ContiguousObjectArray newArray = ContiguousObjectArray.makeContiguousObjectArray(object, length, doubleCopy, indexOffset, arrayOffset, usedLength, this.integrityLevel);
        if (JSTruffleOptions.TraceArrayTransitions) {
            ContiguousJSObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        return this.removeRangeContiguous(object, start, end);
    }

    @Override
    protected ContiguousJSObjectArray withIntegrityLevel(int newIntegrityLevel) {
        return new ContiguousJSObjectArray(newIntegrityLevel, this.cache);
    }
}

