/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNodeGen;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;

@GenerateUncached
public abstract class IsConstructorNode
extends JavaScriptBaseNode {
    protected IsConstructorNode() {
    }

    public abstract boolean executeBoolean(Object var1);

    @Specialization(guards={"isJSFunction(function)"})
    protected static boolean doJSFunction(DynamicObject function) {
        return JSFunction.isConstructor(function);
    }

    @Specialization(guards={"isJSProxy(proxy)"})
    protected static boolean doJSProxy(DynamicObject proxy) {
        return JSRuntime.isConstructorProxy(proxy);
    }

    @Specialization
    protected static boolean doString(String string) {
        return false;
    }

    @Specialization(guards={"!isJSFunction(other)", "!isJSProxy(other)"})
    protected static boolean doOther(Object other) {
        return false;
    }

    public static IsConstructorNode create() {
        return IsConstructorNodeGen.create();
    }
}

