/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;

public class IteratorNextUnaryNode
extends JavaScriptNode {
    @Node.Child
    private JSFunctionCallNode methodCallNode;
    @Node.Child
    private IsJSObjectNode isObjectNode;
    @Node.Child
    private JavaScriptNode iteratorNode;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected IteratorNextUnaryNode(JavaScriptNode iteratorNode) {
        this.iteratorNode = iteratorNode;
        this.methodCallNode = JSFunctionCallNode.createCall();
        this.isObjectNode = IsJSObjectNode.create();
    }

    public static JavaScriptNode create(JavaScriptNode iteratorNode) {
        return new IteratorNextUnaryNode(iteratorNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        IteratorRecord iterator = (IteratorRecord)this.iteratorNode.execute(frame);
        return this.execute(iterator);
    }

    public Object execute(IteratorRecord iteratorRecord) {
        Object next;
        DynamicObject iterator = iteratorRecord.getIterator();
        Object nextResult = this.methodCallNode.executeCall(JSArguments.createZeroArg(iterator, next = iteratorRecord.getNextMethod()));
        if (!this.isObjectNode.executeBoolean(nextResult)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorIteratorResultNotObject(nextResult, this);
        }
        return nextResult;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return IteratorNextUnaryNode.create(IteratorNextUnaryNode.cloneUninitialized(this.iteratorNode));
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == TruffleObject.class;
    }
}

