/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.builtins.Builtin;
import com.oracle.truffle.js.runtime.builtins.JSFunctionLookup;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public abstract class JSBuiltinLookup
implements JSFunctionLookup {
    private final Map<String, JSBuiltinsContainer> containers = new HashMap<String, JSBuiltinsContainer>();

    public final void defineBuiltins(JSBuiltinsContainer container) {
        assert (container.getName() != null);
        this.defineBuiltins(container.getName(), container);
    }

    public final void defineBuiltins(String containerName, JSBuiltinsContainer container) {
        JSBuiltinsContainer currentContainer = this.containers.get(containerName);
        if (currentContainer == null) {
            this.containers.put(containerName, container);
        } else {
            currentContainer.putAll(container);
        }
    }

    @Override
    public Builtin lookupBuiltinFunction(String containerName, String methodName) {
        return this.lookupBuiltin(containerName, methodName);
    }

    @Override
    public void iterateBuiltinFunctions(String containerName, Consumer<Builtin> consumer) {
        JSBuiltinsContainer container = this.containers.get(containerName);
        if (container != null) {
            container.forEachBuiltin(consumer);
        }
    }

    private JSBuiltin lookupBuiltin(String containerName, String name) {
        JSBuiltinsContainer builtins = this.containers.get(containerName);
        if (builtins == null) {
            return null;
        }
        return builtins.lookupByName(name);
    }
}

