/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.cos;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.classpath.AbstractProjectClassPathImpl;
import org.netbeans.modules.maven.classpath.RuntimeClassPathImpl;
import org.netbeans.modules.maven.classpath.TestRuntimeClassPathImpl;
import org.netbeans.modules.maven.cos.CosChecker;
import org.netbeans.modules.maven.customizer.RunJarPanel;
import org.netbeans.modules.maven.spi.cos.CompileOnSaveSkipper;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class OldJavaRunnerCOS {
    private static final Logger LOG = Logger.getLogger(OldJavaRunnerCOS.class.getName());
    private static final String STARTUP_ARGS_KEY = "run.jvmargs.ide";

    static boolean checkRunMainClass(RunConfig config) {
        String actionName = config.getActionName();
        if (RunUtils.hasApplicationCompileOnSaveEnabled(config) && ("jar".equals(((NbMavenProject)config.getProject().getLookup().lookup(NbMavenProject.class)).getPackagingType()) && ("run".equals(actionName) || "debug".equals(actionName) || "profile".equals(actionName)) || "run.single.main".equals(actionName) || "debug.single.main".equals(actionName) || "profile.single.main".equals(actionName))) {
            long stamp = CosChecker.getLastCoSLastTouch(config, false);
            if (CosChecker.checkImportantFiles(stamp, config)) {
                return true;
            }
            for (CompileOnSaveSkipper skipper : Lookup.getDefault().lookupAll(CompileOnSaveSkipper.class)) {
                if (!skipper.skip(config, false, stamp)) continue;
                return true;
            }
            return OldJavaRunnerCOS.deprecatedJavaRunnerApproach(config, actionName);
        }
        return true;
    }

    static boolean checkRunTest(RunConfig config) {
        String actionName = config.getActionName();
        if (!("test.single".equals(actionName) || "debug.test.single".equals(actionName) || "profile.test.single".equals(actionName))) {
            return true;
        }
        if (RunUtils.hasTestCompileOnSaveEnabled(config)) {
            String testng = PluginPropertyUtils.getPluginProperty(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "testNGArtifactName", "test", "testNGArtifactName");
            if (testng == null) {
                testng = "org.testng:testng";
            }
            List deps = config.getMavenProject().getTestDependencies();
            boolean haveJUnit = false;
            boolean haveTestNG = false;
            String testngVersion = null;
            for (Dependency d : deps) {
                if (d.getManagementKey().startsWith(testng)) {
                    testngVersion = d.getVersion();
                    haveTestNG = true;
                    continue;
                }
                if (!d.getManagementKey().startsWith("junit:junit")) continue;
                haveJUnit = true;
            }
            if (haveJUnit && haveTestNG && new ComparableVersion("6.5.1").compareTo(new ComparableVersion(testngVersion)) >= 0) {
                return true;
            }
            String test = config.getProperties().get("test");
            if (test == null) {
                return true;
            }
            long stamp = CosChecker.getLastCoSLastTouch(config, true);
            if (CosChecker.checkImportantFiles(stamp, config)) {
                return true;
            }
            for (CompileOnSaveSkipper skipper : Lookup.getDefault().lookupAll(CompileOnSaveSkipper.class)) {
                if (!skipper.skip(config, true, stamp)) continue;
                return true;
            }
            return OldJavaRunnerCOS.deprecatedJavaRunnerApproachTest(config, actionName);
        }
        CosChecker.warnNoTestCoS(config);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean deprecatedJavaRunnerApproachTest(final RunConfig config, String actionName) {
        String test = config.getProperties().get("test");
        final HashMap<String, Object> params = new HashMap<String, Object>();
        FileObject selected = config.getSelectedFileObject();
        ProjectSourcesClassPathProvider cpp = (ProjectSourcesClassPathProvider)config.getProject().getLookup().lookup(ProjectSourcesClassPathProvider.class);
        ClassPath srcs = cpp.getProjectSourcesClassPath("classpath/source");
        ClassPath[] cps = cpp.getProjectClassPaths("classpath/source");
        ClassPath testcp = ClassPathSupport.createProxyClassPath((ClassPath[])cps);
        if (selected != null) {
            String path = srcs.getResourceName(selected);
            if (path != null) {
                String nameExt = selected.getNameExt().replace(".java", "Test.java");
                FileObject testFo = testcp.findResource(path = path.replace(selected.getNameExt(), nameExt));
                if (testFo == null) return true;
                selected = testFo;
            } else {
                path = testcp.getResourceName(selected);
                if (path == null) {
                    return true;
                }
            }
        } else {
            selected = testcp.findResource(test = test + ".java");
            if (selected == null) {
                List<FileObject> mainSourceRoots = Arrays.asList(srcs.getRoots());
                block10: for (Object root : testcp.getRoots()) {
                    if (mainSourceRoots.contains(root)) continue;
                    Enumeration enumeration = root.getData(true);
                    while (enumeration.hasMoreElements()) {
                        FileObject fo = (FileObject)enumeration.nextElement();
                        if (!fo.getNameExt().equals(test)) continue;
                        selected = fo;
                        break block10;
                    }
                }
            }
        }
        if (selected == null) {
            return true;
        }
        params.put("execute.file", selected);
        params.put("platform", ((ActiveJ2SEPlatformProvider)config.getProject().getLookup().lookup(ActiveJ2SEPlatformProvider.class)).getJavaPlatform());
        ArrayList<String> jvmProps = new ArrayList<String>();
        HashSet<String> jvmPropNames = new HashSet<String>();
        params.put("project.name", config.getExecutionName() + "/CoS");
        String dir = PluginPropertyUtils.getPluginProperty(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "basedir", "test", "basedir");
        jvmPropNames.add("basedir");
        if (dir != null) {
            params.put("work.dir", dir);
            jvmProps.add("-Dbasedir=\"" + dir + "\"");
        } else {
            params.put("work.dir", config.getExecutionDirectory());
            jvmProps.add("-Dbasedir=\"" + config.getExecutionDirectory().getAbsolutePath() + "\"");
        }
        Properties sysProps = PluginPropertyUtils.getPluginPropertyParameter(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "systemProperties", "test");
        if (sysProps != null) {
            for (Map.Entry entry : sysProps.entrySet()) {
                jvmProps.add("-D" + entry.getKey() + "=" + entry.getValue());
                jvmPropNames.add((String)entry.getKey());
            }
        }
        for (Map.Entry entry : config.getProperties().entrySet()) {
            if ("maven.surefire.debug".equals(entry.getKey()) || "jpda.listen".equals(entry.getKey()) || "jpda.stopclass".equals(entry.getKey())) continue;
            if ("nb.single.run.methodName".equals(entry.getKey())) {
                params.put("methodname", entry.getValue());
                actionName = "test.single".equals(actionName) ? "run.single.method" : "debug.single.method";
                continue;
            }
            if (jvmPropNames.contains((String)entry.getKey())) continue;
            jvmProps.add("-D" + entry.getKey() + "=" + entry.getValue());
            jvmPropNames.add((String)entry.getKey());
        }
        String argLine = PluginPropertyUtils.getPluginProperty(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "argLine", "test", "argLine");
        if (argLine != null) {
            try {
                String[] stringArray = CommandLineUtils.translateCommandline((String)argLine);
                jvmProps.addAll(Arrays.asList(stringArray));
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        } else {
            argLine = config.getProperties().get("argLine");
            if (argLine != null) {
                try {
                    jvmProps.addAll(CosChecker.extractDebugJVMOptions(argLine));
                }
                catch (CommandLineException commandLineException) {
                    LOG.log(Level.INFO, "error parsing argLine property:" + argLine, commandLineException);
                    if ("debug.test.single".equals(actionName)) {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Error parsing argLine property, arguments will not be passed to internal execution. Error: " + commandLineException.getLocalizedMessage()), 0);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.INFO, "error extracting debug params from argLine property:" + argLine, exception);
                }
            }
        }
        String[] stringArray = PluginPropertyUtils.getPluginPropertyList(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin", "additionalClasspathElements", "additionalClasspathElement", "test");
        ClassPath cp = OldJavaRunnerCOS.createRuntimeClassPath(config.getMavenProject(), true);
        if (stringArray != null) {
            ArrayList<URL> roots = new ArrayList<URL>();
            File base = FileUtil.toFile((FileObject)config.getProject().getProjectDirectory());
            for (String add : stringArray) {
                File root = FileUtilities.resolveFilePath(base, add);
                if (root != null) {
                    try {
                        URL url = Utilities.toURI((File)root).toURL();
                        if (FileUtil.isArchiveFile((URL)url)) {
                            url = FileUtil.getArchiveRoot((URL)url);
                        }
                        roots.add(url);
                    }
                    catch (MalformedURLException ex) {
                        Logger.getLogger(CosChecker.class.getName()).log(Level.INFO, "Cannot convert ''{0}'' to URL", add);
                    }
                    continue;
                }
                Logger.getLogger(CosChecker.class.getName()).log(Level.INFO, "Cannot convert ''{0}'' to URL.", add);
            }
            ClassPath addCp = ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[roots.size()]));
            cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cp, addCp});
        }
        params.put("execute.classpath", cp);
        params.put("run.jvmargs", jvmProps);
        params.put("maven.disableSources", Boolean.TRUE);
        final String action2Quick = OldJavaRunnerCOS.action2Quick(actionName);
        boolean supported = JavaRunner.isSupported((String)action2Quick, params);
        if (!supported) return true;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ScanDialog.runWhenScanFinished((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (SwingUtilities.isEventDispatchThread()) {
                                CosChecker.RP.post((Runnable)this);
                                return;
                            }
                            try {
                                OldJavaRunnerCOS.collectStartupArgs(config, params);
                                ExecutorTask tsk = JavaRunner.execute((String)action2Quick, (Map)params);
                                CosChecker.warnCoSInOutput(tsk, config);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (UnsupportedOperationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            finally {
                                CosChecker.touchCoSTimeStamp(config, true);
                                if (RunUtils.hasApplicationCompileOnSaveEnabled(config)) {
                                    CosChecker.touchCoSTimeStamp(config, false);
                                } else {
                                    CosChecker.deleteCoSTimeStamp(config, false);
                                }
                            }
                        }
                    }, (String)config.getTaskDisplayName());
                }
            });
            return false;
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    static boolean deprecatedJavaRunnerApproach(final RunConfig config, String actionName) {
        String action2Quick;
        boolean supported;
        final HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("project.name", config.getExecutionName() + "/CoS");
        String proppath = config.getProperties().get("exec.workingdir");
        if (proppath != null) {
            params.put("work.dir", FileUtil.normalizeFile((File)new File(proppath)));
        } else {
            params.put("work.dir", config.getExecutionDirectory());
        }
        if ("run.single.main".equals(actionName) || "debug.single.main".equals(actionName) || "profile.single.main".equals(actionName)) {
            FileObject selected = config.getSelectedFileObject();
            ClassPath srcs = ((ProjectSourcesClassPathProvider)config.getProject().getLookup().lookup(ProjectSourcesClassPathProvider.class)).getProjectSourcesClassPath("classpath/source");
            String path = srcs.getResourceName(selected);
            if (path == null) {
                return true;
            }
            params.put("execute.file", selected);
        } else {
            params.put("execute.classpath", OldJavaRunnerCOS.createRuntimeClassPath(config.getMavenProject(), false));
        }
        String exargs = config.getProperties().get("exec.args");
        if (exargs != null) {
            String[] args = RunJarPanel.splitAll(exargs);
            if (params.get("execute.file") == null) {
                params.put("classname", args[1]);
            }
            String[] appargs = args[2].split(" ");
            params.put("application.args", Arrays.asList(appargs));
            try {
                params.put("run.jvmargs", CosChecker.extractDebugJVMOptions(args[0]));
            }
            catch (CommandLineException cli) {
                LOG.log(Level.INFO, "error parsing exec.args property:" + args[0], cli);
                if ("debug.single.main".equals(actionName) || "debug".equals(actionName)) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("Error parsing exec.args property, arguments will not be passed to internal execution. Error: " + cli.getLocalizedMessage()), 0);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.INFO, "error extracting debug params from exec.args property:" + args[0], ex);
            }
        }
        params.put("platform", ((ActiveJ2SEPlatformProvider)config.getProject().getLookup().lookup(ActiveJ2SEPlatformProvider.class)).getJavaPlatform());
        params.put("maven.disableSources", Boolean.TRUE);
        if ((params.get("execute.file") != null || params.get("classname") != null) && (supported = JavaRunner.isSupported((String)(action2Quick = OldJavaRunnerCOS.action2Quick(actionName)), params))) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ScanDialog.runWhenScanFinished((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (SwingUtilities.isEventDispatchThread()) {
                                    CosChecker.RP.post((Runnable)this);
                                    return;
                                }
                                try {
                                    OldJavaRunnerCOS.collectStartupArgs(config, params);
                                    ExecutorTask tsk = JavaRunner.execute((String)action2Quick, (Map)params);
                                    CosChecker.warnCoSInOutput(tsk, config);
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                catch (UnsupportedOperationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                finally {
                                    if (RunUtils.hasApplicationCompileOnSaveEnabled(config)) {
                                        CosChecker.touchCoSTimeStamp(config, false);
                                    }
                                }
                            }
                        }, (String)config.getTaskDisplayName());
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return false;
        }
        return true;
    }

    private static ClassPath createRuntimeClassPath(MavenProject prj, boolean test) {
        List<URI> roots = test ? TestRuntimeClassPathImpl.createPath(prj) : RuntimeClassPathImpl.createPath(prj);
        return ClassPathSupport.createClassPath(AbstractProjectClassPathImpl.getPath(roots.toArray(new URI[0]), null));
    }

    private static void collectStartupArgs(RunConfig config, Map<String, Object> params) {
        StartupExtender.StartMode mode;
        String actionName = config.getActionName();
        if ("run".equals(actionName) || "run.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.NORMAL;
        } else if ("debug".equals(actionName) || "debug.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.DEBUG;
        } else if ("profile".equals(actionName) || "profile.single".equals(actionName) || "profile.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.PROFILE;
        } else if ("profile.test.single".equals(actionName)) {
            mode = StartupExtender.StartMode.TEST_PROFILE;
        } else {
            return;
        }
        InstanceContent ic = new InstanceContent();
        Project p = config.getProject();
        if (p != null) {
            ic.add((Object)p);
            ActiveJ2SEPlatformProvider pp = (ActiveJ2SEPlatformProvider)p.getLookup().lookup(ActiveJ2SEPlatformProvider.class);
            if (pp != null) {
                ic.add((Object)pp.getJavaPlatform());
            }
        }
        HashSet args = new HashSet();
        for (StartupExtender group : StartupExtender.getExtenders((Lookup)new AbstractLookup((AbstractLookup.Content)ic), (StartupExtender.StartMode)mode)) {
            args.addAll(group.getArguments());
        }
        if (!args.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String arg : args) {
                sb.append(arg).append(' ');
            }
            params.put(STARTUP_ARGS_KEY, sb.toString());
        }
    }

    static String action2Quick(String actionName) {
        if ("clean".equals(actionName)) {
            return "clean";
        }
        if ("run".equals(actionName) || "run.single.main".equals(actionName)) {
            return "run";
        }
        if ("debug".equals(actionName) || "debug.single.main".equals(actionName)) {
            return "debug";
        }
        if ("profile".equals(actionName) || "profile.single.main".equals(actionName)) {
            return "profile";
        }
        if ("test".equals(actionName) || "test.single".equals(actionName) || "run.single.method".equals(actionName)) {
            return "junit";
        }
        if ("debug.test.single".equals(actionName) || "debug.single.method".equals(actionName)) {
            return "junit-debug";
        }
        if ("profile.test.single".equals(actionName)) {
            return "junit-profile";
        }
        assert (false) : "Cannot convert " + actionName + " to quick actions.";
        return null;
    }
}

