/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.customizer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.java.customizer.Bundle;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CompileOptionsPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(CompileOptionsPanel.class.getName());
    public static final String HINT_JDK_PLATFORM = "netbeans.hint.jdkPlatform";
    private static final String PROP_PLATFORM_ID = "platform.ant.name";
    final Project project;
    private final ActionListener storeListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CompileOptionsPanel.this.save();
        }
    };
    private JButton btManagePlatforms;
    private JCheckBox cbAugmentedBuild;
    private JCheckBox cbCompileOnSave;
    private JCheckBox cbIncludeOpenProjects;
    private JComboBox<JavaPlatform> cbPlatform;
    private JLabel jLabel2;
    private JLabel lbCompileOnSave;
    private JLabel lbIncludeOpenProjects;
    private JLabel lbPlatform;

    public CompileOptionsPanel() {
        this((Project)null);
    }

    private CompileOptionsPanel(Project project) {
        this.project = project;
        this.initComponents();
        this.setupCheckBox(this.cbCompileOnSave, "compile.on.save", false);
        this.setupCheckBox(this.cbAugmentedBuild, "augmented.build", true);
        this.setupCheckBox(this.cbIncludeOpenProjects, "include.open.projects", false);
        this.setupPlatform();
    }

    private void setupCheckBox(JCheckBox check, String property, boolean defaultValue) {
        GradleBaseProject gbp;
        GradleBaseProject gradleBaseProject = gbp = this.project != null ? GradleBaseProject.get((Project)this.project) : null;
        if (gbp != null) {
            if (gbp.getNetBeansProperty(property) != null) {
                check.setEnabled(false);
                check.setSelected(Boolean.parseBoolean(gbp.getNetBeansProperty(property)));
                check.setToolTipText(Bundle.COMPILE_DISABLED_HINT(property));
            } else {
                Preferences prefs = NbGradleProject.getPreferences((Project)this.project, (boolean)false);
                check.setSelected(prefs.getBoolean(property, defaultValue));
            }
        }
    }

    private void setupPlatform() {
        GradleBaseProject gbp;
        GradleBaseProject gradleBaseProject = gbp = this.project != null ? GradleBaseProject.get((Project)this.project) : null;
        if (gbp != null) {
            String platformId = gbp.getNetBeansProperty("jdkPlatform");
            if (platformId != null) {
                this.cbPlatform.setEnabled(false);
                this.cbPlatform.setToolTipText(Bundle.COMPILE_DISABLED_HINT("jdkPlatform"));
                this.lbPlatform.setEnabled(false);
                this.lbPlatform.setToolTipText(Bundle.COMPILE_DISABLED_HINT("jdkPlatform"));
            } else {
                Preferences prefs = NbGradleProject.getPreferences((Project)this.project, (boolean)false);
                platformId = prefs.get("jdkPlatform", null);
            }
            JavaPlatform sel = (JavaPlatform)RunUtils.getActivePlatform((String)platformId).second();
            PlatformsModel model = new PlatformsModel();
            model.setSelectedItem(sel != null ? sel : platformId);
            this.cbPlatform.setModel(model);
            this.cbPlatform.setRenderer(new PlatformsRenderer());
        }
    }

    private void saveCheckBox(JCheckBox check, String property) {
        GradleBaseProject gbp;
        GradleBaseProject gradleBaseProject = gbp = this.project != null ? GradleBaseProject.get((Project)this.project) : null;
        if (gbp != null && gbp.getNetBeansProperty(property) == null) {
            Preferences prefs = NbGradleProject.getPreferences((Project)this.project, (boolean)false);
            prefs.putBoolean(property, check.isSelected());
        }
    }

    private void savePlatform() {
        GradleBaseProject gbp;
        GradleBaseProject gradleBaseProject = gbp = this.project != null ? GradleBaseProject.get((Project)this.project) : null;
        if (gbp != null && gbp.getNetBeansProperty("jdkPlatform") == null) {
            Preferences prefs = NbGradleProject.getPreferences((Project)this.project, (boolean)false);
            Object sel = this.cbPlatform.getModel().getSelectedItem();
            if (sel != null) {
                String platformId = sel instanceof JavaPlatform ? (String)((JavaPlatform)sel).getProperties().get(PROP_PLATFORM_ID) : sel.toString();
                prefs.put("jdkPlatform", platformId);
            }
        }
    }

    private void save() {
        this.saveCheckBox(this.cbCompileOnSave, "compile.on.save");
        this.saveCheckBox(this.cbAugmentedBuild, "augmented.build");
        this.saveCheckBox(this.cbIncludeOpenProjects, "include.open.projects");
        this.savePlatform();
        try {
            NbGradleProject.getPreferences((Project)this.project, (boolean)false).flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.cbCompileOnSave = new JCheckBox();
        this.lbCompileOnSave = new JLabel();
        this.cbAugmentedBuild = new JCheckBox();
        this.lbPlatform = new JLabel();
        this.cbPlatform = new JComboBox();
        this.btManagePlatforms = new JButton();
        this.jLabel2 = new JLabel();
        this.cbIncludeOpenProjects = new JCheckBox();
        this.lbIncludeOpenProjects = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.cbCompileOnSave, (String)NbBundle.getMessage(CompileOptionsPanel.class, (String)"CompileOptionsPanel.cbCompileOnSave.text"));
        this.cbCompileOnSave.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.lbCompileOnSave, (String)NbBundle.getMessage(CompileOptionsPanel.class, (String)"CompileOptionsPanel.lbCompileOnSave.text"));
        this.lbCompileOnSave.setVerticalAlignment(1);
        Mnemonics.setLocalizedText((AbstractButton)this.cbAugmentedBuild, (String)NbBundle.getMessage(CompileOptionsPanel.class, (String)"CompileOptionsPanel.cbAugmentedBuild.text"));
        this.lbPlatform.setLabelFor(this.cbPlatform);
        Mnemonics.setLocalizedText((JLabel)this.lbPlatform, (String)NbBundle.getMessage(CompileOptionsPanel.class, (String)"CompileOptionsPanel.lbPlatform.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btManagePlatforms, (String)NbBundle.getMessage(CompileOptionsPanel.class, (String)"CompileOptionsPanel.btManagePlatforms.text"));
        this.btManagePlatforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompileOptionsPanel.this.btManagePlatformsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CompileOptionsPanel.class, (String)"CompileOptionsPanel.jLabel2.text"));
        this.jLabel2.setVerticalAlignment(1);
        Mnemonics.setLocalizedText((AbstractButton)this.cbIncludeOpenProjects, (String)NbBundle.getMessage(CompileOptionsPanel.class, (String)"CompileOptionsPanel.cbIncludeOpenProjects.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbIncludeOpenProjects, (String)NbBundle.getMessage(CompileOptionsPanel.class, (String)"CompileOptionsPanel.lbIncludeOpenProjects.text"));
        this.lbIncludeOpenProjects.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbCompileOnSave).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.lbPlatform).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPlatform, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btManagePlatforms)).addComponent(this.cbAugmentedBuild, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.lbCompileOnSave, -1, 489, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.jLabel2, -2, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.lbIncludeOpenProjects, -2, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.cbIncludeOpenProjects).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbPlatform).addComponent(this.cbPlatform, -2, -1, -2).addComponent(this.btManagePlatforms)).addGap(18, 18, 18).addComponent(this.cbCompileOnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbCompileOnSave, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAugmentedBuild).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.cbIncludeOpenProjects).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbIncludeOpenProjects, -2, 56, -2).addContainerGap(67, Short.MAX_VALUE)));
    }

    private JavaPlatform getSelPlatform() {
        String platformId = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get(HINT_JDK_PLATFORM, true);
        return (JavaPlatform)RunUtils.getActivePlatform((String)platformId).second();
    }

    private void btManagePlatformsActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.getSelPlatform());
    }

    public static ProjectCustomizer.CompositeCategoryProvider buildCompileCustomizerProvider() {
        return new ProjectCustomizer.CompositeCategoryProvider(){

            public ProjectCustomizer.Category createCategory(Lookup context) {
                return null;
            }

            public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
                Project project = (Project)context.lookup(Project.class);
                CompileOptionsPanel customizer = new CompileOptionsPanel(project);
                category.setStoreListener(customizer.storeListener);
                return customizer;
            }
        };
    }

    private class PlatformsRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public PlatformsRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value instanceof JavaPlatform) {
                JavaPlatform jp = (JavaPlatform)value;
                this.setText(jp.getDisplayName());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
            } else if (value == null) {
                this.setText("");
            } else {
                this.setText(Bundle.LBL_MissingPlatform(value));
                this.setForeground(UIManager.getColor("nb.errorForeground"));
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private static class PlatformsModel
    extends AbstractListModel<JavaPlatform>
    implements ComboBoxModel<JavaPlatform>,
    PropertyChangeListener {
        private JavaPlatform[] data;
        private Object sel;

        public PlatformsModel() {
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            this.getPlatforms(jpm);
            jpm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jpm));
        }

        @Override
        public int getSize() {
            return this.data.length;
        }

        @Override
        public JavaPlatform getElementAt(int index) {
            return this.data[index];
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.sel = anItem;
            this.fireContentsChanged(this, 0, this.data.length);
        }

        @Override
        public Object getSelectedItem() {
            return this.sel;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String current = this.sel instanceof JavaPlatform ? (String)((JavaPlatform)this.sel).getProperties().get(CompileOptionsPanel.PROP_PLATFORM_ID) : this.sel.toString();
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            this.getPlatforms(jpm);
            String found = null;
            for (int i = 0; i < this.data.length; ++i) {
                JavaPlatform pf = this.data[i];
                if (!current.equals(pf.getProperties().get(CompileOptionsPanel.PROP_PLATFORM_ID))) continue;
                found = pf;
                break;
            }
            this.setSelectedItem(found != null ? found : current);
        }

        private void getPlatforms(JavaPlatformManager jpm) {
            this.data = jpm.getPlatforms(null, new Specification("j2se", null));
            if (LOG.isLoggable(Level.FINE)) {
                for (JavaPlatform jp : this.data) {
                    LOG.log(Level.FINE, "Adding JavaPlaform: {0}", jp.getDisplayName());
                }
            }
        }
    }
}

