/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.suggestions.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class FlipOperands {
    private static final Set<Tree.Kind> SAFE_FLIP = new HashSet<Tree.Kind>(Arrays.asList(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.MULTIPLY, Tree.Kind.PLUS, Tree.Kind.AND, Tree.Kind.OR, Tree.Kind.XOR, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR));
    private static final Set<Tree.Kind> UNSAFE_FLIP = new HashSet<Tree.Kind>(Arrays.asList(Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT));
    private static final Map<Tree.Kind, Tree.Kind> CONVERT_FLIP = new HashMap<Tree.Kind, Tree.Kind>();
    private static final Map<Tree.Kind, String> OPERATOR_DN = new HashMap<Tree.Kind, String>();

    public static ErrorDescription equals(HintContext ctx) {
        Tree.Kind targetKind;
        String displayName;
        boolean unsafe;
        BinaryTree bt = (BinaryTree)ctx.getPath().getLeaf();
        Tree.Kind kind = bt.getKind();
        CompilationInfo ci = ctx.getInfo();
        if (kind == Tree.Kind.PLUS) {
            TypeMirror leftType = ci.getTrees().getTypeMirror(new TreePath(ctx.getPath(), bt.getLeftOperand()));
            if (Utilities.isJavaString(ci, leftType)) {
                unsafe = true;
            } else {
                TypeMirror rightType = ci.getTrees().getTypeMirror(new TreePath(ctx.getPath(), bt.getLeftOperand()));
                unsafe = Utilities.isJavaString(ci, rightType);
            }
        } else {
            unsafe = false;
        }
        if (unsafe || UNSAFE_FLIP.contains((Object)kind)) {
            displayName = Bundle.FIX_FlipOperands3(OPERATOR_DN.get((Object)kind));
            targetKind = kind;
        } else if (SAFE_FLIP.contains((Object)kind)) {
            displayName = Bundle.FIX_FlipOperands1(OPERATOR_DN.get((Object)kind));
            targetKind = kind;
        } else {
            targetKind = CONVERT_FLIP.get((Object)kind);
            displayName = Bundle.FIX_FlipOperands2(OPERATOR_DN.get((Object)kind), OPERATOR_DN.get((Object)targetKind));
        }
        return ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.DESC_FlipOperands(), (Fix[])new Fix[]{new FixImpl(ctx.getInfo(), ctx.getPath(), displayName, targetKind).toEditorFix()});
    }

    static {
        CONVERT_FLIP.put(Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN_EQUAL);
        CONVERT_FLIP.put(Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_EQUAL);
        CONVERT_FLIP.put(Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.LESS_THAN);
        CONVERT_FLIP.put(Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN);
        OPERATOR_DN.put(Tree.Kind.MULTIPLY, "*");
        OPERATOR_DN.put(Tree.Kind.DIVIDE, "/");
        OPERATOR_DN.put(Tree.Kind.REMAINDER, "%");
        OPERATOR_DN.put(Tree.Kind.PLUS, "+");
        OPERATOR_DN.put(Tree.Kind.MINUS, "-");
        OPERATOR_DN.put(Tree.Kind.LEFT_SHIFT, "&lt;&lt;");
        OPERATOR_DN.put(Tree.Kind.RIGHT_SHIFT, "&gt;&gt;");
        OPERATOR_DN.put(Tree.Kind.UNSIGNED_RIGHT_SHIFT, "&gt;&gt;&gt;");
        OPERATOR_DN.put(Tree.Kind.LESS_THAN, "&lt;");
        OPERATOR_DN.put(Tree.Kind.GREATER_THAN, "&gt;");
        OPERATOR_DN.put(Tree.Kind.LESS_THAN_EQUAL, "&lt;=");
        OPERATOR_DN.put(Tree.Kind.GREATER_THAN_EQUAL, "&gt;=");
        OPERATOR_DN.put(Tree.Kind.EQUAL_TO, "==");
        OPERATOR_DN.put(Tree.Kind.NOT_EQUAL_TO, "!=");
        OPERATOR_DN.put(Tree.Kind.AND, "&amp;");
        OPERATOR_DN.put(Tree.Kind.OR, "|");
        OPERATOR_DN.put(Tree.Kind.XOR, "^");
        OPERATOR_DN.put(Tree.Kind.CONDITIONAL_AND, "&amp;&amp;");
        OPERATOR_DN.put(Tree.Kind.CONDITIONAL_OR, "||");
    }

    private static final class FixImpl
    extends JavaFix {
        private final String displayName;
        private final Tree.Kind targetKind;

        public FixImpl(CompilationInfo info, TreePath tp, String displayName, Tree.Kind targetKind) {
            super(info, tp);
            this.displayName = displayName;
            this.targetKind = targetKind;
        }

        protected String getText() {
            return this.displayName;
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            BinaryTree orig = (BinaryTree)ctx.getPath().getLeaf();
            BinaryTree nue = ctx.getWorkingCopy().getTreeMaker().Binary(this.targetKind, orig.getRightOperand(), orig.getLeftOperand());
            ctx.getWorkingCopy().rewrite((Tree)orig, (Tree)nue);
        }
    }
}

