/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.Position;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.UpdateType;
import org.openide.util.NbBundle;

public class TableUISupport {
    private TableUISupport() {
    }

    public static JList createTableList() {
        return new TableJList();
    }

    public static void connectAvailable(JList availableTablesList, TableClosure tableClosure, FilterAvailable filter) {
        availableTablesList.setModel(new AvailableTablesModel(tableClosure));
        if (!(availableTablesList.getCellRenderer() instanceof AvailableTableRenderer)) {
            availableTablesList.setCellRenderer(new AvailableTableRenderer(filter));
        } else {
            AvailableTableRenderer renderer = (AvailableTableRenderer)availableTablesList.getCellRenderer();
            renderer.updateFilter(filter);
        }
    }

    public static void connectSelected(JList selectedTablesList, TableClosure tableClosure) {
        selectedTablesList.setModel(new SelectedTablesModel(tableClosure));
        if (!(selectedTablesList.getCellRenderer() instanceof SelectedTableRenderer)) {
            selectedTablesList.setCellRenderer(new SelectedTableRenderer());
        }
    }

    public static Set<Table> getSelectedTables(JList list) {
        return TableUISupport.getSelectedTables(list, false);
    }

    public static Set<Table> getSelectedTables(JList list, boolean enabledOnly) {
        HashSet<Table> result = new HashSet<Table>();
        int[] selected = list.getSelectedIndices();
        for (int i = 0; i < selected.length; ++i) {
            Table table = (Table)list.getModel().getElementAt(selected[i]);
            if (enabledOnly && !list.getCellRenderer().getListCellRendererComponent(list, table, selected[i], false, false).isEnabled()) continue;
            result.add(table);
        }
        return result;
    }

    public static Set<Table> getEnabledTables(JList list) {
        HashSet<Table> result = new HashSet<Table>();
        for (int i = 0; i < list.getModel().getSize(); ++i) {
            Table table = (Table)list.getModel().getElementAt(i);
            if (!list.getCellRenderer().getListCellRendererComponent(list, table, i, false, false).isEnabled()) continue;
            result.add(table);
        }
        return result;
    }

    public static void connectClassNames(JTable table, SelectedTables selectedTables) {
        table.setModel(new TableClassNamesModel(selectedTables));
        TableUISupport.setRenderer(table.getColumnModel().getColumn(0));
        TableUISupport.setRenderer(table.getColumnModel().getColumn(1));
    }

    private static void setRenderer(TableColumn column) {
        if (!(column.getCellRenderer() instanceof TableClassNameRenderer)) {
            column.setCellRenderer(new TableClassNameRenderer());
        }
    }

    public static enum FilterAvailable {
        ANY,
        NEW,
        UPDATE;

    }

    private static final class TableJList
    extends JList {
        private TableJList() {
        }

        @Override
        public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
            ListModel model = this.getModel();
            if (!(model instanceof TableModel)) {
                return super.getNextMatch(prefix, startIndex, bias);
            }
            TableModel tablesModel = (TableModel)model;
            int max = tablesModel.getSize();
            int increment = bias == Position.Bias.Forward ? 1 : -1;
            int index = startIndex;
            prefix = prefix.toUpperCase();
            do {
                Table table;
                String tableName;
                if (!(tableName = (table = tablesModel.getElementAt(index)).getName().toUpperCase()).startsWith(prefix)) continue;
                return index;
            } while ((index = (index + increment + max) % max) != startIndex);
            return -1;
        }
    }

    private static final class TableClassNameRenderer
    extends DefaultTableCellRenderer {
        private static Color errorForeground = UIManager.getColor("nb.errorForeground");
        private static Color nonErrorForeground;

        private TableClassNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            boolean joinTable = false;
            boolean validClass = true;
            boolean existentUpdate = false;
            String problemDisplayName = null;
            if (jTable.getModel() instanceof TableClassNamesModel) {
                TableClassNamesModel model = (TableClassNamesModel)jTable.getModel();
                Table table = model.getTableAt(row);
                joinTable = table.isJoin();
                if (column == 1) {
                    existentUpdate = table.getDisabledReason() instanceof Table.ExistingDisabledReason;
                    validClass = model.isValidClass(table);
                    if (!validClass) {
                        problemDisplayName = model.getProblemDisplayName(table);
                    }
                }
            }
            Object realValue = null;
            realValue = joinTable && column == 1 ? NbBundle.getMessage(TableUISupport.class, (String)"LBL_JoinTable") : value;
            JComponent component = (JComponent)super.getTableCellRendererComponent(jTable, realValue, isSelected, hasFocus, row, column);
            component.setEnabled(!joinTable && !existentUpdate);
            component.setToolTipText(joinTable ? NbBundle.getMessage(TableUISupport.class, (String)"LBL_JoinTableDescription") : problemDisplayName);
            component.setForeground(validClass ? nonErrorForeground : errorForeground);
            return component;
        }

        static {
            if (errorForeground == null) {
                errorForeground = Color.RED;
            }
            nonErrorForeground = UIManager.getColor("Label.foreground");
        }
    }

    static final class ClassNamesTable
    extends JTable {
        ClassNamesTable() {
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 2 && this.getModel() instanceof TableClassNamesModel) {
                TableClassNamesModel model = (TableClassNamesModel)this.getModel();
                Table table = model.getTableAt(row);
                Table.DisabledReason dr = table.getDisabledReason();
                boolean existing = dr instanceof Table.ExistingDisabledReason;
                if (existing) {
                    return new DefaultCellEditor(new JComboBox<UpdateType>(new UpdateType[]{UpdateType.UPDATE, UpdateType.RECREATE}));
                }
                return new DefaultCellEditor(new JComboBox<UpdateType>(new UpdateType[]{UpdateType.NEW}));
            }
            return super.getCellEditor(row, column);
        }
    }

    private static final class TableClassNamesModel
    extends AbstractTableModel {
        private SelectedTables selectedTables;
        private final List<Table> tables;

        public TableClassNamesModel(SelectedTables selectedTables) {
            this.selectedTables = selectedTables;
            this.tables = selectedTables.getTables();
        }

        SelectedTables getSelectedTables() {
            return this.selectedTables;
        }

        public Table getTableAt(int rowIndex) {
            return this.tables.get(rowIndex);
        }

        public boolean isValidClass(Table table) {
            return !this.selectedTables.hasProblem(table);
        }

        public String getProblemDisplayName(Table table) {
            return this.selectedTables.getProblemDisplayNameForTable(table);
        }

        @Override
        public int getRowCount() {
            return this.tables.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.tables.get(rowIndex).getName();
                }
                case 1: {
                    Table table = this.tables.get(rowIndex);
                    return this.selectedTables.getClassName(table);
                }
                case 2: {
                    return this.selectedTables.getUpdateType(this.tables.get(rowIndex)).getName();
                }
            }
            assert (false);
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Table table = this.tables.get(rowIndex);
            switch (columnIndex) {
                case 1: {
                    this.selectedTables.setClassName(table, (String)value);
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    return;
                }
                case 2: {
                    this.selectedTables.setUpdateType(table, (UpdateType)((Object)value));
                    return;
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Table table = this.tables.get(rowIndex);
            UpdateType ut = this.selectedTables.getUpdateType(this.tables.get(rowIndex));
            return !(table.isJoin() || columnIndex != 1 && columnIndex != 2 || !UpdateType.NEW.equals((Object)ut) && columnIndex != 2);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return NbBundle.getMessage(TableUISupport.class, (String)"LBL_DatabaseTable");
                }
                case 1: {
                    return NbBundle.getMessage(TableUISupport.class, (String)"LBL_ClassName");
                }
                case 2: {
                    return NbBundle.getMessage(TableUISupport.class, (String)"LBL_GenerationType");
                }
            }
            assert (false);
            return null;
        }
    }

    private static final class SelectedTableRenderer
    extends DefaultListCellRenderer {
        private SelectedTableRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String tooltip;
            Table table = null;
            Object displayName = null;
            boolean referenced = false;
            TableClosure tableClosure = null;
            Table.DisabledReason disabledReason = null;
            if (value instanceof Table) {
                table = (Table)value;
                disabledReason = table.getDisabledReason();
                displayName = disabledReason != null ? NbBundle.getMessage(TableUISupport.class, (String)"LBL_TableNameWithDisabledReason", (Object)table.getName(), (Object)disabledReason.getDisplayName()) : (((Table)value).isTable() ? table.getName() : table.getName() + NbBundle.getMessage(TableUISupport.class, (String)"LBL_DB_VIEW"));
                if (list.getModel() instanceof SelectedTablesModel) {
                    SelectedTablesModel model = (SelectedTablesModel)list.getModel();
                    tableClosure = model.getTableClosure();
                    referenced = tableClosure.getReferencedTables().contains(table);
                }
            } else {
                displayName = value;
            }
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
            component.setEnabled(!referenced && !table.isDisabled());
            String string = tooltip = referenced ? SelectedTableRenderer.getTableTooltip(table, tableClosure) : null;
            if (table.isDisabled()) {
                String descr = table.getDisabledReason().getDescription();
                tooltip = tooltip == null ? descr : tooltip.concat("<br>" + descr);
            }
            component.setToolTipText(tooltip);
            return component;
        }

        private static String getTableTooltip(Table table, TableClosure tableClosure) {
            String bundleKey;
            Set<Table> relatedTables;
            ArrayList<Table> tables = new ArrayList<Table>();
            if (table.isJoin()) {
                relatedTables = table.getReferencedTables();
                bundleKey = "LBL_RelatedTableJoin";
            } else {
                relatedTables = table.getReferencedByTables();
                bundleKey = "LBL_RelatedTableRefBy";
            }
            for (Table refTable : relatedTables) {
                if (!tableClosure.getSelectedTables().contains(refTable)) continue;
                tables.add(refTable);
            }
            if (tables.size() == 0) {
                return null;
            }
            return NbBundle.getMessage(TableUISupport.class, (String)bundleKey, (Object)SelectedTableRenderer.createTableList(tables));
        }

        private static String createTableList(List<Table> tables) {
            assert (tables.size() > 0);
            if (tables.size() == 1) {
                return tables.iterator().next().getName();
            }
            Collections.sort(tables);
            String separator = NbBundle.getMessage(TableUISupport.class, (String)"LBL_TableListSep");
            Iterator<Table> i = tables.iterator();
            StringBuilder builder = new StringBuilder(i.next().getName());
            String lastTable = i.next().getName();
            while (i.hasNext()) {
                builder.append(separator);
                builder.append(lastTable);
                lastTable = i.next().getName();
            }
            return NbBundle.getMessage(TableUISupport.class, (String)"LBL_TableList", (Object)builder.toString(), (Object)lastTable);
        }
    }

    private static final class AvailableTableRenderer
    extends DefaultListCellRenderer {
        private FilterAvailable filter;

        public AvailableTableRenderer(FilterAvailable filter) {
            this.filter = filter;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Table.DisabledReason disabledReason = null;
            String displayName = null;
            if (value instanceof Table) {
                Table tableItem = (Table)value;
                disabledReason = tableItem.getDisabledReason();
                displayName = disabledReason != null ? NbBundle.getMessage(TableUISupport.class, (String)"LBL_TableNameWithDisabledReason", (Object)tableItem.getName(), (Object)disabledReason.getDisplayName()) : (tableItem.isTable() ? tableItem.getName() : tableItem.getName() + NbBundle.getMessage(TableUISupport.class, (String)"LBL_DB_VIEW"));
            }
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
            boolean needDisable = disabledReason instanceof Table.NoPrimaryKeyDisabledReason || disabledReason instanceof Table.ExistingNotInSourceDisabledReason || this.filter.equals((Object)FilterAvailable.NEW) && disabledReason instanceof Table.ExistingDisabledReason || this.filter.equals((Object)FilterAvailable.UPDATE) && disabledReason == null;
            component.setEnabled(!needDisable);
            component.setToolTipText(disabledReason != null ? disabledReason.getDescription() : null);
            return component;
        }

        void updateFilter(FilterAvailable filter) {
            this.filter = filter;
        }
    }

    private static final class SelectedTablesModel
    extends TableModel
    implements ChangeListener {
        private final TableClosure tableClosure;
        private List<Table> displayTables;

        public SelectedTablesModel(TableClosure tableClosure) {
            this.tableClosure = tableClosure;
            tableClosure.addChangeListener(this);
            this.refresh();
        }

        @Override
        public Table getElementAt(int index) {
            return this.displayTables.get(index);
        }

        @Override
        public int getSize() {
            return this.displayTables != null ? this.displayTables.size() : 0;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.refresh();
        }

        private void refresh() {
            int oldSize = this.getSize();
            this.displayTables = new ArrayList<Table>(this.tableClosure.getSelectedTables());
            Collections.sort(this.displayTables);
            this.fireIntervalRemoved(this, 0, oldSize);
            this.fireIntervalAdded(this, 0, this.getSize());
        }

        public TableClosure getTableClosure() {
            return this.tableClosure;
        }
    }

    private static final class AvailableTablesModel
    extends TableModel
    implements ChangeListener {
        private final TableClosure tableClosure;
        private List<Table> displayTables;

        public AvailableTablesModel(TableClosure tableClosure) {
            this.tableClosure = tableClosure;
            tableClosure.addChangeListener(this);
            this.refresh();
        }

        @Override
        public Table getElementAt(int index) {
            return this.displayTables.get(index);
        }

        @Override
        public int getSize() {
            return this.displayTables != null ? this.displayTables.size() : 0;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            this.refresh();
        }

        private void refresh() {
            int oldSize = this.getSize();
            this.displayTables = new ArrayList<Table>(this.tableClosure.getAvailableTables());
            Collections.sort(this.displayTables);
            this.fireIntervalRemoved(this, 0, oldSize);
            this.fireIntervalAdded(this, 0, this.getSize());
        }
    }

    private static abstract class TableModel
    extends AbstractListModel {
        private TableModel() {
        }

        @Override
        public abstract Table getElementAt(int var1);
    }
}

