/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.j2se;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.jshell.launch.ShellAgent;
import org.netbeans.modules.jshell.launch.ShellLaunchManager;
import org.netbeans.modules.jshell.project.LaunchedProjectOpener;
import org.netbeans.modules.jshell.project.ShellProjectUtils;
import org.netbeans.spi.extexecution.startup.StartupExtenderImplementation;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.util.Lookup;

public class JShellStartupExtender
implements StartupExtenderImplementation {
    private static final Logger LOG = Logger.getLogger(JShellStartupExtender.class.getName());

    public List<String> getArguments(Lookup context, StartupExtender.StartMode mode) {
        InetSocketAddress isa;
        ShellAgent agent;
        LaunchedProjectOpener.init();
        Project p = (Project)context.lookup(Project.class);
        if (p == null) {
            return Collections.emptyList();
        }
        LOG.log(Level.FINE, "Augmenting {0} of project {1}", new Object[]{mode, p});
        if (!ShellProjectUtils.isJShellRunEnabled(p)) {
            LOG.log(Level.FINE, "Request for agent: Project {0} does not enable Java Shell.", p);
            return Collections.emptyList();
        }
        try {
            agent = ShellLaunchManager.getInstance().openForProject(p, mode == StartupExtender.StartMode.DEBUG || mode == StartupExtender.StartMode.TEST_DEBUG);
            isa = agent.getHandshakeAddress();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Could not obtain handshake address and key: ", ex);
            return Collections.emptyList();
        }
        LOG.log(Level.FINE, "Connect address is: {0}:{1}", new Object[]{isa.getHostString(), isa.getPort()});
        J2SEPropertyEvaluator prjEval = (J2SEPropertyEvaluator)p.getLookup().lookup(J2SEPropertyEvaluator.class);
        JavaPlatform platform = ShellProjectUtils.findPlatform(p);
        List<String> args = ShellProjectUtils.quoteCmdArgs(ShellLaunchManager.buildLocalJVMAgentArgs(platform, agent, arg_0 -> ((PropertyEvaluator)prjEval.evaluator()).getProperty(arg_0)));
        args.addAll(ShellProjectUtils.launchVMOptions(p));
        LOG.log(Level.FINE, "Final args: {0}", args);
        return args;
    }
}

