/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee.db;

import java.util.Objects;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.payara.jakartaee.ApplicationScopedResourcesUtils;

public class SunDatasource
implements Datasource {
    private final String jndiName;
    private final String url;
    private final String username;
    private final String password;
    private final String driverClassName;
    private final ApplicationScopedResourcesUtils.JndiNameResolver resolver;

    public SunDatasource(String jndiName, String url, String username, String password, String driverClassName) {
        this(jndiName, url, username, password, driverClassName, false, null);
    }

    public SunDatasource(String jndiName, String url, String username, String password, String driverClassName, boolean scoped, ApplicationScopedResourcesUtils.JndiNameResolver resolver) {
        this.jndiName = jndiName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.driverClassName = driverClassName;
        this.resolver = resolver;
    }

    public String getDisplayName() {
        return this.getJndiName();
    }

    public String getJndiName() {
        if (this.resolver != null) {
            return this.resolver.resolveJndiName(this.jndiName);
        }
        return this.jndiName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String toString() {
        return "[ " + this.jndiName + " : " + this.url + " : " + this.username + " : " + this.password + " : " + this.driverClassName + " ]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SunDatasource other = (SunDatasource)obj;
        if (!Objects.equals(this.jndiName, other.jndiName)) {
            return false;
        }
        if (!Objects.equals(this.url, other.url)) {
            return false;
        }
        if (!Objects.equals(this.username, other.username)) {
            return false;
        }
        if (!Objects.equals(this.password, other.password)) {
            return false;
        }
        return Objects.equals(this.driverClassName, other.driverClassName);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.jndiName != null ? this.jndiName.hashCode() : 0);
        hash = 41 * hash + (this.url != null ? this.url.hashCode() : 0);
        hash = 41 * hash + (this.username != null ? this.username.hashCode() : 0);
        hash = 41 * hash + (this.password != null ? this.password.hashCode() : 0);
        hash = 41 * hash + (this.driverClassName != null ? this.driverClassName.hashCode() : 0);
        return hash;
    }

    public SunDatasource copy(String jndiName) {
        return new SunDatasource(jndiName, this.url, this.username, this.password, this.driverClassName);
    }
}

