/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.nashorn.parser;

public class Scanner {
    protected final char[] content;
    protected int position;
    protected final int limit;
    protected char ch0;
    protected char ch1;
    protected char ch2;
    protected char ch3;

    protected Scanner(char[] content, int start, int length) {
        this.content = content;
        this.position = start;
        this.limit = start + length;
        this.reset(this.position);
    }

    protected Scanner(String content) {
        this(content.toCharArray(), 0, content.length());
    }

    protected final boolean atEOF() {
        return this.position == this.limit;
    }

    protected final char charAt(int i) {
        return i < this.limit ? this.content[i] : (char)'\u0000';
    }

    protected final void reset(int i) {
        this.ch0 = this.charAt(i);
        this.ch1 = this.charAt(i + 1);
        this.ch2 = this.charAt(i + 2);
        this.ch3 = this.charAt(i + 3);
        this.position = i < this.limit ? i : this.limit;
    }

    protected final void skip(int n) {
        if (n == 1 && !this.atEOF()) {
            this.ch0 = this.ch1;
            this.ch1 = this.ch2;
            this.ch2 = this.ch3;
            this.ch3 = this.charAt(this.position + 4);
            ++this.position;
        } else if (n != 0) {
            this.reset(this.position + n);
        }
    }

    protected String getContents() {
        return new String(this.content);
    }
}

