/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.joni.result;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.runtime.joni.AbstractConstantKeysObject;
import com.oracle.truffle.js.runtime.joni.interop.ToIntNode;
import com.oracle.truffle.js.runtime.joni.interop.TruffleReadOnlyKeysArray;
import com.oracle.truffle.js.runtime.joni.result.JoniNoMatchResult;
import com.oracle.truffle.js.runtime.joni.result.JoniSingleResult;
import com.oracle.truffle.js.runtime.joni.result.JoniStartsEndsIndexArrayResult;

@ExportLibrary(value=InteropLibrary.class)
public abstract class JoniRegexResult
extends AbstractConstantKeysObject {
    static final String PROP_IS_MATCH = "isMatch";
    static final String PROP_GET_START = "getStart";
    static final String PROP_GET_END = "getEnd";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("isMatch", "getStart", "getEnd");

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public final Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "isMatch": {
                return this != JoniNoMatchResult.getInstance();
            }
            case "getStart": {
                return new GetStartMethod(this);
            }
            case "getEnd": {
                return new GetEndMethod(this);
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw UnknownIdentifierException.create((String)symbol);
    }

    @ExportMessage
    boolean isMemberInvocable(String member, @Cached IsInvocableCacheNode cache, @Cached.Shared(value="receiverProfile") @Cached(value="createIdentityProfile()") ValueProfile receiverProfile) {
        return cache.execute((JoniRegexResult)receiverProfile.profile((Object)this), member);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args, @Cached ToIntNode toIntNode, @Cached InvokeCacheNode invokeCache, @Cached.Shared(value="receiverProfile") @Cached(value="createIdentityProfile()") ValueProfile receiverProfile) throws UnknownIdentifierException, ArityException, UnsupportedTypeException {
        if (args.length != 1) {
            CompilerDirectives.transferToInterpreter();
            throw ArityException.create((int)1, (int)args.length);
        }
        return invokeCache.execute((JoniRegexResult)receiverProfile.profile((Object)this), member, toIntNode.execute(args[0]));
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class GetEndMethod
    implements TruffleObject {
        private final JoniRegexResult result;

        public GetEndMethod(JoniRegexResult result) {
            this.result = result;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        int execute(Object[] args, @Cached ToIntNode toIntNode, @Cached GetEndNode getEndNode) throws ArityException, UnsupportedTypeException {
            if (args.length != 1) {
                CompilerDirectives.transferToInterpreter();
                throw ArityException.create((int)1, (int)args.length);
            }
            return getEndNode.execute(this.result, toIntNode.execute(args[0]));
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class GetStartMethod
    implements TruffleObject {
        private final JoniRegexResult result;

        public GetStartMethod(JoniRegexResult result) {
            this.result = result;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        int execute(Object[] args, @Cached ToIntNode toIntNode, @Cached GetStartNode getStartNode) throws ArityException, UnsupportedTypeException {
            if (args.length != 1) {
                CompilerDirectives.transferToInterpreter();
                throw ArityException.create((int)1, (int)args.length);
            }
            return getStartNode.execute(this.result, toIntNode.execute(args[1]));
        }
    }

    @ReportPolymorphism
    @GenerateUncached
    static abstract class GetEndNode
    extends Node {
        GetEndNode() {
        }

        abstract int execute(Object var1, int var2);

        @Specialization
        static int doNoMatch(JoniNoMatchResult receiver, int groupNumber) {
            return -1;
        }

        @Specialization
        static int doSingleResult(JoniSingleResult receiver, int groupNumber, @Cached(value="createBinaryProfile()") ConditionProfile boundsProfile) {
            if (boundsProfile.profile(groupNumber == 0)) {
                return receiver.getEnd();
            }
            return -1;
        }

        @Specialization
        static int doStartsEndsIndexArray(JoniStartsEndsIndexArrayResult receiver, int groupNumber) {
            try {
                return receiver.getEnds()[groupNumber];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return -1;
            }
        }
    }

    @ReportPolymorphism
    @GenerateUncached
    static abstract class GetStartNode
    extends Node {
        GetStartNode() {
        }

        abstract int execute(JoniRegexResult var1, int var2);

        @Specialization
        static int doNoMatch(JoniNoMatchResult receiver, int groupNumber) {
            return -1;
        }

        @Specialization
        static int doSingleResult(JoniSingleResult receiver, int groupNumber, @Cached(value="createBinaryProfile()") ConditionProfile boundsProfile) {
            if (boundsProfile.profile(groupNumber == 0)) {
                return receiver.getStart();
            }
            return -1;
        }

        @Specialization
        static int doStartsEndsIndexArray(JoniStartsEndsIndexArrayResult receiver, int groupNumber) {
            try {
                return receiver.getStarts()[groupNumber];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return -1;
            }
        }
    }

    @ImportStatic(value={JoniRegexResult.class})
    @GenerateUncached
    static abstract class InvokeCacheNode
    extends Node {
        InvokeCacheNode() {
        }

        abstract Object execute(JoniRegexResult var1, String var2, int var3) throws UnknownIdentifierException;

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_START)"}, limit="2")
        Object getStartIdentity(JoniRegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached GetStartNode getStartNode) {
            return getStartNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_START)"}, limit="2", replaces={"getStartIdentity"})
        Object getStartEquals(JoniRegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached GetStartNode getStartNode) {
            return getStartNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_END)"}, limit="2")
        Object getEndIdentity(JoniRegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached GetEndNode getEndNode) {
            return getEndNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_END)"}, limit="2", replaces={"getEndIdentity"})
        Object getEndEquals(JoniRegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached GetEndNode getEndNode) {
            return getEndNode.execute(receiver, groupNumber);
        }

        @Specialization(replaces={"getStartEquals", "getEndEquals"})
        static Object read(JoniRegexResult receiver, String symbol, int groupNumber, @Cached GetStartNode getStartNode, @Cached GetEndNode getEndNode) throws UnknownIdentifierException {
            switch (symbol) {
                case "getStart": {
                    return getStartNode.execute(receiver, groupNumber);
                }
                case "getEnd": {
                    return getEndNode.execute(receiver, groupNumber);
                }
            }
            throw UnknownIdentifierException.create((String)symbol);
        }
    }

    @GenerateUncached
    static abstract class IsInvocableCacheNode
    extends Node {
        IsInvocableCacheNode() {
        }

        abstract boolean execute(JoniRegexResult var1, String var2);

        @Specialization(guards={"symbol == cachedSymbol"}, limit="2")
        static boolean cacheIdentity(JoniRegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)"}, limit="2", replaces={"cacheIdentity"})
        static boolean cacheEquals(JoniRegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isInvocable(JoniRegexResult receiver, String symbol) {
            return JoniRegexResult.PROP_GET_START.equals(symbol) || JoniRegexResult.PROP_GET_END.equals(symbol);
        }
    }
}

