/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.builtins.AbstractJSClass;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.truffleinterop.JSInteropUtil;
import com.oracle.truffle.js.runtime.util.DefinePropertyUtil;
import com.oracle.truffle.js.runtime.util.JSReflectUtils;
import java.util.ArrayList;
import java.util.List;

public final class JSProxy
extends AbstractJSClass
implements PrototypeSupplier {
    public static final String CLASS_NAME = "Proxy";
    public static final JSProxy INSTANCE = new JSProxy();
    private static final Property PROXY_TARGET_PROPERTY;
    private static final Property PROXY_HANDLER_PROPERTY;
    public static final String GET_PROTOTYPE_OF = "getPrototypeOf";
    public static final String SET_PROTOTYPE_OF = "setPrototypeOf";
    public static final String IS_EXTENSIBLE = "isExtensible";
    public static final String PREVENT_EXTENSIONS = "preventExtensions";
    public static final String GET_OWN_PROPERTY_DESCRIPTOR = "getOwnPropertyDescriptor";
    public static final String HAS = "has";
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String DELETE_PROPERTY = "deleteProperty";
    public static final String DEFINE_PROPERTY = "defineProperty";
    public static final String OWN_KEYS = "ownKeys";
    public static final String APPLY = "apply";
    public static final String CONSTRUCT = "construct";
    private static final HiddenKey PROXY_TARGET;
    private static final HiddenKey PROXY_HANDLER;
    public static final HiddenKey REVOCABLE_PROXY;

    public static boolean isAccessibleProperty(DynamicObject proxy, Object key) {
        TruffleObject target = JSProxy.getTarget(proxy);
        if (JSObject.isJSObject(target)) {
            return JSProxy.checkPropertyIsSettable(target, key);
        }
        return true;
    }

    public static boolean checkPropertyIsSettable(TruffleObject truffleTarget, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        if (!JSObject.isJSObject(truffleTarget)) {
            return true;
        }
        DynamicObject target = (DynamicObject)truffleTarget;
        PropertyDescriptor desc = JSObject.getOwnProperty(target, key);
        if (desc != null) {
            if (!desc.getConfigurable()) {
                return false;
            }
            if (!JSObject.isExtensible(target)) {
                return false;
            }
        }
        return true;
    }

    private JSProxy() {
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public String toString() {
        return CLASS_NAME;
    }

    public static DynamicObject create(JSContext context, TruffleObject target, DynamicObject handler) {
        return JSObject.create(context, context.getProxyFactory(), target, handler);
    }

    public static TruffleObject getTarget(DynamicObject obj) {
        return JSProxy.getTarget(obj, JSProxy.isProxy(obj));
    }

    public static TruffleObject getTarget(DynamicObject obj, boolean floatingCondition) {
        assert (JSProxy.isProxy(obj));
        return (TruffleObject)PROXY_TARGET_PROPERTY.get(obj, floatingCondition);
    }

    public static TruffleObject getTargetNonProxy(DynamicObject thisObj) {
        DynamicObject obj = thisObj;
        while (JSProxy.isProxy((Object)obj)) {
            obj = JSProxy.getTarget(obj);
        }
        return obj;
    }

    public static DynamicObject getHandler(DynamicObject obj) {
        return JSProxy.getHandler(obj, JSProxy.isProxy(obj));
    }

    public static DynamicObject getHandlerChecked(DynamicObject obj) {
        DynamicObject handler = JSProxy.getHandler(obj);
        if (handler == Null.instance) {
            throw Errors.createTypeError("proxy handler must not be null");
        }
        return handler;
    }

    public static DynamicObject getHandler(DynamicObject obj, boolean floatingCondition) {
        assert (JSProxy.isProxy(obj));
        return (DynamicObject)PROXY_HANDLER_PROPERTY.get(obj, floatingCondition);
    }

    public static void revoke(DynamicObject obj) {
        assert (JSProxy.isProxy(obj));
        try {
            PROXY_TARGET_PROPERTY.set(obj, (Object)Null.instance, null);
            PROXY_HANDLER_PROPERTY.set(obj, (Object)Null.instance, null);
        }
        catch (Exception ex) {
            throw Errors.createTypeError("cannot revoke proxy");
        }
    }

    public static boolean isProxy(Object obj) {
        return JSObject.isDynamicObject(obj) && JSProxy.isProxy((DynamicObject)obj);
    }

    public static boolean isProxy(DynamicObject obj) {
        return JSProxy.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object receiver, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        return JSProxy.proxyGetHelper(store, key, receiver);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object receiver, long index) {
        assert (JSRuntime.isSafeInteger(index));
        return JSProxy.proxyGetHelper(store, Boundaries.stringValueOf(index), receiver);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object proxyGetHelper(DynamicObject proxy, Object key, Object receiver) {
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject handler = JSProxy.getHandler(proxy);
        TruffleObject target = JSProxy.getTarget(proxy);
        TruffleObject trap = JSProxy.getTrapFromObject(handler, GET);
        if (trap == Undefined.instance) {
            if (JSObject.isJSObject(target)) {
                return JSObject.getJSClass((DynamicObject)target).getHelper((DynamicObject)target, receiver, key);
            }
            return JSInteropUtil.readMemberOrDefault(target, key, null);
        }
        Object trapResult = JSRuntime.call(trap, handler, new Object[]{target, key, receiver});
        JSProxy.checkProxyGetTrapInvariants(target, key, trapResult);
        return trapResult;
    }

    @CompilerDirectives.TruffleBoundary
    public static void checkProxyGetTrapInvariants(TruffleObject truffleTarget, Object key, Object trapResult) {
        assert (JSRuntime.isPropertyKey(key));
        if (!JSObject.isJSObject(truffleTarget)) {
            return;
        }
        DynamicObject target = (DynamicObject)truffleTarget;
        PropertyDescriptor targetDesc = JSObject.getOwnProperty(target, key);
        if (targetDesc != null) {
            Object targetValue;
            if (targetDesc.isDataDescriptor() && !targetDesc.getConfigurable() && !targetDesc.getWritable() && !JSRuntime.isSameValue(trapResult, targetValue = targetDesc.getValue())) {
                throw Errors.createTypeErrorProxyGetInvariantViolated(key, targetValue, trapResult);
            }
            if (targetDesc.isAccessorDescriptor() && !targetDesc.getConfigurable() && targetDesc.getGet() == Undefined.instance && trapResult != Undefined.instance) {
                throw Errors.createTypeError("Trap result must be undefined since the proxy target has a corresponding non-configurable own accessor property with undefined getter");
            }
        }
    }

    @Override
    public boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        return this.setOwn(thisObj, key, value, receiver, isStrict);
    }

    @Override
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        return this.setOwn(thisObj, index, value, receiver, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setOwn(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        return JSProxy.proxySet(thisObj, Boundaries.stringValueOf(index), value, receiver, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setOwn(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        return JSProxy.proxySet(thisObj, key, value, receiver, isStrict);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean proxySet(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject handler = JSProxy.getHandler(thisObj);
        TruffleObject target = JSProxy.getTarget(thisObj);
        TruffleObject trap = JSProxy.getTrapFromObject(handler, SET);
        if (trap == Undefined.instance) {
            if (JSObject.isJSObject(target)) {
                boolean result = JSReflectUtils.performOrdinarySet((DynamicObject)target, key, value, receiver);
                if (isStrict && !result) {
                    throw Errors.createTypeErrorCannotSetProperty(key, thisObj, null);
                }
                return result;
            }
            JSInteropUtil.writeMember(target, key, value);
            return true;
        }
        Object trapResult = JSRuntime.call(trap, handler, new Object[]{target, key, value, receiver});
        boolean booleanTrapResult = JSRuntime.toBoolean(trapResult);
        if (!booleanTrapResult) {
            if (isStrict) {
                throw Errors.createTypeErrorTrapReturnedFalsish(SET, key);
            }
            return false;
        }
        return JSProxy.checkProxySetTrapInvariants(thisObj, key, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean checkProxySetTrapInvariants(DynamicObject proxy, Object key, Object value) {
        assert (JSProxy.isProxy(proxy));
        assert (JSRuntime.isPropertyKey(key));
        TruffleObject target = JSProxy.getTarget(proxy);
        if (!JSObject.isJSObject(target)) {
            return true;
        }
        PropertyDescriptor targetDesc = JSObject.getOwnProperty((DynamicObject)target, key);
        if (targetDesc != null) {
            if (targetDesc.isDataDescriptor() && !targetDesc.getConfigurable() && !targetDesc.getWritable()) {
                if (!JSRuntime.isSameValue(value, targetDesc.getValue())) {
                    throw Errors.createTypeError("Cannot change the value of a non-writable, non-configurable own data property");
                }
            } else if (targetDesc.isAccessorDescriptor() && !targetDesc.getConfigurable() && targetDesc.getSet() == Undefined.instance) {
                throw Errors.createTypeError("Cannot set the value of a non-configurable own accessor property with undefined setter");
            }
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, long index) {
        return this.hasOwnProperty(thisObj, JSRuntime.toString(index));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isObject(thisObj));
        assert (JSRuntime.isPropertyKey(key));
        PropertyDescriptor desc = JSObject.getOwnProperty(thisObj, key);
        return desc != null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(DynamicObject thisObj, long index) {
        return this.hasProperty(thisObj, JSRuntime.toString(index));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject handler = JSProxy.getHandler(thisObj);
        TruffleObject target = JSProxy.getTarget(thisObj);
        TruffleObject trap = JSProxy.getTrapFromObject(handler, HAS);
        if (trap == Undefined.instance) {
            return JSObject.hasOwnProperty(target, key);
        }
        boolean trapResult = JSRuntime.toBoolean(JSRuntime.call(trap, handler, new Object[]{target, key}));
        if (!trapResult && !JSProxy.isAccessibleProperty(thisObj, key)) {
            throw Errors.createTypeErrorConfigurableExpected();
        }
        return trapResult;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        return this.delete(thisObj, String.valueOf(index), isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject handler = JSProxy.getHandlerChecked(thisObj);
        TruffleObject target = JSProxy.getTarget(thisObj);
        TruffleObject deleteFn = JSProxy.getTrapFromObject(handler, DELETE_PROPERTY);
        if (deleteFn == Undefined.instance) {
            if (JSObject.isJSObject(target)) {
                return JSObject.delete((DynamicObject)target, key, isStrict);
            }
            return JSInteropUtil.remove(target, key);
        }
        Object trapResult = JSRuntime.call(deleteFn, handler, new Object[]{target, key});
        boolean booleanTrapResult = JSRuntime.toBoolean(trapResult);
        if (!booleanTrapResult) {
            if (isStrict) {
                throw Errors.createTypeErrorTrapReturnedFalsish(DELETE_PROPERTY, key);
            }
            return false;
        }
        if (!JSObject.isJSObject(target)) {
            return true;
        }
        PropertyDescriptor targetDesc = JSObject.getOwnProperty((DynamicObject)target, key);
        if (targetDesc == null) {
            return true;
        }
        if (targetDesc.hasConfigurable() && !targetDesc.getConfigurable()) {
            throw Errors.createTypeErrorConfigurableExpected();
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        boolean settingConfigFalse;
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject handler = JSProxy.getHandlerChecked(thisObj);
        TruffleObject target = JSProxy.getTarget(thisObj);
        TruffleObject definePropertyFn = JSProxy.getTrapFromObject(handler, DEFINE_PROPERTY);
        if (definePropertyFn == Undefined.instance) {
            if (JSObject.isJSObject(target)) {
                return JSObject.defineOwnProperty((DynamicObject)target, key, desc, doThrow);
            }
            JSInteropUtil.writeMember(target, key, Null.instance);
            return true;
        }
        JSContext context = JSObject.getJSContext(thisObj);
        DynamicObject descObj = JSRuntime.fromPropertyDescriptor(desc, context);
        boolean trapResult = JSRuntime.toBoolean(JSRuntime.call(definePropertyFn, handler, new Object[]{target, key, descObj}));
        if (!trapResult) {
            if (doThrow) {
                throw Errors.createTypeErrorTrapReturnedFalsish(DEFINE_PROPERTY, key);
            }
            return false;
        }
        if (!JSObject.isJSObject(target)) {
            return true;
        }
        PropertyDescriptor targetDesc = JSObject.getOwnProperty((DynamicObject)target, key);
        boolean extensibleTarget = JSObject.isExtensible((DynamicObject)target);
        boolean bl = settingConfigFalse = desc.hasConfigurable() && !desc.getConfigurable();
        if (targetDesc == null) {
            if (!extensibleTarget) {
                throw Errors.createTypeError("ES 9.5.6 19.a");
            }
            if (settingConfigFalse) {
                throw Errors.createTypeError("ES 9.5.6 19.b");
            }
        } else {
            if (!JSProxy.isCompatiblePropertyDescriptor(extensibleTarget, desc, targetDesc)) {
                throw Errors.createTypeError("ES 9.5.6 20.a");
            }
            if (settingConfigFalse && targetDesc.getConfigurable()) {
                throw Errors.createTypeError("ES 9.5.6 20.b");
            }
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private static PropertyDescriptor completePropertyDescriptor(PropertyDescriptor desc) {
        if (desc.isGenericDescriptor() || desc.isDataDescriptor()) {
            if (!desc.hasValue()) {
                desc.setValue(Undefined.instance);
            }
            if (!desc.hasWritable()) {
                desc.setWritable(false);
            }
        } else {
            if (!desc.hasGet()) {
                desc.setGet(null);
            }
            if (!desc.hasSet()) {
                desc.setSet(null);
            }
        }
        if (!desc.hasEnumerable()) {
            desc.setEnumerable(false);
        }
        if (!desc.hasConfigurable()) {
            desc.setConfigurable(false);
        }
        return desc;
    }

    private static boolean isCompatiblePropertyDescriptor(boolean extensibleTarget, PropertyDescriptor desc, PropertyDescriptor current) {
        return DefinePropertyUtil.isCompatiblePropertyDescriptor(extensibleTarget, desc, current);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean preventExtensions(DynamicObject thisObj) {
        boolean targetIsExtensible;
        DynamicObject handler = JSProxy.getHandlerChecked(thisObj);
        TruffleObject target = JSProxy.getTarget(thisObj);
        TruffleObject preventExtensionsFn = JSProxy.getTrapFromObject(handler, PREVENT_EXTENSIONS);
        if (preventExtensionsFn == Undefined.instance) {
            if (JSObject.isJSObject(target)) {
                return JSObject.preventExtensions((DynamicObject)target);
            }
            return true;
        }
        Object returnValue = JSRuntime.call(preventExtensionsFn, handler, new Object[]{target});
        boolean booleanTrapResult = JSRuntime.toBoolean(returnValue);
        if (booleanTrapResult && JSObject.isJSObject(target) && (targetIsExtensible = JSObject.isExtensible((DynamicObject)target))) {
            throw Errors.createTypeError("target is extensible");
        }
        return booleanTrapResult;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isExtensible(DynamicObject thisObj) {
        DynamicObject handler = JSProxy.getHandlerChecked(thisObj);
        TruffleObject target = JSProxy.getTarget(thisObj);
        TruffleObject isExtensibleFn = JSProxy.getTrapFromObject(handler, IS_EXTENSIBLE);
        if (isExtensibleFn == Undefined.instance) {
            if (JSObject.isJSObject(target)) {
                return JSObject.isExtensible((DynamicObject)target);
            }
            return true;
        }
        Object returnValue = JSRuntime.call(isExtensibleFn, handler, new Object[]{target});
        boolean booleanTrapResult = JSRuntime.toBoolean(returnValue);
        if (!JSObject.isJSObject(target)) {
            return booleanTrapResult;
        }
        boolean targetResult = JSObject.isExtensible((DynamicObject)target);
        if (booleanTrapResult != targetResult) {
            throw Errors.createTypeErrorSameResultExpected();
        }
        return booleanTrapResult;
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        TruffleObject targetNonProxy = JSProxy.getTargetNonProxy(object);
        if (JSObject.isJSObject(targetNonProxy)) {
            return JSObject.getJSClass((DynamicObject)targetNonProxy).getBuiltinToStringTag((DynamicObject)targetNonProxy);
        }
        return "Foreign";
    }

    @Override
    public String safeToString(DynamicObject obj, int depth) {
        if (JSTruffleOptions.NashornCompatibilityMode) {
            return this.defaultToString(obj);
        }
        TruffleObject target = JSProxy.getTarget(obj);
        DynamicObject handler = JSProxy.getHandler(obj);
        return "Proxy(" + JSRuntime.safeToString(target, depth, obj) + ", " + JSRuntime.safeToString(handler, depth, obj) + ")";
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = initialShape.addProperty(PROXY_TARGET_PROPERTY);
        initialShape = initialShape.addProperty(PROXY_HANDLER_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        DynamicObject proxyConstructor = realm.lookupFunction("%Constructors%", CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer(realm, proxyConstructor, CLASS_NAME);
        DynamicObject dummyPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        return new JSConstructor(proxyConstructor, dummyPrototype);
    }

    public static TruffleObject getTrapFromObject(DynamicObject maybeHandler, String trapName) {
        Object method = JSObject.get(maybeHandler, (Object)trapName);
        if (method == Undefined.instance || method == Null.instance) {
            return Undefined.instance;
        }
        if (!JSRuntime.isCallable(method)) {
            throw Errors.createTypeErrorNotAFunction(method);
        }
        return (TruffleObject)method;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public DynamicObject getPrototypeOf(DynamicObject thisObj) {
        DynamicObject handler = JSProxy.getHandlerChecked(thisObj);
        TruffleObject target = JSProxy.getTarget(thisObj);
        TruffleObject getPrototypeOfFn = JSProxy.getTrapFromObject(handler, GET_PROTOTYPE_OF);
        if (getPrototypeOfFn == Undefined.instance) {
            if (JSObject.isJSObject(target)) {
                return JSObject.getPrototype((DynamicObject)target);
            }
            return Null.instance;
        }
        Object handlerProto = JSRuntime.call(getPrototypeOfFn, handler, new Object[]{target});
        if (!JSObject.isJSObject(handlerProto) || handlerProto == Undefined.instance) {
            throw Errors.createTypeError("object or null expected");
        }
        DynamicObject handlerProtoObj = (DynamicObject)handlerProto;
        if (!JSObject.isJSObject(target)) {
            return handlerProtoObj;
        }
        boolean extensibleTarget = JSObject.isExtensible((DynamicObject)target);
        if (extensibleTarget) {
            return handlerProtoObj;
        }
        DynamicObject targetProtoObj = JSObject.getPrototype((DynamicObject)target);
        if (handlerProtoObj != targetProtoObj) {
            throw Errors.createTypeErrorSameResultExpected();
        }
        return handlerProtoObj;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setPrototypeOf(DynamicObject thisObj, DynamicObject newPrototype) {
        assert (JSObject.isDynamicObject(newPrototype) || newPrototype == Null.instance);
        DynamicObject handler = JSProxy.getHandlerChecked(thisObj);
        TruffleObject target = JSProxy.getTarget(thisObj);
        TruffleObject setPrototypeOfFn = JSProxy.getTrapFromObject(handler, SET_PROTOTYPE_OF);
        if (setPrototypeOfFn == Undefined.instance) {
            if (JSObject.isJSObject(target)) {
                return JSObject.setPrototype((DynamicObject)target, newPrototype);
            }
            return true;
        }
        Object returnValue = JSRuntime.call(setPrototypeOfFn, handler, new Object[]{target, newPrototype});
        boolean booleanTrapResult = JSRuntime.toBoolean(returnValue);
        if (!booleanTrapResult) {
            return false;
        }
        if (!JSObject.isJSObject(target)) {
            return true;
        }
        boolean targetIsExtensible = JSObject.isExtensible((DynamicObject)target);
        if (targetIsExtensible) {
            return true;
        }
        DynamicObject targetProto = JSObject.getPrototype((DynamicObject)target);
        if (newPrototype != targetProto) {
            throw Errors.createTypeErrorSameResultExpected();
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        return JSProxy.filterOwnPropertyKeys(JSProxy.ownPropertyKeysProxy(thisObj), strings, symbols);
    }

    private static List<Object> ownPropertyKeysProxy(DynamicObject thisObj) {
        DynamicObject handler = JSProxy.getHandlerChecked(thisObj);
        TruffleObject target = JSProxy.getTarget(thisObj);
        TruffleObject ownKeysFn = JSProxy.getTrapFromObject(handler, OWN_KEYS);
        if (ownKeysFn == Undefined.instance) {
            if (JSObject.isJSObject(target)) {
                return JSObject.ownPropertyKeys((DynamicObject)target);
            }
            return JSInteropUtil.keys(target);
        }
        Object trapResultArray = JSRuntime.call(ownKeysFn, handler, new Object[]{target});
        List<Object> trapResult = JSRuntime.createListFromArrayLikeAllowSymbolString(trapResultArray);
        if (!JSObject.isJSObject(target)) {
            ArrayList<Object> uncheckedResultKeys = new ArrayList<Object>();
            Boundaries.listAddAll(uncheckedResultKeys, trapResult);
            return uncheckedResultKeys;
        }
        JSContext context = JSObject.getJSContext(thisObj);
        if (!context.isOptionV8CompatibilityMode() && context.getEcmaScriptVersion() >= 9 && JSProxy.containsDuplicateEntries(trapResult)) {
            throw Errors.createTypeError("trap result contains duplicate entries");
        }
        boolean extensibleTarget = JSObject.isExtensible((DynamicObject)target);
        List<Object> targetKeys = JSObject.ownPropertyKeys((DynamicObject)target);
        ArrayList targetConfigurableKeys = new ArrayList();
        ArrayList targetNonconfigurableKeys = new ArrayList();
        for (Object t : targetKeys) {
            PropertyDescriptor desc = JSObject.getOwnProperty((DynamicObject)target, t);
            if (desc != null && !desc.getConfigurable()) {
                Boundaries.listAdd(targetNonconfigurableKeys, t);
                continue;
            }
            Boundaries.listAdd(targetConfigurableKeys, t);
        }
        if (extensibleTarget && targetNonconfigurableKeys.isEmpty()) {
            return trapResult;
        }
        ArrayList uncheckedResultKeys = new ArrayList();
        Boundaries.listAddAll(uncheckedResultKeys, trapResult);
        assert (trapResult.size() == uncheckedResultKeys.size());
        for (Object key : targetNonconfigurableKeys) {
            if (!uncheckedResultKeys.contains(key)) {
                throw Errors.createTypeErrorFormat("'ownKeys' on proxy: trap result did not include '%s'", key);
            }
            while (uncheckedResultKeys.remove(key)) {
            }
        }
        if (extensibleTarget) {
            return trapResult;
        }
        for (Object key : targetConfigurableKeys) {
            if (!uncheckedResultKeys.contains(key)) {
                throw Errors.createTypeError("Proxy.ownPropertyKeys, 23.a");
            }
            while (uncheckedResultKeys.remove(key)) {
            }
        }
        if (!uncheckedResultKeys.isEmpty()) {
            throw Errors.createTypeError("Proxy.ownPropertyKeys, 24");
        }
        return trapResult;
    }

    private static boolean containsDuplicateEntries(List<Object> trapResult) {
        for (int i = 0; i < trapResult.size(); ++i) {
            Object entry = trapResult.get(i);
            for (int j = i + 1; j < trapResult.size(); ++j) {
                if (!entry.equals(trapResult.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject handler = JSProxy.getHandlerChecked(thisObj);
        TruffleObject target = JSProxy.getTarget(thisObj);
        TruffleObject getOwnPropertyFn = JSProxy.getTrapFromObject(handler, GET_OWN_PROPERTY_DESCRIPTOR);
        if (getOwnPropertyFn == Undefined.instance) {
            if (JSObject.isJSObject(target)) {
                return JSObject.getOwnProperty((DynamicObject)target, key);
            }
            return null;
        }
        Object trapResultObj = JSProxy.checkTrapReturnValue(JSRuntime.call(getOwnPropertyFn, handler, new Object[]{target, key}));
        if (!JSObject.isJSObject(target)) {
            return JSRuntime.toPropertyDescriptor(trapResultObj);
        }
        PropertyDescriptor targetDesc = JSObject.getOwnProperty((DynamicObject)target, key);
        if (trapResultObj == Undefined.instance) {
            if (targetDesc == null) {
                return null;
            }
            if (targetDesc.hasConfigurable() && !targetDesc.getConfigurable()) {
                throw Errors.createTypeErrorConfigurableExpected();
            }
            boolean isExtensible = JSObject.isExtensible((DynamicObject)target);
            if (!isExtensible) {
                throw Errors.createTypeError("not extensible");
            }
            return null;
        }
        boolean extensibleTarget = JSObject.isExtensible((DynamicObject)target);
        PropertyDescriptor resultDesc = JSRuntime.toPropertyDescriptor(trapResultObj);
        JSProxy.completePropertyDescriptor(resultDesc);
        boolean valid = JSProxy.isCompatiblePropertyDescriptor(extensibleTarget, resultDesc, targetDesc);
        if (!valid) {
            throw Errors.createTypeError("not a valid descriptor");
        }
        if (!resultDesc.getConfigurable() && (targetDesc == null || targetDesc.hasConfigurable() && targetDesc.getConfigurable())) {
            throw Errors.createTypeErrorConfigurableExpected();
        }
        return resultDesc;
    }

    public static boolean isRevoked(DynamicObject proxy) {
        assert (JSProxy.isProxy(proxy)) : "Only proxy objects can be revoked";
        return JSProxy.getHandler(proxy) == Null.instance;
    }

    public static Object checkTrapReturnValue(Object trapResult) {
        if (JSObject.isDynamicObject(trapResult) || trapResult == Undefined.instance) {
            return trapResult;
        }
        throw Errors.createTypeError("proxy must return an object");
    }

    @CompilerDirectives.TruffleBoundary
    public static Object call(DynamicObject proxyObj, Object holder, Object[] arguments) {
        DynamicObject handler = JSProxy.getHandlerChecked(proxyObj);
        TruffleObject target = JSProxy.getTarget(proxyObj);
        TruffleObject trap = JSProxy.getTrapFromObject(handler, APPLY);
        if (trap == Undefined.instance) {
            return JSRuntime.call(target, holder, arguments);
        }
        JSContext ctx = JSObject.getJSContext(proxyObj);
        return JSRuntime.call(trap, handler, new Object[]{target, holder, JSArray.createConstant(ctx, arguments)});
    }

    @CompilerDirectives.TruffleBoundary
    public static Object construct(DynamicObject proxyObj, Object[] arguments) {
        if (!JSRuntime.isConstructorProxy(proxyObj)) {
            throw Errors.createTypeErrorNotAFunction(proxyObj);
        }
        DynamicObject handler = JSProxy.getHandlerChecked(proxyObj);
        TruffleObject target = JSProxy.getTarget(proxyObj);
        TruffleObject trap = JSProxy.getTrapFromObject(handler, CONSTRUCT);
        DynamicObject newTarget = proxyObj;
        if (trap == Undefined.instance) {
            return JSRuntime.construct(target, arguments);
        }
        JSContext ctx = JSObject.getJSContext(proxyObj);
        Object result = JSRuntime.call(trap, handler, new Object[]{target, JSArray.createConstant(ctx, arguments), newTarget});
        if (!JSRuntime.isObject(result)) {
            throw Errors.createTypeErrorNotAnObject(result);
        }
        return result;
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getProxyPrototype();
    }

    static {
        PROXY_TARGET = new HiddenKey("ProxyTarget");
        PROXY_HANDLER = new HiddenKey("ProxyHandler");
        REVOCABLE_PROXY = new HiddenKey("RevocableProxy");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        PROXY_TARGET_PROPERTY = JSObjectUtil.makeHiddenProperty(PROXY_TARGET, allocator.locationForType(TruffleObject.class));
        PROXY_HANDLER_PROPERTY = JSObjectUtil.makeHiddenProperty(PROXY_HANDLER, allocator.locationForType(DynamicObject.class));
    }
}

