/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;

public final class ContiguousObjectArray
extends AbstractContiguousObjectArray {
    private static final ContiguousObjectArray CONTIGUOUS_OBJECT_ARRAY = new ContiguousObjectArray(0, ContiguousObjectArray.createCache());

    public static ContiguousObjectArray makeContiguousObjectArray(DynamicObject object, long length, Object[] array, long indexOffset, int arrayOffset, int usedLength, int integrityLevel) {
        ContiguousObjectArray arrayType = (ContiguousObjectArray)ContiguousObjectArray.createContiguousObjectArray().setIntegrityLevel(integrityLevel);
        ContiguousObjectArray.setArrayProperties(object, array, length, usedLength, indexOffset, arrayOffset);
        return arrayType;
    }

    private static ContiguousObjectArray createContiguousObjectArray() {
        return CONTIGUOUS_OBJECT_ARRAY;
    }

    private ContiguousObjectArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    protected int prepareInBounds(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.prepareInBoundsContiguous(object, index, condition, profile);
    }

    @Override
    protected int prepareSupported(DynamicObject object, int index, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.prepareSupportedContiguous(object, index, condition, profile);
    }

    @Override
    public boolean isSupported(DynamicObject object, long index, boolean condition) {
        return this.isSupportedContiguous(object, index, condition);
    }

    @Override
    public HolesObjectArray toHoles(DynamicObject object, long index, Object value, boolean condition) {
        Object[] array = ContiguousObjectArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ContiguousObjectArray.getUsedLength(object, condition);
        int arrayOffset = this.getArrayOffset(object, condition);
        long indexOffset = this.getIndexOffset(object, condition);
        HolesObjectArray newArray = HolesObjectArray.makeHolesObjectArray(object, length, array, indexOffset, arrayOffset, usedLength, 0, this.integrityLevel);
        if (JSTruffleOptions.TraceArrayTransitions) {
            ContiguousObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ZeroBasedObjectArray toNonContiguous(DynamicObject object, int index, Object value, boolean condition, ScriptArray.ProfileHolder profile) {
        this.setSupported(object, index, value, condition);
        Object[] array = ContiguousObjectArray.getArray(object, condition);
        int length = this.lengthInt(object, condition);
        int usedLength = ContiguousObjectArray.getUsedLength(object, condition);
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, length, usedLength, array, this.integrityLevel);
        if (JSTruffleOptions.TraceArrayTransitions) {
            ContiguousObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        return this.removeRangeContiguous(object, start, end);
    }

    @Override
    protected ContiguousObjectArray withIntegrityLevel(int newIntegrityLevel) {
        return new ContiguousObjectArray(newIntegrityLevel, this.cache);
    }
}

