/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.control.AwaitNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public class AsyncIteratorCloseWrapperNode
extends AwaitNode {
    @Node.Child
    private JavaScriptNode loopNode;
    @Node.Child
    private GetMethodNode getReturnNode;
    @Node.Child
    private JSFunctionCallNode returnMethodCallNode;
    @Node.Child
    private JavaScriptNode iteratorNode;
    private final BranchProfile errorBranch = BranchProfile.create();
    private final BranchProfile throwBranch = BranchProfile.create();
    private final BranchProfile exitBranch = BranchProfile.create();
    private final BranchProfile notDoneBranch = BranchProfile.create();
    private final ValueProfile typeProfile = ValueProfile.createClassProfile();

    protected AsyncIteratorCloseWrapperNode(JSContext context, JavaScriptNode loopNode, JavaScriptNode iteratorNode, JSReadFrameSlotNode asyncContextNode, JSReadFrameSlotNode asyncResultNode) {
        super(context, null, asyncContextNode, asyncResultNode);
        this.loopNode = loopNode;
        this.iteratorNode = iteratorNode;
        this.getReturnNode = GetMethodNode.create(context, null, "return");
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode loopNode, JavaScriptNode iterator, JSReadFrameSlotNode asyncContextNode, JSReadFrameSlotNode asyncResultNode) {
        return new AsyncIteratorCloseWrapperNode(context, loopNode, iterator, asyncContextNode, asyncResultNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Completion completion;
        Object innerResult;
        block12: {
            Object result;
            try {
                result = this.loopNode.execute(frame);
            }
            catch (YieldException e) {
                throw e;
            }
            catch (ControlFlowException e) {
                this.exitBranch.enter();
                IteratorRecord iteratorRecord = this.getIteratorRecord(frame);
                DynamicObject iterator = iteratorRecord.getIterator();
                Object returnMethod = this.getReturnNode.executeWithTarget(frame, iterator);
                if (returnMethod != Undefined.instance) {
                    innerResult = this.getReturnMethodCallNode().executeCall(JSArguments.createZeroArg(iterator, returnMethod));
                    completion = Completion.forReturn((Object)e);
                    break block12;
                }
                throw e;
            }
            catch (Throwable e) {
                if (TryCatchNode.shouldCatch(e, this.typeProfile)) {
                    this.throwBranch.enter();
                    IteratorRecord iteratorRecord = this.getIteratorRecord(frame);
                    DynamicObject iterator = iteratorRecord.getIterator();
                    Object returnMethod = this.getReturnNode.executeWithTarget(frame, iterator);
                    if (returnMethod != Undefined.instance) {
                        try {
                            innerResult = this.getReturnMethodCallNode().executeCall(JSArguments.createZeroArg(iterator, returnMethod));
                        }
                        catch (Exception ex) {
                            throw e;
                        }
                        completion = Completion.forThrow(e);
                        break block12;
                    }
                    throw e;
                }
                throw e;
            }
            IteratorRecord iteratorRecord = this.getIteratorRecord(frame);
            if (iteratorRecord.isDone()) {
                return result;
            }
            this.notDoneBranch.enter();
            DynamicObject iterator = iteratorRecord.getIterator();
            Object returnMethod = this.getReturnNode.executeWithTarget(frame, iterator);
            if (returnMethod != Undefined.instance) {
                innerResult = this.getReturnMethodCallNode().executeCall(JSArguments.createZeroArg(iterator, returnMethod));
                completion = Completion.forNormal(result);
            } else {
                return result;
            }
        }
        this.setState(frame, completion);
        return this.suspendAwait(frame, innerResult);
    }

    @Override
    public Object resume(VirtualFrame frame) {
        Object state = this.getState(frame);
        if (state == Undefined.instance) {
            return this.execute(frame);
        }
        this.resetState(frame);
        Completion completion = (Completion)state;
        if (completion.isThrow()) {
            throw JSRuntime.rethrow((Throwable)completion.getValue());
        }
        Object innerResult = this.resumeAwait(frame);
        if (!JSObject.isJSObject(innerResult)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorIterResultNotAnObject(innerResult, this);
        }
        if (completion.isAbrupt()) {
            throw JSRuntime.rethrow((Throwable)completion.getValue());
        }
        return completion.getValue();
    }

    private IteratorRecord getIteratorRecord(VirtualFrame frame) {
        return (IteratorRecord)this.iteratorNode.execute(frame);
    }

    private JSFunctionCallNode getReturnMethodCallNode() {
        if (this.returnMethodCallNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.returnMethodCallNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        return this.returnMethodCallNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return new AsyncIteratorCloseWrapperNode(this.context, AsyncIteratorCloseWrapperNode.cloneUninitialized(this.loopNode), AsyncIteratorCloseWrapperNode.cloneUninitialized(this.iteratorNode), AsyncIteratorCloseWrapperNode.cloneUninitialized(this.readAsyncContextNode), AsyncIteratorCloseWrapperNode.cloneUninitialized(this.readAsyncResultNode));
    }
}

