/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToInt32Node.class)
public final class JSToInt32NodeGen
extends JSToInt32Node
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private JSStringToNumberNode string_stringToNumberNode_;
    @Node.Child
    private JSToDoubleNode jSObject_toDoubleNode_;
    @Node.Child
    private JSToPrimitiveNode foreignObject_toPrimitiveNode_;
    @Node.Child
    private JSToInt32Node foreignObject_toInt32Node_;

    private JSToInt32NodeGen(JavaScriptNode operand) {
        super(operand);
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        DynamicObject operandNodeValue_;
        long operandNodeValue_2;
        int state = this.state_;
        if ((state & 1) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_3 = (Integer)operandNodeValue;
            return this.doInteger(operandNodeValue_3);
        }
        if ((state & 2) != 0 && operandNodeValue instanceof LargeInteger) {
            LargeInteger operandNodeValue_4 = (LargeInteger)operandNodeValue;
            return this.doLargeInteger(operandNodeValue_4);
        }
        if ((state & 4) != 0 && operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_5 = (Boolean)operandNodeValue;
            return this.doBoolean(operandNodeValue_5);
        }
        if ((state & 8) != 0 && operandNodeValue instanceof Long && JSGuards.isLongRepresentableAsInt32(operandNodeValue_2 = ((Long)operandNodeValue).longValue())) {
            return this.doLong(operandNodeValue_2);
        }
        if ((state & 0xF0) != 0 && JSTypesGen.isImplicitDouble((state & 0x78000) >>> 15, operandNodeValue)) {
            double operandNodeValue_6 = JSTypesGen.asImplicitDouble((state & 0x78000) >>> 15, operandNodeValue);
            if ((state & 0x10) != 0 && !JSGuards.isDoubleLargerThan2e32(operandNodeValue_6)) {
                return this.doDoubleFitsInt(operandNodeValue_6);
            }
            if ((state & 0x20) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6) && JSGuards.isDoubleSafeInteger(operandNodeValue_6)) {
                return this.doDoubleRepresentableAsSafeInteger(operandNodeValue_6);
            }
            if ((state & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                return this.doDoubleRepresentableAsLong(operandNodeValue_6);
            }
            if ((state & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                return this.doDouble(operandNodeValue_6);
            }
        }
        if ((state & 0x300) != 0) {
            if ((state & 0x100) != 0 && JSGuards.isUndefined(operandNodeValue)) {
                return this.doUndefined(operandNodeValue);
            }
            if ((state & 0x200) != 0 && JSGuards.isJSNull(operandNodeValue)) {
                return this.doNull(operandNodeValue);
            }
        }
        if ((state & 0x400) != 0 && JSTypesGen.isImplicitString((state & 0x780000) >>> 19, operandNodeValue)) {
            String operandNodeValue_7 = JSTypesGen.asImplicitString((state & 0x780000) >>> 19, operandNodeValue);
            return this.doString(operandNodeValue_7, this.string_stringToNumberNode_);
        }
        if ((state & 0x800) != 0 && operandNodeValue instanceof Symbol) {
            Symbol operandNodeValue_8 = (Symbol)operandNodeValue;
            return this.doSymbol(operandNodeValue_8);
        }
        if ((state & 0x1000) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_9 = (BigInt)operandNodeValue;
            return this.doBigInt(operandNodeValue_9);
        }
        if ((state & 0x2000) != 0 && JSTypes.isDynamicObject(operandNodeValue) && JSGuards.isJSObject(operandNodeValue_ = (DynamicObject)operandNodeValue)) {
            return this.doJSObject(operandNodeValue_, this.jSObject_toDoubleNode_);
        }
        if ((state & 0x4000) != 0 && operandNodeValue instanceof TruffleObject && JSGuards.isForeignObject(operandNodeValue_ = (TruffleObject)operandNodeValue)) {
            return JSToInt32Node.doForeignObject(operandNodeValue_, this.foreignObject_toPrimitiveNode_, this.foreignObject_toInt32Node_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public int executeInt(Object operandNodeValue) {
        DynamicObject operandNodeValue_;
        long operandNodeValue_2;
        int state = this.state_;
        if ((state & 1) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_3 = (Integer)operandNodeValue;
            return this.doInteger(operandNodeValue_3);
        }
        if ((state & 2) != 0 && operandNodeValue instanceof LargeInteger) {
            LargeInteger operandNodeValue_4 = (LargeInteger)operandNodeValue;
            return this.doLargeInteger(operandNodeValue_4);
        }
        if ((state & 4) != 0 && operandNodeValue instanceof Boolean) {
            boolean operandNodeValue_5 = (Boolean)operandNodeValue;
            return this.doBoolean(operandNodeValue_5);
        }
        if ((state & 8) != 0 && operandNodeValue instanceof Long && JSGuards.isLongRepresentableAsInt32(operandNodeValue_2 = ((Long)operandNodeValue).longValue())) {
            return this.doLong(operandNodeValue_2);
        }
        if ((state & 0xF0) != 0 && JSTypesGen.isImplicitDouble((state & 0x78000) >>> 15, operandNodeValue)) {
            double operandNodeValue_6 = JSTypesGen.asImplicitDouble((state & 0x78000) >>> 15, operandNodeValue);
            if ((state & 0x10) != 0 && !JSGuards.isDoubleLargerThan2e32(operandNodeValue_6)) {
                return this.doDoubleFitsInt(operandNodeValue_6);
            }
            if ((state & 0x20) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6) && JSGuards.isDoubleSafeInteger(operandNodeValue_6)) {
                return this.doDoubleRepresentableAsSafeInteger(operandNodeValue_6);
            }
            if ((state & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                return this.doDoubleRepresentableAsLong(operandNodeValue_6);
            }
            if ((state & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                return this.doDouble(operandNodeValue_6);
            }
        }
        if ((state & 0x300) != 0) {
            if ((state & 0x100) != 0 && JSGuards.isUndefined(operandNodeValue)) {
                return this.doUndefined(operandNodeValue);
            }
            if ((state & 0x200) != 0 && JSGuards.isJSNull(operandNodeValue)) {
                return this.doNull(operandNodeValue);
            }
        }
        if ((state & 0x400) != 0 && JSTypesGen.isImplicitString((state & 0x780000) >>> 19, operandNodeValue)) {
            String operandNodeValue_7 = JSTypesGen.asImplicitString((state & 0x780000) >>> 19, operandNodeValue);
            return this.doString(operandNodeValue_7, this.string_stringToNumberNode_);
        }
        if ((state & 0x800) != 0 && operandNodeValue instanceof Symbol) {
            Symbol operandNodeValue_8 = (Symbol)operandNodeValue;
            return this.doSymbol(operandNodeValue_8);
        }
        if ((state & 0x1000) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_9 = (BigInt)operandNodeValue;
            return this.doBigInt(operandNodeValue_9);
        }
        if ((state & 0x2000) != 0 && JSTypes.isDynamicObject(operandNodeValue) && JSGuards.isJSObject(operandNodeValue_ = (DynamicObject)operandNodeValue)) {
            return this.doJSObject(operandNodeValue_, this.jSObject_toDoubleNode_);
        }
        if ((state & 0x4000) != 0 && operandNodeValue instanceof TruffleObject && JSGuards.isForeignObject(operandNodeValue_ = (TruffleObject)operandNodeValue)) {
            return JSToInt32Node.doForeignObject(operandNodeValue_, this.foreignObject_toPrimitiveNode_, this.foreignObject_toInt32Node_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x7FFE) == 0 && (state & Short.MAX_VALUE) != 0) {
            return this.executeInt_int0(frameValue, state);
        }
        if ((state & 0x7FFB) == 0 && (state & Short.MAX_VALUE) != 0) {
            return this.executeInt_boolean1(frameValue, state);
        }
        if ((state & 0x7FF7) == 0 && (state & Short.MAX_VALUE) != 0) {
            return this.executeInt_long2(frameValue, state);
        }
        if ((state & 0x7F0F) == 0 && (state & Short.MAX_VALUE) != 0) {
            return this.executeInt_double3(frameValue, state);
        }
        return this.executeInt_generic4(frameValue, state);
    }

    private int executeInt_int0(VirtualFrame frameValue, int state) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doInteger(operandNodeValue_);
    }

    private int executeInt_boolean1(VirtualFrame frameValue, int state) {
        boolean operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 4) != 0);
        return this.doBoolean(operandNodeValue_);
    }

    private int executeInt_long2(VirtualFrame frameValue, int state) {
        long operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 8) != 0);
        if (JSGuards.isLongRepresentableAsInt32(operandNodeValue_)) {
            return this.doLong(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    private int executeInt_double3(VirtualFrame frameValue, int state) {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0x70000) == 0 && (state & Short.MAX_VALUE) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0x68000) == 0 && (state & Short.MAX_VALUE) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0x58000) == 0 && (state & Short.MAX_VALUE) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x78000) >>> 15, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        if ((state & 0x10) != 0 && !JSGuards.isDoubleLargerThan2e32(operandNodeValue_)) {
            return this.doDoubleFitsInt(operandNodeValue_);
        }
        if ((state & 0x20) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_) && JSGuards.isDoubleSafeInteger(operandNodeValue_)) {
            return this.doDoubleRepresentableAsSafeInteger(operandNodeValue_);
        }
        if ((state & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) {
            return this.doDoubleRepresentableAsLong(operandNodeValue_);
        }
        if ((state & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue_)) {
            return this.doDouble(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize((state & 0x70000) == 0 && (state & Short.MAX_VALUE) != 0 ? (Number)operandNodeValue_long : (Number)((state & 0x68000) == 0 && (state & Short.MAX_VALUE) != 0 ? (Number)operandNodeValue_int : (Number)operandNodeValue_));
    }

    private int executeInt_generic4(VirtualFrame frameValue, int state) {
        DynamicObject operandNodeValue__;
        long operandNodeValue__2;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__3 = (Integer)operandNodeValue_;
            return this.doInteger(operandNodeValue__3);
        }
        if ((state & 2) != 0 && operandNodeValue_ instanceof LargeInteger) {
            LargeInteger operandNodeValue__4 = (LargeInteger)operandNodeValue_;
            return this.doLargeInteger(operandNodeValue__4);
        }
        if ((state & 4) != 0 && operandNodeValue_ instanceof Boolean) {
            boolean operandNodeValue__5 = (Boolean)operandNodeValue_;
            return this.doBoolean(operandNodeValue__5);
        }
        if ((state & 8) != 0 && operandNodeValue_ instanceof Long && JSGuards.isLongRepresentableAsInt32(operandNodeValue__2 = ((Long)operandNodeValue_).longValue())) {
            return this.doLong(operandNodeValue__2);
        }
        if ((state & 0xF0) != 0 && JSTypesGen.isImplicitDouble((state & 0x78000) >>> 15, operandNodeValue_)) {
            double operandNodeValue__6 = JSTypesGen.asImplicitDouble((state & 0x78000) >>> 15, operandNodeValue_);
            if ((state & 0x10) != 0 && !JSGuards.isDoubleLargerThan2e32(operandNodeValue__6)) {
                return this.doDoubleFitsInt(operandNodeValue__6);
            }
            if ((state & 0x20) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue__6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue__6) && JSGuards.isDoubleSafeInteger(operandNodeValue__6)) {
                return this.doDoubleRepresentableAsSafeInteger(operandNodeValue__6);
            }
            if ((state & 0x40) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue__6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue__6)) {
                return this.doDoubleRepresentableAsLong(operandNodeValue__6);
            }
            if ((state & 0x80) != 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue__6) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue__6)) {
                return this.doDouble(operandNodeValue__6);
            }
        }
        if ((state & 0x300) != 0) {
            if ((state & 0x100) != 0 && JSGuards.isUndefined(operandNodeValue_)) {
                return this.doUndefined(operandNodeValue_);
            }
            if ((state & 0x200) != 0 && JSGuards.isJSNull(operandNodeValue_)) {
                return this.doNull(operandNodeValue_);
            }
        }
        if ((state & 0x400) != 0 && JSTypesGen.isImplicitString((state & 0x780000) >>> 19, operandNodeValue_)) {
            String operandNodeValue__7 = JSTypesGen.asImplicitString((state & 0x780000) >>> 19, operandNodeValue_);
            return this.doString(operandNodeValue__7, this.string_stringToNumberNode_);
        }
        if ((state & 0x800) != 0 && operandNodeValue_ instanceof Symbol) {
            Symbol operandNodeValue__8 = (Symbol)operandNodeValue_;
            return this.doSymbol(operandNodeValue__8);
        }
        if ((state & 0x1000) != 0 && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__9 = (BigInt)operandNodeValue_;
            return this.doBigInt(operandNodeValue__9);
        }
        if ((state & 0x2000) != 0 && JSTypes.isDynamicObject(operandNodeValue_) && JSGuards.isJSObject(operandNodeValue__ = (DynamicObject)operandNodeValue_)) {
            return this.doJSObject(operandNodeValue__, this.jSObject_toDoubleNode_);
        }
        if ((state & 0x4000) != 0 && operandNodeValue_ instanceof TruffleObject && JSGuards.isForeignObject(operandNodeValue__ = (TruffleObject)operandNodeValue_)) {
            return JSToInt32Node.doForeignObject(operandNodeValue__, this.foreignObject_toPrimitiveNode_, this.foreignObject_toInt32Node_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeInt(frameValue);
    }

    private int executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            DynamicObject operandNodeValue_;
            long operandNodeValue_2;
            if (operandNodeValue instanceof Integer) {
                int operandNodeValue_3 = (Integer)operandNodeValue;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                int n = this.doInteger(operandNodeValue_3);
                return n;
            }
            if (operandNodeValue instanceof LargeInteger) {
                LargeInteger operandNodeValue_4 = (LargeInteger)operandNodeValue;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                int n = this.doLargeInteger(operandNodeValue_4);
                return n;
            }
            if (operandNodeValue instanceof Boolean) {
                boolean operandNodeValue_5 = (Boolean)operandNodeValue;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                int n = this.doBoolean(operandNodeValue_5);
                return n;
            }
            if (operandNodeValue instanceof Long && JSGuards.isLongRepresentableAsInt32(operandNodeValue_2 = ((Long)operandNodeValue).longValue())) {
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                int n = this.doLong(operandNodeValue_2);
                return n;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue);
            if (doubleCast0 != 0) {
                double operandNodeValue_6 = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                if (!JSGuards.isDoubleLargerThan2e32(operandNodeValue_6)) {
                    state |= doubleCast0 << 15;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doDoubleFitsInt(operandNodeValue_6);
                    return n;
                }
                if (exclude == 0 && JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6) && JSGuards.isDoubleSafeInteger(operandNodeValue_6)) {
                    state |= doubleCast0 << 15;
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doDoubleRepresentableAsSafeInteger(operandNodeValue_6);
                    return n;
                }
                if (JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFDF;
                    state |= doubleCast0 << 15;
                    this.state_ = state |= 0x40;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doDoubleRepresentableAsLong(operandNodeValue_6);
                    return n;
                }
                if (JSGuards.isDoubleLargerThan2e32(operandNodeValue_6) && !JSGuards.isDoubleRepresentableAsLong(operandNodeValue_6)) {
                    state |= doubleCast0 << 15;
                    this.state_ = state |= 0x80;
                    lock.unlock();
                    hasLock = false;
                    int n = this.doDouble(operandNodeValue_6);
                    return n;
                }
            }
            if (JSGuards.isUndefined(operandNodeValue)) {
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                doubleCast0 = this.doUndefined(operandNodeValue);
                return doubleCast0;
            }
            if (JSGuards.isJSNull(operandNodeValue)) {
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                doubleCast0 = this.doNull(operandNodeValue);
                return doubleCast0;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(operandNodeValue);
            if (stringCast0 != 0) {
                String operandNodeValue_7 = JSTypesGen.asImplicitString(stringCast0, operandNodeValue);
                this.string_stringToNumberNode_ = (JSStringToNumberNode)super.insert((Node)JSStringToNumberNode.create());
                state |= stringCast0 << 19;
                this.state_ = state |= 0x400;
                lock.unlock();
                hasLock = false;
                int n = this.doString(operandNodeValue_7, this.string_stringToNumberNode_);
                return n;
            }
            if (operandNodeValue instanceof Symbol) {
                Symbol operandNodeValue_8 = (Symbol)operandNodeValue;
                this.state_ = state |= 0x800;
                lock.unlock();
                hasLock = false;
                int n = this.doSymbol(operandNodeValue_8);
                return n;
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_9 = (BigInt)operandNodeValue;
                this.state_ = state |= 0x1000;
                lock.unlock();
                hasLock = false;
                int n = this.doBigInt(operandNodeValue_9);
                return n;
            }
            if (JSTypes.isDynamicObject(operandNodeValue) && JSGuards.isJSObject(operandNodeValue_ = (DynamicObject)operandNodeValue)) {
                this.jSObject_toDoubleNode_ = (JSToDoubleNode)super.insert((Node)JSToDoubleNode.create());
                this.state_ = state |= 0x2000;
                lock.unlock();
                hasLock = false;
                int n = this.doJSObject(operandNodeValue_, this.jSObject_toDoubleNode_);
                return n;
            }
            if (operandNodeValue instanceof TruffleObject && JSGuards.isForeignObject(operandNodeValue_ = (TruffleObject)operandNodeValue)) {
                this.foreignObject_toPrimitiveNode_ = (JSToPrimitiveNode)super.insert((Node)JSToPrimitiveNode.createHintNumber());
                this.foreignObject_toInt32Node_ = (JSToInt32Node)super.insert((Node)JSToInt32Node.create());
                this.state_ = state |= 0x4000;
                lock.unlock();
                hasLock = false;
                int n = JSToInt32Node.doForeignObject(operandNodeValue_, this.foreignObject_toPrimitiveNode_, this.foreignObject_toInt32Node_);
                return n;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode}, new Object[]{operandNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & Short.MAX_VALUE) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & Short.MAX_VALUE & (state & Short.MAX_VALUE) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<JavaScriptBaseNode>> cached;
        Object[] data = new Object[16];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doLargeInteger";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doDoubleFitsInt";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doDoubleRepresentableAsSafeInteger";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[6] = s;
        s = new Object[3];
        s[0] = "doDoubleRepresentableAsLong";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doNull";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doString";
        if ((state & 0x400) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<JavaScriptBaseNode>>();
            cached.add(Arrays.asList(this.string_stringToNumberNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x1000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0x2000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.jSObject_toDoubleNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[14] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state & 0x4000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.foreignObject_toPrimitiveNode_, this.foreignObject_toInt32Node_}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[15] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSToInt32Node create(JavaScriptNode operand) {
        return new JSToInt32NodeGen(operand);
    }
}

