/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TestingProviderPanel
extends JPanel {
    private static final ActionListener NOOP_ACTION_LISTENER = new NoopActionListener();
    private final ProjectCustomizer.Category category;
    private final PhpProjectProperties uiProps;
    private final String providerIdentifier;
    private final JComponent providerComponent;
    private final ActionListener originalStoreListener;
    private final ActionListener originalOkButtonListener;
    private boolean originalCategoryValid;
    private String originalErrorMessage;
    private JLabel notActiveLabel;
    private JPanel providerPanel;

    TestingProviderPanel(ProjectCustomizer.Category category, PhpProjectProperties uiProps, String providerIdentifier, JComponent providerComponent) {
        assert (EventQueue.isDispatchThread());
        assert (category != null);
        assert (uiProps != null);
        assert (providerIdentifier != null);
        assert (providerComponent != null);
        this.category = category;
        this.uiProps = uiProps;
        this.providerIdentifier = providerIdentifier;
        this.providerComponent = providerComponent;
        this.originalStoreListener = category.getStoreListener();
        this.originalOkButtonListener = category.getOkButtonListener();
        this.rememberValues();
        this.initComponents();
        this.init();
    }

    private void init() {
        assert (EventQueue.isDispatchThread());
        if (this.uiProps.getTestingProviders().contains(this.providerIdentifier)) {
            this.showProviderPanel();
        } else {
            this.hideProviderPanel();
        }
    }

    public String getProviderIdentifier() {
        return this.providerIdentifier;
    }

    public void showProviderPanel() {
        assert (EventQueue.isDispatchThread());
        this.notActiveLabel.setVisible(false);
        this.providerPanel.add((Component)this.providerComponent, "Center");
        this.category.setStoreListener(this.originalStoreListener);
        this.category.setOkButtonListener(this.originalOkButtonListener);
        this.category.setErrorMessage(this.originalErrorMessage);
        this.category.setValid(this.originalCategoryValid);
    }

    public void hideProviderPanel() {
        assert (EventQueue.isDispatchThread());
        this.rememberValues();
        this.category.setStoreListener(NOOP_ACTION_LISTENER);
        this.category.setOkButtonListener(NOOP_ACTION_LISTENER);
        this.notActiveLabel.setVisible(true);
        this.providerPanel.remove(this.providerComponent);
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    private void rememberValues() {
        assert (EventQueue.isDispatchThread());
        this.originalCategoryValid = this.category.isValid();
        this.originalErrorMessage = this.category.getErrorMessage();
    }

    private void initComponents() {
        this.notActiveLabel = new JLabel();
        this.providerPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.notActiveLabel, (String)NbBundle.getMessage(TestingProviderPanel.class, (String)"TestingProviderPanel.notActiveLabel.text"));
        this.providerPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.providerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.notActiveLabel, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.notActiveLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.providerPanel, -1, -1, Short.MAX_VALUE)));
    }

    private static final class NoopActionListener
    implements ActionListener {
        private NoopActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

