/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.project.runconfigs.RunConfigScript;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigScriptValidator;
import org.netbeans.modules.php.project.ui.actions.support.RunFileActionProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

final class RunFilePanel
extends JPanel {
    private static final long serialVersionUID = 92648723648723L;
    private DialogDescriptor dialogDescriptor;
    private NotificationLineSupport notificationLineSupport;
    private JButton browseButton;
    private JCheckBox displayDialog;
    private JTextField phpOptionsField;
    private JLabel phpOptionsLabel;
    private JTextField runArgsField;
    private JLabel runArgsLabel;
    private JTextField workDirField;
    private JLabel workDirLabel;

    private RunFilePanel(RunFileActionProvider.RunFileArgs args) {
        this.initComponents();
        this.runArgsField.setText(args.getRunArgs());
        this.workDirField.setText(args.getWorkDir());
        this.phpOptionsField.setText(args.getPhpOpts());
        this.workDirField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processChange();
            }

            private void processChange() {
                RunFilePanel.this.validateWorkDir();
            }
        });
    }

    public static RunFileActionProvider.RunFileArgs open(RunFileActionProvider.RunFileArgs args, File file, boolean debug) {
        RunFilePanel panel = new RunFilePanel(args);
        panel.dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(RunFilePanel.class, (String)(debug ? "LBL_DebugFile" : "LBL_RunFile"), (Object)file.getName()), true, 2, DialogDescriptor.OK_OPTION, null);
        panel.notificationLineSupport = panel.dialogDescriptor.createNotificationLineSupport();
        panel.validateWorkDir();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)panel.dialogDescriptor) == DialogDescriptor.OK_OPTION) {
            return panel.getArgs();
        }
        return null;
    }

    private RunFileActionProvider.RunFileArgs getArgs() {
        RunConfigScript config = this.createRunConfig();
        return new RunFileActionProvider.RunFileArgs(config.getArguments(), config.getWorkDir(), config.getOptions(), !this.displayDialog.isSelected());
    }

    private RunConfigScript createRunConfig() {
        return ((RunConfigScript)RunConfigScript.create().setOptions(this.phpOptionsField.getText()).setArguments(this.runArgsField.getText())).setWorkDir(this.workDirField.getText());
    }

    void validateWorkDir() {
        assert (this.notificationLineSupport != null);
        String error = RunConfigScriptValidator.validateRunFileWithoutProject(this.createRunConfig());
        if (error != null) {
            this.notificationLineSupport.setErrorMessage(error);
            this.dialogDescriptor.setValid(false);
            return;
        }
        this.notificationLineSupport.clearMessages();
        this.dialogDescriptor.setValid(true);
    }

    private void initComponents() {
        this.runArgsLabel = new JLabel();
        this.runArgsField = new JTextField();
        this.workDirLabel = new JLabel();
        this.workDirField = new JTextField();
        this.browseButton = new JButton();
        this.phpOptionsLabel = new JLabel();
        this.phpOptionsField = new JTextField();
        this.displayDialog = new JCheckBox();
        this.runArgsLabel.setLabelFor(this.runArgsField);
        Mnemonics.setLocalizedText((JLabel)this.runArgsLabel, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.runArgsLabel.text"));
        this.workDirLabel.setLabelFor(this.workDirField);
        Mnemonics.setLocalizedText((JLabel)this.workDirLabel, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.workDirLabel.text"));
        this.workDirField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunFilePanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.phpOptionsLabel.setLabelFor(this.phpOptionsField);
        Mnemonics.setLocalizedText((JLabel)this.phpOptionsLabel, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.phpOptionsLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.displayDialog, (String)NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.displayDialog.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.phpOptionsLabel).addComponent(this.workDirLabel).addComponent(this.runArgsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.runArgsField, GroupLayout.Alignment.TRAILING, -1, 314, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.workDirField, -1, 206, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.phpOptionsField, -1, 314, Short.MAX_VALUE))).addComponent(this.displayDialog)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runArgsLabel).addComponent(this.runArgsField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.workDirLabel).addComponent(this.workDirField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpOptionsLabel).addComponent(this.phpOptionsField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.displayDialog)));
        this.displayDialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RunFilePanel.class, (String)"RunFilePanel.displayDialog.AccessibleContext.accessibleDescription"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File selectedFile = new FileChooserBuilder(RunFilePanel.class).setTitle(NbBundle.getMessage(RunFilePanel.class, (String)"LBL_SelectWorkingDirectory")).setDirectoriesOnly(true).forceUseOfDefaultWorkingDirectory(true).setDefaultWorkingDirectory(new File(this.createRunConfig().getWorkDir())).showOpenDialog();
        if (selectedFile != null) {
            File workDir = FileUtil.normalizeFile((File)selectedFile);
            this.workDirField.setText(workDir.getAbsolutePath());
        }
    }
}

