/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.automaton;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.tregex.automaton.TransitionSet;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public class TransitionBuilder<TS extends TransitionSet>
implements JsonConvertible {
    private final TS transitionSet;
    private CharSet matcherBuilder;
    private TransitionBuilder<TS> next;

    public TransitionBuilder(TS transitionSet, CharSet matcherBuilder) {
        this.transitionSet = transitionSet;
        this.matcherBuilder = matcherBuilder;
    }

    public TS getTransitionSet() {
        return this.transitionSet;
    }

    public CharSet getMatcherBuilder() {
        return this.matcherBuilder;
    }

    public void setMatcherBuilder(CharSet matcherBuilder) {
        this.matcherBuilder = matcherBuilder;
    }

    public TransitionBuilder<TS> getNext() {
        return this.next;
    }

    public void setNext(TransitionBuilder<TS> next) {
        this.next = next;
    }

    public TransitionBuilder<TS> createMerged(TransitionBuilder<TS> other, CharSet mergedMatcher) {
        return new TransitionBuilder<TransitionSet>(this.transitionSet.createMerged((TransitionSet)other.transitionSet), mergedMatcher);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("matcherBuilder", this.getMatcherBuilder()), Json.prop("transitionSet", this.getTransitionSet()));
    }
}

