/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.automaton;

import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.charset.ImmutableSortedListOfRanges;
import com.oracle.truffle.regex.tregex.automaton.TransitionBuilder;
import com.oracle.truffle.regex.tregex.automaton.TransitionSet;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.graalvm.collections.EconomicMap;

public abstract class StateTransitionCanonicalizer<TS extends TransitionSet, TB extends TransitionBuilder<TS>> {
    private final ArrayList<TB> disjointTransitions = new ArrayList();
    private final EconomicMap<TS, TB> mergeSameTargetsMap = EconomicMap.create();

    public TB[] run(List<TB> transitions, CompilationBuffer compilationBuffer) {
        this.calcDisjointTransitions(transitions, compilationBuffer);
        return this.mergeSameTargets(compilationBuffer);
    }

    private void calcDisjointTransitions(List<TB> transitions, CompilationBuffer compilationBuffer) {
        for (TransitionBuilder e : transitions) {
            for (int i = 0; i < this.disjointTransitions.size(); ++i) {
                TransitionBuilder r = (TransitionBuilder)this.disjointTransitions.get(i);
                ImmutableSortedListOfRanges.IntersectAndSubtractResult<CharSet> result = r.getMatcherBuilder().intersectAndSubtract(e.getMatcherBuilder(), compilationBuffer);
                CharSet rSubtractedMatcher = (CharSet)result.subtractedA;
                CharSet eSubtractedMatcher = (CharSet)result.subtractedB;
                CharSet intersection = (CharSet)result.intersection;
                if (!intersection.matchesSomething()) continue;
                if (rSubtractedMatcher.matchesNothing()) {
                    r.getTransitionSet().addAll((TransitionSet)e.getTransitionSet());
                } else {
                    r.setMatcherBuilder(rSubtractedMatcher);
                    this.disjointTransitions.add(r.createMerged(e, intersection));
                }
                e.setMatcherBuilder(eSubtractedMatcher);
                if (eSubtractedMatcher.matchesNothing()) break;
            }
            if (!e.getMatcherBuilder().matchesSomething()) continue;
            this.disjointTransitions.add(e);
        }
    }

    private TB[] mergeSameTargets(CompilationBuffer compilationBuffer) {
        int resultSize = 0;
        for (TransitionBuilder tb : this.disjointTransitions) {
            if (tb.getMatcherBuilder().matchesNothing()) continue;
            TransitionBuilder existingTransitions = (TransitionBuilder)this.mergeSameTargetsMap.get(tb.getTransitionSet());
            if (existingTransitions == null) {
                this.mergeSameTargetsMap.put(tb.getTransitionSet(), (Object)tb);
                ++resultSize;
                continue;
            }
            boolean merged = false;
            TransitionBuilder mergeCandidate = existingTransitions;
            do {
                if (!this.isSameTargetMergeAllowed(tb, mergeCandidate)) continue;
                mergeCandidate.setMatcherBuilder(mergeCandidate.getMatcherBuilder().union(tb.getMatcherBuilder(), compilationBuffer));
                merged = true;
                break;
            } while ((mergeCandidate = mergeCandidate.getNext()) != null);
            if (merged) continue;
            tb.setNext(existingTransitions);
            this.mergeSameTargetsMap.put(tb.getTransitionSet(), (Object)tb);
            ++resultSize;
        }
        TransitionBuilder[] resultArray = this.createResultArray(resultSize);
        int i = 0;
        Iterator iterator = this.mergeSameTargetsMap.getValues().iterator();
        while (iterator.hasNext()) {
            TransitionBuilder list;
            TransitionBuilder tb = list = (TransitionBuilder)iterator.next();
            do {
                resultArray[i++] = tb;
            } while ((tb = tb.getNext()) != null);
        }
        this.disjointTransitions.clear();
        this.mergeSameTargetsMap.clear();
        return resultArray;
    }

    protected abstract boolean isSameTargetMergeAllowed(TB var1, TB var2);

    protected abstract TB[] createResultArray(int var1);
}

