/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug.connection;

import java.io.IOException;
import java.nio.charset.Charset;
import org.netbeans.lib.v8debug.connection.Utils;

final class DebuggerConnection {
    public static final Charset CHAR_SET = Charset.forName("UTF-8");
    public static final byte[] EOL = new byte[]{13, 10};
    public static final String EOL_STR = "\r\n";
    public static final String CONTENT_LENGTH_STR = "Content-Length: ";
    public static final byte[] CONTENT_LENGTH_BYTES = "Content-Length: ".getBytes(CHAR_SET);
    public static final int BUFFER_SIZE = 4096;

    private DebuggerConnection() {
    }

    public static int readContentLength(byte[] bytes, int[] from, int to, int[] beginPos) throws IOException {
        int contentLength;
        int clPos = Utils.indexOf(CONTENT_LENGTH_BYTES, bytes, from[0], to);
        if (clPos < 0) {
            return -1;
        }
        beginPos[0] = clPos;
        int end = Utils.indexOf(EOL, bytes, clPos += CONTENT_LENGTH_BYTES.length, to);
        if (end < 0) {
            return -1;
        }
        String clStr = new String(bytes, clPos, end - clPos, CHAR_SET);
        try {
            contentLength = Integer.parseInt(clStr);
        }
        catch (NumberFormatException nfex) {
            throw new IOException("Data inconsistency: can not read content length from '" + clStr + "' in " + new String(bytes, CHAR_SET));
        }
        from[0] = end + EOL.length;
        return contentLength;
    }

    public static String readTools(byte[] bytes, int[] fromPtr, int n) {
        int end = Utils.indexOf(EOL, bytes, fromPtr[0], n);
        if (end < 0) {
            return null;
        }
        int from = fromPtr[0];
        fromPtr[0] = end + EOL.length;
        return new String(bytes, from, end - from, CHAR_SET);
    }
}

