/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class FlatScrollBarUI
extends BasicScrollBarUI {
    protected Color hoverTrackColor;
    protected Color hoverThumbColor;
    protected boolean showButtons;
    protected String arrowType;
    protected Color buttonArrowColor;
    protected Color buttonDisabledArrowColor;
    private MouseAdapter hoverListener;
    private boolean hoverTrack;
    private boolean hoverThumb;
    private static boolean isPressed;

    public static ComponentUI createUI(JComponent c) {
        return new FlatScrollBarUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.hoverListener = new ScrollBarHoverListener();
        this.scrollbar.addMouseListener(this.hoverListener);
        this.scrollbar.addMouseMotionListener(this.hoverListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.scrollbar.removeMouseListener(this.hoverListener);
        this.scrollbar.removeMouseMotionListener(this.hoverListener);
        this.hoverListener = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.hoverTrackColor = UIManager.getColor("ScrollBar.hoverTrackColor");
        this.hoverThumbColor = UIManager.getColor("ScrollBar.hoverThumbColor");
        this.showButtons = UIManager.getBoolean("ScrollBar.showButtons");
        this.arrowType = UIManager.getString("Component.arrowType");
        this.buttonArrowColor = UIManager.getColor("ScrollBar.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("ScrollBar.buttonDisabledArrowColor");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.hoverTrackColor = null;
        this.hoverThumbColor = null;
        this.buttonArrowColor = null;
        this.buttonDisabledArrowColor = null;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new BasicScrollBarUI.PropertyChangeHandler(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                super.propertyChange(e);
                if ("JScrollBar.showButtons".equals(e.getPropertyName())) {
                    FlatScrollBarUI.this.scrollbar.revalidate();
                    FlatScrollBarUI.this.scrollbar.repaint();
                }
            }
        };
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return UIScale.scale(super.getPreferredSize(c));
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return this.createArrowButton(orientation);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return this.createArrowButton(orientation);
    }

    private JButton createArrowButton(int orientation) {
        FlatArrowButton button = new FlatArrowButton(orientation, this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, null, this.hoverTrackColor){

            @Override
            public Dimension getPreferredSize() {
                if (FlatScrollBarUI.this.isShowButtons()) {
                    int w = UIScale.scale(FlatScrollBarUI.this.scrollBarWidth);
                    return new Dimension(w, w);
                }
                return new Dimension();
            }

            @Override
            public Dimension getMinimumSize() {
                return FlatScrollBarUI.this.isShowButtons() ? super.getMinimumSize() : new Dimension();
            }

            @Override
            public Dimension getMaximumSize() {
                return FlatScrollBarUI.this.isShowButtons() ? super.getMaximumSize() : new Dimension();
            }
        };
        button.setArrowWidth(6);
        button.setFocusable(false);
        button.setRequestFocusEnabled(false);
        return button;
    }

    private boolean isShowButtons() {
        Object showButtons = this.scrollbar.getClientProperty("JScrollBar.showButtons");
        if (showButtons == null && this.scrollbar.getParent() instanceof JScrollPane) {
            showButtons = ((JScrollPane)this.scrollbar.getParent()).getClientProperty("JScrollBar.showButtons");
        }
        return showButtons != null ? Objects.equals(showButtons, true) : this.showButtons;
    }

    @Override
    protected void paintDecreaseHighlight(Graphics g) {
    }

    @Override
    protected void paintIncreaseHighlight(Graphics g) {
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(this.hoverTrack ? this.hoverTrackColor : this.trackColor);
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        g.setColor(this.hoverThumb ? this.hoverThumbColor : this.thumbColor);
        g.fillRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return UIScale.scale(super.getMinimumThumbSize());
    }

    @Override
    protected Dimension getMaximumThumbSize() {
        return UIScale.scale(super.getMaximumThumbSize());
    }

    private class ScrollBarHoverListener
    extends MouseAdapter {
        private ScrollBarHoverListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!isPressed) {
                FlatScrollBarUI.this.hoverTrack = (FlatScrollBarUI.this.hoverThumb = false);
                this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!isPressed) {
                this.update(e.getX(), e.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            isPressed = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            isPressed = false;
            this.update(e.getX(), e.getY());
        }

        private void update(int x, int y) {
            boolean inTrack = FlatScrollBarUI.this.getTrackBounds().contains(x, y);
            boolean inThumb = FlatScrollBarUI.this.getThumbBounds().contains(x, y);
            if (inTrack != FlatScrollBarUI.this.hoverTrack || inThumb != FlatScrollBarUI.this.hoverThumb) {
                FlatScrollBarUI.this.hoverTrack = inTrack;
                FlatScrollBarUI.this.hoverThumb = inThumb;
                this.repaint();
            }
        }

        private void repaint() {
            if (FlatScrollBarUI.this.scrollbar.isEnabled()) {
                FlatScrollBarUI.this.scrollbar.repaint();
            }
        }
    }
}

