/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotThread;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

final class PolyglotThreadInfo {
    static final PolyglotThreadInfo NULL = new PolyglotThreadInfo(null);
    private final Reference<Thread> thread;
    private int enteredCount;
    final LinkedList<Object> explicitContextStack = new LinkedList();
    volatile boolean cancelled;
    private volatile long lastEntered;
    private volatile long timeExecuted;
    private static volatile ThreadMXBean threadBean;

    PolyglotThreadInfo(Thread thread) {
        this.thread = new WeakReference<Thread>(thread);
    }

    Thread getThread() {
        return this.thread.get();
    }

    boolean isCurrent() {
        return this.getThread() == Thread.currentThread();
    }

    void enter(PolyglotEngineImpl engine) {
        assert (Thread.currentThread() == this.getThread());
        int count = ++this.enteredCount;
        if (!engine.noThreadTimingNeeded.isValid() && count == 1) {
            this.lastEntered = this.getTime();
        }
    }

    void resetTiming() {
        if (this.enteredCount > 0) {
            this.lastEntered = this.getTime();
        }
        this.timeExecuted = 0L;
    }

    long getTimeExecuted() {
        long totalTime = this.timeExecuted;
        long last = this.lastEntered;
        if (last > 0L) {
            totalTime += this.getTime() - last;
        }
        return totalTime;
    }

    @CompilerDirectives.TruffleBoundary
    private long getTime() {
        long time;
        Thread t = this.getThread();
        if (t == null) {
            return this.timeExecuted;
        }
        ThreadMXBean bean = threadBean;
        if (bean == null) {
            threadBean = bean = ManagementFactory.getThreadMXBean();
        }
        if ((time = bean.getThreadCpuTime(t.getId())) == -1L) {
            return TimeUnit.MILLISECONDS.convert(System.currentTimeMillis(), TimeUnit.NANOSECONDS);
        }
        return time;
    }

    boolean isPolyglotThread(PolyglotContextImpl c) {
        if (this.getThread() instanceof PolyglotThread) {
            return ((PolyglotThread)this.getThread()).isOwner(c);
        }
        return false;
    }

    void leave(PolyglotEngineImpl engine) {
        assert (Thread.currentThread() == this.getThread());
        int count = --this.enteredCount;
        if (!engine.noThreadTimingNeeded.isValid() && count == 0) {
            long last = this.lastEntered;
            this.lastEntered = 0L;
            this.timeExecuted += this.getTime() - last;
        }
    }

    boolean isLastActive() {
        assert (Thread.currentThread() == this.getThread());
        return this.getThread() != null && this.enteredCount == 1 && !this.cancelled;
    }

    boolean isActive() {
        return this.getThread() != null && this.enteredCount > 0 && !this.cancelled;
    }

    public String toString() {
        return super.toString() + "[thread=" + this.getThread() + ", enteredCount=" + this.enteredCount + ", cancelled=" + this.cancelled + "]";
    }
}

