/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLimits;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableEconomicSet;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.ProcessHandler;

final class PolyglotContextConfig {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    final OutputStream out;
    final OutputStream err;
    final InputStream in;
    final boolean hostLookupAllowed;
    final boolean nativeAccessAllowed;
    final boolean createThreadAllowed;
    final boolean hostClassLoadingAllowed;
    final boolean createProcessAllowed;
    final Predicate<String> classFilter;
    private final Map<String, String[]> applicationArguments;
    final EconomicSet<String> allowedPublicLanguages;
    private final Map<String, OptionValuesImpl> optionsByLanguage;
    @CompilerDirectives.CompilationFinal
    FileSystem fileSystem;
    @CompilerDirectives.CompilationFinal
    FileSystem internalFileSystem;
    final Map<String, Level> logLevels;
    final Handler logHandler;
    final PolyglotAccess polyglotAccess;
    final ProcessHandler processHandler;
    final EnvironmentAccess environmentAccess;
    private final Map<String, String> environment;
    private volatile Map<String, String> configuredEnvironement;
    private volatile ZoneId timeZone;
    final PolyglotLimits limits;

    PolyglotContextConfig(PolyglotEngineImpl engine, OutputStream out, OutputStream err, InputStream in, boolean hostLookupAllowed, PolyglotAccess polyglotAccess, boolean nativeAccessAllowed, boolean createThreadAllowed, boolean hostClassLoadingAllowed, boolean allowExperimentalOptions, Predicate<String> classFilter, Map<String, String[]> applicationArguments, EconomicSet<String> allowedPublicLanguages, Map<String, String> options, FileSystem fileSystem, FileSystem internalFileSystem, Handler logHandler, boolean createProcessAllowed, ProcessHandler processHandler, EnvironmentAccess environmentAccess, Map<String, String> environment, ZoneId timeZone, PolyglotLimits limits) {
        assert (out != null);
        assert (err != null);
        assert (in != null);
        assert (environmentAccess != null);
        this.out = out;
        this.err = err;
        this.in = in;
        this.hostLookupAllowed = hostLookupAllowed;
        this.polyglotAccess = polyglotAccess;
        this.nativeAccessAllowed = nativeAccessAllowed;
        this.createThreadAllowed = createThreadAllowed;
        this.hostClassLoadingAllowed = hostClassLoadingAllowed;
        this.createProcessAllowed = createProcessAllowed;
        this.classFilter = classFilter;
        this.applicationArguments = applicationArguments;
        this.allowedPublicLanguages = allowedPublicLanguages;
        this.fileSystem = fileSystem;
        this.internalFileSystem = internalFileSystem;
        this.optionsByLanguage = new HashMap<String, OptionValuesImpl>();
        this.logHandler = logHandler;
        this.timeZone = timeZone;
        this.limits = limits;
        this.logLevels = new HashMap<String, Level>(engine.logLevels);
        for (String optionKey : options.keySet()) {
            String group = PolyglotEngineImpl.parseOptionGroup(optionKey);
            if (group.equals("log")) {
                this.logLevels.put(PolyglotEngineImpl.parseLoggerName(optionKey), Level.parse(options.get(optionKey)));
                continue;
            }
            PolyglotLanguage language = PolyglotContextConfig.findLanguageForOption(engine, optionKey, group);
            OptionValuesImpl languageOptions = this.optionsByLanguage.get(language.getId());
            if (languageOptions == null) {
                languageOptions = language.getOptionValues().copy();
                this.optionsByLanguage.put(language.getId(), languageOptions);
            }
            languageOptions.put(optionKey, options.get(optionKey), allowExperimentalOptions);
        }
        this.processHandler = processHandler;
        this.environmentAccess = environmentAccess;
        this.environment = environment == null ? Collections.emptyMap() : environment;
    }

    public ZoneId getTimeZone() {
        ZoneId zone = this.timeZone;
        if (zone == null) {
            zone = this.timeZone = ZoneId.systemDefault();
        }
        return zone;
    }

    boolean isAccessPermitted(PolyglotLanguage from, PolyglotLanguage to) {
        if (to.isHost() || to.cache.isInternal()) {
            return true;
        }
        if (from == null) {
            if (this.allowedPublicLanguages.contains((Object)to.info.getId())) {
                return true;
            }
        } else {
            if (this.polyglotAccess == PolyglotAccess.ALL) {
                if (this.allowedPublicLanguages.contains((Object)to.info.getId())) {
                    return true;
                }
            } else {
                if (from == to) {
                    return true;
                }
                UnmodifiableEconomicSet configuredAccess = from.engine.getAPIAccess().getEvalAccess(this.polyglotAccess, from.getId());
                if (configuredAccess != null && configuredAccess.contains((Object)to.getId())) {
                    return true;
                }
            }
            if (from.dependsOn(to)) {
                return true;
            }
        }
        return false;
    }

    String[] getApplicationArguments(PolyglotLanguage lang) {
        String[] args = this.applicationArguments.get(lang.getId());
        if (args == null) {
            args = EMPTY_STRING_ARRAY;
        }
        return args;
    }

    OptionValuesImpl getOptionValues(PolyglotLanguage lang) {
        OptionValuesImpl values = this.optionsByLanguage.get(lang.getId());
        if (values == null) {
            values = lang.getOptionValues();
        }
        return values.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getEnvironment() {
        Map<String, String> result = this.configuredEnvironement;
        if (result == null) {
            PolyglotContextConfig polyglotContextConfig = this;
            synchronized (polyglotContextConfig) {
                result = this.configuredEnvironement;
                if (result == null) {
                    if (this.environmentAccess == EnvironmentAccess.NONE) {
                        result = Collections.unmodifiableMap(this.environment);
                    } else if (PolyglotEngineImpl.ALLOW_ENVIRONMENT_ACCESS && this.environmentAccess == EnvironmentAccess.INHERIT) {
                        result = System.getenv();
                        if (!this.environment.isEmpty()) {
                            result = new HashMap<String, String>(result);
                            result.putAll(this.environment);
                            result = Collections.unmodifiableMap(result);
                        }
                    } else {
                        throw new IllegalStateException(String.format("Unsupported EnvironmentAccess: %s", this.environmentAccess));
                    }
                    this.configuredEnvironement = result;
                }
            }
        }
        return result;
    }

    private static PolyglotLanguage findLanguageForOption(PolyglotEngineImpl engine, String optionKey, String group) {
        PolyglotLanguage language = engine.idToLanguage.get(group);
        if (language == null) {
            if (engine.isEngineGroup(group) && engine.getAllOptions().get(optionKey) != null) {
                throw new IllegalArgumentException("Option " + optionKey + " is an engine option. Engine level options can only be configured for contexts without a shared engine set. To resolve this, configure the option when creating the Engine or create a context without a shared engine.");
            }
            throw OptionValuesImpl.failNotFound(engine.getAllOptions(), optionKey);
        }
        assert (!engine.isEngineGroup(group));
        return language;
    }
}

