/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.SuggestionRule;
import org.netbeans.modules.php.editor.verification.VerificationUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class ConvertVisibilitySuggestion
extends SuggestionRule {
    private static final String HINT_ID = "Convert.Visibility.Suggestion";
    private static final Logger LOGGER = Logger.getLogger(ConvertVisibilitySuggestion.class.getName());

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.ConvertVisibilitySuggestion_Description();
    }

    public String getDisplayName() {
        return Bundle.ConvertVisibilitySuggestion_DisplayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        BaseDocument doc = context.doc;
        int caretOffset = this.getCaretOffset();
        OffsetRange lineBounds = VerificationUtils.createLineBounds(caretOffset, doc);
        if (lineBounds.containsInclusive(caretOffset) && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, this, context.doc, lineBounds);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            result.addAll(checkVisitor.getHints());
        }
    }

    private static final class Fix
    implements HintFix {
        private final OffsetRange visibilityRange;
        private final String newVisibility;
        private final BaseDocument document;

        private Fix(OffsetRange visibilityRange, String newVisibility, BaseDocument document) {
            this.visibilityRange = visibilityRange;
            this.newVisibility = newVisibility;
            this.document = document;
        }

        public String getDescription() {
            return Bundle.ConvertVisibilitySuggestion_Fix_Description(this.newVisibility.trim());
        }

        public void implement() throws Exception {
            EditList edits = new EditList(this.document);
            edits.replace(this.visibilityRange.getStart(), this.visibilityRange.getLength(), this.newVisibility, true, 0);
            edits.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static final class FixInfo {
        private final BodyDeclaration bodyDeclaration;
        private final boolean isInInterface;
        private final boolean isAbstract;

        public FixInfo(BodyDeclaration bodyDeclaration, boolean isInInterface) {
            this.bodyDeclaration = bodyDeclaration;
            this.isInInterface = isInInterface;
            this.isAbstract = BodyDeclaration.Modifier.isAbstract(bodyDeclaration.getModifier());
        }

        public Pair<String, OffsetRange> getVisibilityRange(Document document) {
            String visibility = "implicit";
            int startOffset = this.bodyDeclaration.getStartOffset();
            int endOffset = this.bodyDeclaration.getEndOffset();
            try {
                String text = document.getText(startOffset, endOffset - startOffset);
                int indexOfVisibility = -1;
                if (BodyDeclaration.Modifier.isPublic(this.bodyDeclaration.getModifier())) {
                    indexOfVisibility = text.indexOf("public ");
                    visibility = "public";
                    if (indexOfVisibility == -1) {
                        indexOfVisibility = text.indexOf("var ");
                        visibility = "var";
                    }
                    if (indexOfVisibility == -1) {
                        visibility = "implicit";
                    }
                } else if (BodyDeclaration.Modifier.isPrivate(this.bodyDeclaration.getModifier())) {
                    indexOfVisibility = text.indexOf("private ");
                    visibility = "private";
                } else if (BodyDeclaration.Modifier.isProtected(this.bodyDeclaration.getModifier())) {
                    indexOfVisibility = text.indexOf("protected ");
                    visibility = "protected";
                }
                int visibilityStart = startOffset;
                int visibilityEnd = startOffset;
                if (indexOfVisibility != -1) {
                    visibilityEnd = (visibilityStart += indexOfVisibility) + visibility.length();
                } else if (indexOfVisibility == -1 && this.isAbstract) {
                    visibilityEnd = visibilityStart += "abstract ".length();
                }
                return Pair.of((Object)visibility, (Object)new OffsetRange(visibilityStart, visibilityEnd));
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.WARNING, "Incorrect offset: {0}", ex.offsetRequested());
                return Pair.of((Object)visibility, (Object)OffsetRange.NONE);
            }
        }

        public List<HintFix> createFixes(BaseDocument document) {
            ArrayList<HintFix> fixes = new ArrayList<HintFix>();
            Pair<String, OffsetRange> visibilityRange = this.getVisibilityRange((Document)document);
            String visibility = (String)visibilityRange.first();
            OffsetRange range = (OffsetRange)visibilityRange.second();
            switch (visibility) {
                case "implicit": {
                    fixes.add(new Fix(range, "public ", document));
                    if (this.isInInterface) break;
                    if (!this.isAbstract) {
                        fixes.add(new Fix(range, "private ", document));
                    }
                    fixes.add(new Fix(range, "protected ", document));
                    break;
                }
                case "var": {
                    fixes.add(new Fix(range, "public", document));
                    fixes.add(new Fix(range, "private", document));
                    fixes.add(new Fix(range, "protected", document));
                    break;
                }
                case "public": {
                    if (this.isInInterface) break;
                    if (!this.isAbstract) {
                        fixes.add(new Fix(range, "private", document));
                    }
                    fixes.add(new Fix(range, "protected", document));
                    break;
                }
                case "private": {
                    fixes.add(new Fix(range, "public", document));
                    fixes.add(new Fix(range, "protected", document));
                    break;
                }
                case "protected": {
                    fixes.add(new Fix(range, "public", document));
                    if (this.isAbstract) break;
                    fixes.add(new Fix(range, "private", document));
                    break;
                }
            }
            return fixes;
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final ConvertVisibilitySuggestion suggestion;
        private final BaseDocument document;
        private final OffsetRange lineRange;
        private final List<FixInfo> fixInfos = new ArrayList<FixInfo>();
        private boolean isInInterface;

        public CheckVisitor(FileObject fileObject, ConvertVisibilitySuggestion suggestion, BaseDocument document, OffsetRange lineRange) {
            this.fileObject = fileObject;
            this.suggestion = suggestion;
            this.document = document;
            this.lineRange = lineRange;
        }

        public List<Hint> getHints() {
            ArrayList<Hint> hints = new ArrayList<Hint>();
            for (FixInfo fixInfo : this.fixInfos) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return Collections.emptyList();
                }
                List<HintFix> createFixes = this.createFixes(fixInfo);
                if (createFixes.isEmpty()) continue;
                hints.add(new Hint((Rule)this.suggestion, Bundle.ConvertVisibilitySuggestion_Hint_Description(), this.fileObject, this.lineRange, createFixes, 500));
            }
            return hints;
        }

        private List<HintFix> createFixes(FixInfo fixInfo) {
            ArrayList<HintFix> hintFixes = new ArrayList<HintFix>();
            hintFixes.addAll(fixInfo.createFixes(this.document));
            return hintFixes;
        }

        @Override
        public void scan(ASTNode node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node != null && VerificationUtils.isBefore(node.getStartOffset(), this.lineRange.getEnd())) {
                super.scan(node);
            }
        }

        @Override
        public void visit(InterfaceDeclaration node) {
            this.isInInterface = true;
            super.visit(node);
            this.isInInterface = false;
        }

        @Override
        public void visit(FieldsDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            OffsetRange nodeRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (this.lineRange.overlaps(nodeRange)) {
                this.processBodyDeclaration(node);
            }
        }

        @Override
        public void visit(ConstantDeclaration node) {
            if (CancelSupport.getDefault().isCancelled() || node.isGlobal()) {
                return;
            }
            OffsetRange nodeRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (this.lineRange.overlaps(nodeRange)) {
                this.processBodyDeclaration(node);
            }
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            OffsetRange nodeRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (this.lineRange.overlaps(nodeRange)) {
                this.processBodyDeclaration(node);
            }
        }

        private void processBodyDeclaration(BodyDeclaration node) {
            this.fixInfos.add(new FixInfo(node, this.isInInterface));
            super.visit(node);
        }
    }
}

