/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.editor;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.model.api.RestMethodDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.openide.filesystems.FileObject;

abstract class AsyncConverter {
    AsyncConverter() {
    }

    boolean isApplicable(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        return Profile.JAVA_EE_7_WEB.equals(profile) || Profile.JAVA_EE_7_FULL.equals(profile) || Profile.JAVA_EE_8_WEB.equals(profile) || Profile.JAVA_EE_8_FULL.equals(profile);
    }

    boolean isApplicable(Element element) {
        if (element == null || element.getKind() != ElementKind.METHOD) {
            return false;
        }
        Element enclosingElement = element.getEnclosingElement();
        return enclosingElement != null && enclosingElement instanceof TypeElement;
    }

    protected abstract Logger getLogger();

    protected boolean isAsync(Element method) {
        if (method instanceof ExecutableElement) {
            ExecutableElement exec = (ExecutableElement)method;
            List<? extends VariableElement> parameters = exec.getParameters();
            for (VariableElement variableElement : parameters) {
                Element paramElement;
                boolean hasAsyncType = false;
                TypeMirror type = variableElement.asType();
                if (type instanceof DeclaredType && (paramElement = ((DeclaredType)type).asElement()) instanceof TypeElement) {
                    hasAsyncType = ((TypeElement)paramElement).getQualifiedName().contentEquals("javax.ws.rs.container.AsyncResponse");
                }
                if (!hasAsyncType || !this.hasAnnotation(variableElement, "javax.ws.rs.container.Suspended")) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkRestMethod(final String fqn, Element method, FileObject source) {
        final String methodName = method.getSimpleName().toString();
        Project project = FileOwnerQuery.getOwner((FileObject)source);
        RestServicesModel model = RestUtils.getRestServicesMetadataModel(project);
        if (model == null) {
            return false;
        }
        try {
            return (Boolean)model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Boolean>(){

                public Boolean run(RestServicesMetadata metadata) throws Exception {
                    RestServiceDescription[] descriptions;
                    RestServices services = metadata.getRoot();
                    for (RestServiceDescription description : descriptions = services.getRestServiceDescription()) {
                        if (!fqn.equals(description.getClassName())) continue;
                        List methods = description.getMethods();
                        for (RestMethodDescription method : methods) {
                            if (!methodName.equals(method.getName())) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        catch (MetadataModelException e) {
            this.getLogger().log(Level.INFO, null, e);
        }
        catch (IOException e) {
            this.getLogger().log(Level.INFO, null, e);
        }
        return false;
    }

    protected boolean hasAnnotation(Element element, String ... annotationFqns) {
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (!(annotationElement instanceof TypeElement)) continue;
            String fqn = ((TypeElement)annotationElement).getQualifiedName().toString();
            for (String annotationFqn : annotationFqns) {
                if (!fqn.equals(annotationFqn)) continue;
                return true;
            }
        }
        return false;
    }

    protected void convertMethod(final ElementHandle<Element> handle, FileObject fileObject) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return;
        }
        ModificationResult task = javaSource.runModificationTask((Task)new Task<WorkingCopy>(){
            private String serviceField;

            public void run(WorkingCopy copy) throws Exception {
                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element restMethod = handle.resolve((CompilationInfo)copy);
                if (restMethod == null) {
                    return;
                }
                Element enclosingElement = restMethod.getEnclosingElement();
                if (!(enclosingElement instanceof TypeElement)) {
                    return;
                }
                ClassTree classTree = (ClassTree)copy.getTrees().getTree(enclosingElement);
                MethodTree method = (MethodTree)copy.getTrees().getTree(restMethod);
                String name = restMethod.getSimpleName().toString();
                String asyncName = AsyncConverter.this.findFreeName(name, enclosingElement, restMethod);
                String movedName = AsyncConverter.this.findFreeName(AsyncConverter.this.convertMethodName(name), enclosingElement, restMethod);
                TreeMaker maker = copy.getTreeMaker();
                boolean isEjb = AsyncConverter.this.isEjb(enclosingElement);
                ClassTree newTree = classTree;
                if (!isEjb) {
                    newTree = this.addExecutionService(maker, copy, enclosingElement, classTree);
                }
                newTree = AsyncConverter.this.createAsyncMethod(maker, asyncName, this.serviceField, method, movedName, copy, newTree, isEjb);
                newTree = AsyncConverter.this.moveRestMethod(maker, movedName, method, copy, newTree);
                copy.rewrite((Tree)classTree, (Tree)newTree);
            }

            private ClassTree addExecutionService(TreeMaker maker, WorkingCopy copy, Element clazz, ClassTree classTree) {
                List<VariableElement> fields = ElementFilter.fieldsIn(clazz.getEnclosedElements());
                HashSet<String> fieldNames = new HashSet<String>();
                for (VariableElement field : fields) {
                    fieldNames.add(field.getSimpleName().toString());
                    TypeMirror fieldType = field.asType();
                    Element fieldTypeElement = copy.getTypes().asElement(fieldType);
                    if (!(fieldTypeElement instanceof TypeElement)) continue;
                    TypeElement type = (TypeElement)fieldTypeElement;
                    if (!ExecutorService.class.getName().contentEquals(type.getQualifiedName())) continue;
                    this.serviceField = field.getSimpleName().toString();
                }
                if (this.serviceField == null) {
                    String name;
                    this.serviceField = name = "executorService";
                    int i = 0;
                    while (fieldNames.contains(this.serviceField)) {
                        this.serviceField = name + i;
                        ++i;
                    }
                } else {
                    return classTree;
                }
                MethodInvocationTree init = maker.MethodInvocation(Collections.emptyList(), maker.QualIdent(Executors.class.getName() + ".newCachedThreadPool"), Collections.emptyList());
                VariableTree service = maker.Variable(maker.Modifiers(EnumSet.of(Modifier.PRIVATE)), (CharSequence)this.serviceField, (Tree)maker.QualIdent(ExecutorService.class.getName()), (ExpressionTree)init);
                return maker.addClassMember(classTree, (Tree)service);
            }
        });
        task.commit();
    }

    private String findFreeName(String name, Element enclosingElement, Element havingName) {
        for (ExecutableElement method : ElementFilter.methodsIn(enclosingElement.getEnclosedElements())) {
            if (method.equals(havingName) || !method.getSimpleName().contentEquals(name)) continue;
            return this.findFreeName(name + 1, enclosingElement, havingName);
        }
        return name;
    }

    private String convertMethodName(String name) {
        if (name.length() <= 1) {
            return "do" + name;
        }
        return "do" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private boolean isEjb(Element element) {
        return this.hasAnnotation(element, "javax.ejb.Stateless", "javax.ejb.Singleton");
    }

    private ClassTree createAsyncMethod(TreeMaker maker, String asyncName, String service, MethodTree method, String movedName, WorkingCopy copy, ClassTree classTree, boolean isEjb) {
        ModifiersTree modifiers = method.getModifiers();
        if (isEjb) {
            AnnotationTree async = maker.Annotation((Tree)maker.QualIdent("javax.ejb.Asynchronous"), Collections.emptyList());
            modifiers = maker.addModifiersAnnotation(modifiers, async);
        }
        List<? extends VariableTree> parameters = method.getParameters();
        String asyncReponseParam = this.getAsynParam("asyncResponse", parameters);
        ModifiersTree paramModifier = maker.Modifiers(EnumSet.of(Modifier.FINAL));
        AnnotationTree annotation = maker.Annotation((Tree)maker.QualIdent("javax.ws.rs.container.Suspended"), Collections.emptyList());
        paramModifier = maker.Modifiers(paramModifier, Collections.singletonList(annotation));
        VariableTree asyncParam = maker.Variable(paramModifier, (CharSequence)asyncReponseParam, (Tree)maker.QualIdent("javax.ws.rs.container.AsyncResponse"), null);
        ArrayList<VariableTree> params = new ArrayList<VariableTree>(parameters.size() + 1);
        params.add(asyncParam);
        Tree returnType = method.getReturnType();
        boolean noReturn = returnType.toString().equals("void");
        StringBuilder body = new StringBuilder("{");
        if (!isEjb) {
            body.append(service);
            body.append(".submit(new Runnable() { public void run() {");
        }
        if (!noReturn) {
            body.append(asyncReponseParam);
            body.append(".resume(");
        }
        body.append(movedName);
        body.append('(');
        for (VariableTree variableTree : parameters) {
            ModifiersTree modifier = maker.addModifiersModifier(variableTree.getModifiers(), Modifier.FINAL);
            VariableTree newParam = maker.Variable(modifier, (CharSequence)variableTree.getName(), variableTree.getType(), variableTree.getInitializer());
            params.add(newParam);
            TreePath pathParam = copy.getTrees().getPath(copy.getCompilationUnit(), variableTree);
            body.append(copy.getTrees().getElement(pathParam).getSimpleName());
            body.append(',');
        }
        if (!parameters.isEmpty()) {
            body.deleteCharAt(body.length() - 1);
        }
        if (noReturn) {
            body.append(");");
            body.append(asyncReponseParam);
            body.append(".resume(javax.ws.rs.core.Response.ok().build());");
        } else {
            body.append("));");
        }
        if (!isEjb) {
            body.append("}});");
        }
        body.append('}');
        MethodTree newMethod = maker.Method(modifiers, (CharSequence)asyncName, maker.Type("void"), Collections.emptyList(), params, Collections.emptyList(), body.toString(), null);
        return maker.addClassMember(classTree, (Tree)newMethod);
    }

    private String getAsynParam(String paramName, List<? extends VariableTree> parameters) {
        for (VariableTree variableTree : parameters) {
            if (!paramName.equals(variableTree.getName())) continue;
            return this.getAsynParam(paramName + 1, parameters);
        }
        return paramName;
    }

    private ClassTree moveRestMethod(TreeMaker maker, String movedName, MethodTree method, WorkingCopy copy, ClassTree classTree) {
        List<? extends VariableTree> parameters = method.getParameters();
        Tree returnType = method.getReturnType();
        BlockTree body = method.getBody();
        ModifiersTree modifiers = maker.Modifiers(EnumSet.of(Modifier.PRIVATE));
        MethodTree newMethod = maker.Method(modifiers, (CharSequence)movedName, returnType, Collections.emptyList(), parameters, Collections.emptyList(), body, null);
        ClassTree newClass = maker.addClassMember(classTree, (Tree)newMethod);
        newClass = maker.removeClassMember(newClass, (Tree)method);
        return newClass;
    }
}

