/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.openide.modules.ModuleInstall;

public final class ProfilerModule
extends ModuleInstall {
    public static final String LIBS_DIR = "lib";

    public boolean closing() {
        if (!NetBeansProfiler.isInitialized()) {
            return true;
        }
        int state = Profiler.getDefault().getProfilingState();
        int mode = Profiler.getDefault().getProfilingMode();
        if (state == 8 || state == 4) {
            if (mode == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerModule_ExitingFromProfileMessage(), (String)Bundle.ProfilerModule_QuestionDialogCaption())) {
                    return false;
                }
                Profiler.getDefault().stopApp();
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerModule_ExitingFromAttachMessage(), (String)Bundle.ProfilerModule_QuestionDialogCaption())) {
                    return false;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        return true;
    }

    public void restored() {
        super.restored();
        MiscUtils.setVerbosePrint();
        MiscUtils.deleteHeapTempFiles();
    }

    public void uninstalled() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int state = Profiler.getDefault().getProfilingState();
                    int mode = Profiler.getDefault().getProfilingMode();
                    if (state == 8 || state == 4) {
                        if (mode == 1) {
                            Profiler.getDefault().stopApp();
                        } else {
                            Profiler.getDefault().detachFromApp();
                        }
                    }
                    ((NetBeansProfiler)Profiler.getDefault()).shutdown();
                    ResetResultsAction.getInstance().actionPerformed(null);
                }
            });
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
        }
        super.uninstalled();
    }
}

