/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.HudsonLogger;
import org.openide.util.Lookup;
import org.openide.windows.OutputWriter;

public final class Hyperlinker {
    private static final Logger LOG = Logger.getLogger(Hyperlinker.class.getName());
    private final HudsonLogger.HudsonLogSession[] sessions;

    public Hyperlinker(HudsonJob job) {
        ArrayList<HudsonLogger.HudsonLogSession> _sessions = new ArrayList<HudsonLogger.HudsonLogSession>();
        for (HudsonLogger logger : Lookup.getDefault().lookupAll(HudsonLogger.class)) {
            _sessions.add(logger.createSession(job));
        }
        this.sessions = _sessions.toArray(new HudsonLogger.HudsonLogSession[_sessions.size()]);
    }

    public void handleLine(String line, OutputWriter stream) {
        for (HudsonLogger.HudsonLogSession session : this.sessions) {
            if (session.handle(line, stream)) break;
        }
    }

    public static final class DefaultLogger
    implements HudsonLogger {
        public HudsonLogger.HudsonLogSession createSession(HudsonJob job) {
            return new HudsonLogger.HudsonLogSession(){

                public boolean handle(String line, OutputWriter stream) {
                    stream.println(line);
                    return true;
                }
            };
        }
    }
}

