/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.util.zip;

import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.maven.index.util.zip.AbstractZipHandle;
import org.apache.maven.index.util.zip.EntryNameFilter;
import org.apache.maven.index.util.zip.ZipHandle;

public class TrueZipZipFileHandle
extends AbstractZipHandle
implements ZipHandle {
    private final ZipFile zipFile;

    public TrueZipZipFileHandle(File targetFile) throws IOException {
        super(targetFile);
        this.zipFile = new ZipFile(targetFile);
    }

    protected ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public boolean hasEntry(String path) throws IOException {
        return this.getZipFile().getEntry(path) != null;
    }

    @Override
    public List<String> getEntries() {
        return this.getEntries(new EntryNameFilter(){

            @Override
            public boolean accepts(String entryName) {
                return true;
            }
        });
    }

    @Override
    public List<String> getEntries(EntryNameFilter filter) {
        ArrayList<String> entries = new ArrayList<String>();
        Enumeration en = this.getZipFile().entries();
        while (en.hasMoreElements()) {
            ZipEntry e = (ZipEntry)en.nextElement();
            String name = e.getName();
            if (filter != null && !filter.accepts(name)) continue;
            entries.add(name);
        }
        return entries;
    }

    @Override
    public InputStream getEntryContent(String path) throws IOException {
        ZipEntry entry = this.getZipFile().getEntry(path);
        if (entry != null) {
            return this.getZipFile().getInputStream(entry);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.getZipFile().close();
    }
}

