/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.nodes.Bundle;
import org.netbeans.modules.gradle.spi.Utils;
import org.netbeans.modules.gradle.spi.nodes.NodeUtils;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class SubProjectsNode
extends AbstractNode {
    private static final String SP_BADGE = "org/netbeans/modules/gradle/resources/gradle-badge.png";

    public SubProjectsNode(NbGradleProjectImpl proj, String path) {
        super(FilterNode.Children.create((ChildFactory)new SubProjectsChildFactory(proj, path), (boolean)true));
        if (":".equals(path)) {
            this.setName("SubProjects");
            this.setDisplayName(Bundle.LBL_SubProjects());
        } else {
            int colon = path.lastIndexOf(58, path.length() - 2);
            String partName = path.substring(colon + 1, path.length() - 1);
            this.setDisplayName(Utils.capitalize(partName));
            this.setName(path);
        }
    }

    public SubProjectsNode(NbGradleProjectImpl proj) {
        this(proj, ":");
    }

    public Action[] getActions(boolean bool) {
        return new Action[0];
    }

    private static Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)SP_BADGE, (boolean)true);
        return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
    }

    public Image getIcon(int type) {
        return SubProjectsNode.getIcon(false);
    }

    public Image getOpenedIcon(int type) {
        return SubProjectsNode.getIcon(true);
    }

    private static class OpenProjectAction
    extends AbstractAction
    implements ContextAwareAction {
        static final OpenProjectAction SINGLETON = new OpenProjectAction();

        private OpenProjectAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(final Lookup context) {
            return new AbstractAction(Bundle.BTN_Open_Project()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collection projects = context.lookupAll(NbGradleProjectImpl.class);
                    Project[] projectsArray = projects.toArray(new NbGradleProjectImpl[0]);
                    OpenProjects.getDefault().open(projectsArray, false, true);
                    if (projectsArray.length > 0) {
                        RequestProcessor.getDefault().post(new Runnable((NbGradleProjectImpl[])projectsArray){
                            final /* synthetic */ NbGradleProjectImpl[] val$projectsArray;
                            {
                                this.val$projectsArray = nbGradleProjectImplArray;
                            }

                            @Override
                            public void run() {
                                OpenProjects.getDefault().open((Project[])this.val$projectsArray, false, true);
                            }
                        }, 500);
                    }
                }
            };
        }
    }

    public static class ProjectFilterNode
    extends FilterNode {
        private final NbGradleProjectImpl project;

        ProjectFilterNode(NbGradleProjectImpl proj, Node original) {
            super(original, FilterNode.Children.LEAF);
            this.project = proj;
        }

        public Action[] getActions(boolean b) {
            ArrayList<OpenProjectAction> lst = new ArrayList<OpenProjectAction>();
            lst.add(OpenProjectAction.SINGLETON);
            return lst.toArray(new Action[lst.size()]);
        }

        public Action getPreferredAction() {
            return OpenProjectAction.SINGLETON;
        }
    }

    private static class SubProjectsChildFactory
    extends ChildFactory<String> {
        private final NbGradleProjectImpl project;
        private final PropertyChangeListener listener;
        private final String rootPath;

        SubProjectsChildFactory(NbGradleProjectImpl proj, String rootPath) {
            this.project = proj;
            this.rootPath = rootPath;
            NbGradleProject watcher = this.project.getProjectWatcher();
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("ProjectInfo".equals(evt.getPropertyName())) {
                        this.refresh(false);
                    }
                }
            };
            watcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)watcher));
        }

        protected boolean createKeys(List<String> paths) {
            Map<String, File> subProjects = this.project.getGradleProject().getBaseProject().getSubProjects();
            TreeSet<String> components = new TreeSet<String>();
            TreeSet<String> projects = new TreeSet<String>();
            for (String path : subProjects.keySet()) {
                if (!path.startsWith(this.rootPath)) continue;
                String relPath = path.substring(this.rootPath.length());
                int firstColon = relPath.indexOf(58);
                int lastColon = relPath.lastIndexOf(58);
                if (firstColon >= 0 && firstColon == lastColon) {
                    components.add(path.substring(0, this.rootPath.length() + firstColon + 1));
                }
                if (firstColon >= 0) continue;
                projects.add(path);
            }
            paths.addAll(components);
            paths.addAll(projects);
            return true;
        }

        protected Node createNodeForKey(String path) {
            Object ret = null;
            Map<String, File> subProjects = this.project.getGradleProject().getBaseProject().getSubProjects();
            File projectDir = subProjects.get(path);
            if (projectDir != null) {
                FileObject fo = FileUtil.toFileObject((File)projectDir);
                if (fo != null) {
                    try {
                        Project prj = ProjectManager.getDefault().findProject(fo);
                        if (prj != null && prj.getLookup().lookup(NbGradleProjectImpl.class) != null) {
                            NbGradleProjectImpl proj = (NbGradleProjectImpl)prj;
                            assert (prj.getLookup().lookup(LogicalViewProvider.class) != null);
                            Node original = ((LogicalViewProvider)proj.getLookup().lookup(LogicalViewProvider.class)).createLogicalView();
                            ret = new ProjectFilterNode(proj, original);
                        }
                    }
                    catch (IOException | IllegalArgumentException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            } else {
                ret = new SubProjectsNode(this.project, path);
            }
            return ret;
        }
    }
}

