/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.css.lib.api.FilterableError;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.javascript2.editor.parser.Bundle;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class ParsingErrorFilter {
    private static final RequestProcessor RP = new RequestProcessor(ParsingErrorFilter.class);
    private static final String DISABLE_JS_ERROR_KEY = "disable_error_checking_CSS";

    public static Collection<FilterableError.SetFilterAction> getEnableFilterAction(@NonNull FileObject file) {
        FileObject source = file;
        ArrayList<FilterableError.SetFilterAction> actions = new ArrayList<FilterableError.SetFilterAction>();
        while (file != null && FileOwnerQuery.getOwner((FileObject)file) != null) {
            actions.add(new SetFileFilterAction(source, file, true));
            file = file.getParent();
        }
        return actions;
    }

    public static FilterableError.SetFilterAction getDisableFilterAction(@NonNull FileObject file) {
        FileObject source = file;
        while (file != null && FileOwnerQuery.getOwner((FileObject)file) != null) {
            if (file.getAttribute(DISABLE_JS_ERROR_KEY) != null) {
                return new SetFileFilterAction(source, file, false);
            }
            file = file.getParent();
        }
        return null;
    }

    private static void refresh(FileObject file) {
        try {
            ParsingErrorFilter.refreshDocument(file);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void refreshDocument(final FileObject fo) throws IOException {
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    EditorCookie editorCookie = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                    StyledDocument document = editorCookie.openDocument();
                    ParsingErrorFilter.forceReparse(document);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private static void forceReparse(final Document doc) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NbEditorDocument nbdoc = (NbEditorDocument)doc;
                nbdoc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                        if (mti != null) {
                            mti.tokenHierarchyControl().rebuild();
                        }
                    }
                });
            }
        });
    }

    private static class SetFileFilterAction
    implements FilterableError.SetFilterAction {
        private final FileObject file;
        private final FileObject source;
        private final boolean enable;

        public SetFileFilterAction(FileObject source, FileObject file, boolean enable) {
            this.source = source;
            this.file = file;
            this.enable = enable;
        }

        public void run() {
            try {
                this.file.setAttribute(ParsingErrorFilter.DISABLE_JS_ERROR_KEY, (Object)(this.enable ? Boolean.TRUE.toString() : null));
                ParsingErrorFilter.refresh(this.source);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public String getDisplayName() {
            String path = this.file.getPath();
            return this.enable ? Bundle.enableFilterForFile(path) : Bundle.disableFilterForFile(path);
        }
    }
}

