/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.util.Mutex;

class SharabilityQueryImpl
implements SharabilityQueryImplementation2,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots srcRoots;
    private final SourceRoots testRoots;
    private final List<String> additionalSourceRoots;
    private SharabilityQueryImplementation2 delegate;

    public SharabilityQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots srcRoots, SourceRoots testRoots, String ... additionalSourceRoots) {
        assert (helper != null);
        assert (evaluator != null);
        assert (srcRoots != null);
        this.helper = helper;
        this.evaluator = evaluator;
        this.srcRoots = srcRoots;
        this.testRoots = testRoots;
        this.additionalSourceRoots = additionalSourceRoots != null ? Collections.unmodifiableList(Arrays.asList(additionalSourceRoots)) : Collections.emptyList();
        this.srcRoots.addPropertyChangeListener(this);
        if (this.testRoots != null) {
            this.testRoots.addPropertyChangeListener(this);
        }
    }

    public SharabilityQuery.Sharability getSharability(final URI file) {
        return (SharabilityQuery.Sharability)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SharabilityQuery.Sharability>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SharabilityQuery.Sharability run() {
                SharabilityQueryImpl sharabilityQueryImpl = SharabilityQueryImpl.this;
                synchronized (sharabilityQueryImpl) {
                    if (SharabilityQueryImpl.this.delegate == null) {
                        SharabilityQueryImpl.this.delegate = SharabilityQueryImpl.this.createDelegate();
                    }
                    return SharabilityQueryImpl.this.delegate.getSharability(file);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (SourceRoots.PROP_ROOT_PROPERTIES.equals(evt.getPropertyName())) {
            SharabilityQueryImpl sharabilityQueryImpl = this;
            synchronized (sharabilityQueryImpl) {
                this.delegate = null;
            }
        }
    }

    private SharabilityQueryImplementation2 createDelegate() {
        String[] srcProps = this.srcRoots.getRootProperties();
        String[] testProps = this.testRoots == null ? new String[]{} : this.testRoots.getRootProperties();
        String[] buildDirectories = new String[]{"${dist.dir}", "${build.dir}"};
        int size = srcProps.length;
        size += testProps.length;
        ArrayList<String> props = new ArrayList<String>(size += this.additionalSourceRoots.size());
        for (String src : srcProps) {
            props.add("${" + src + "}");
        }
        for (String test : testProps) {
            props.add("${" + test + "}");
        }
        props.addAll(this.additionalSourceRoots);
        return this.helper.createSharabilityQuery2(this.evaluator, props.toArray(new String[props.size()]), buildDirectories);
    }
}

