/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.openjdk.common.BuildUtils;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.openide.filesystems.FileObject;

public class SourceLevelQueryImpl
implements SourceLevelQueryImplementation {
    private static final Logger LOG = Logger.getLogger(SourceLevelQueryImpl.class.getName());
    private static final int DEFAULT_SOURCE_LEVEL = 11;
    private static final Pattern JDK_PATTERN = Pattern.compile("jdk([0-9]+)");
    private final String sourceLevel;

    public SourceLevelQueryImpl(FileObject jdkRoot) {
        FileObject sourceVersion = BuildUtils.getFileObject(jdkRoot, "src/java.compiler/share/classes/javax/lang/model/SourceVersion.java");
        int sl = 11;
        if (sourceVersion == null) {
            sourceVersion = BuildUtils.getFileObject(jdkRoot, "langtools/src/java.compiler/share/classes/javax/lang/model/SourceVersion.java");
        }
        if (sourceVersion != null) {
            try {
                TokenHierarchy th = TokenHierarchy.create((CharSequence)sourceVersion.asText(), (Language)JavaTokenId.language());
                TokenSequence seq = th.tokenSequence();
                while (seq.moveNext()) {
                    String ident;
                    if (seq.token().id() != JavaTokenId.IDENTIFIER || !(ident = seq.token().text().toString()).startsWith("RELEASE_")) continue;
                    try {
                        sl = Math.max(sl, Integer.parseInt(ident.substring("RELEASE_".length())));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        this.sourceLevel = "" + sl;
    }

    public String getSourceLevel(FileObject javaFile) {
        return this.sourceLevel;
    }
}

