/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.AbstractPost12ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ActionRunner;
import org.gradle.tooling.internal.consumer.connection.BuildInvocationsAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.GradleBuildAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.HasCompatibilityMapping;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.connection.UnsupportedActionRunner;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildActionRunner;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.model.internal.Exceptions;

public class BuildActionRunnerBackedConsumerConnection
extends AbstractPost12ConsumerConnection {
    private final ModelProducer modelProducer;
    private final UnsupportedActionRunner actionRunner;

    public BuildActionRunnerBackedConsumerConnection(ConnectionVersion4 delegate, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, VersionDetails.from(delegate.getMetaData().getVersion()));
        BuildActionRunnerBackedModelProducer consumerConnectionBackedModelProducer = new BuildActionRunnerBackedModelProducer(adapter, this.getVersionDetails(), modelMapping, (BuildActionRunner)((Object)delegate), this);
        GradleBuildAdapterProducer producerWithGradleBuild = new GradleBuildAdapterProducer(adapter, consumerConnectionBackedModelProducer, this);
        this.modelProducer = new BuildInvocationsAdapterProducer(adapter, this.getVersionDetails(), producerWithGradleBuild);
        this.actionRunner = new UnsupportedActionRunner(this.getVersionDetails().getVersion());
    }

    @Override
    protected ActionRunner getActionRunner() {
        return this.actionRunner;
    }

    @Override
    protected ModelProducer getModelProducer() {
        return this.modelProducer;
    }

    private static class BuildActionRunnerBackedModelProducer
    implements ModelProducer {
        private final ProtocolToModelAdapter adapter;
        private final VersionDetails versionDetails;
        private final ModelMapping modelMapping;
        private final BuildActionRunner buildActionRunner;
        private final HasCompatibilityMapping mapperProvider;

        public BuildActionRunnerBackedModelProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, BuildActionRunner buildActionRunner, HasCompatibilityMapping mapperProvider) {
            this.adapter = adapter;
            this.versionDetails = versionDetails;
            this.modelMapping = modelMapping;
            this.buildActionRunner = buildActionRunner;
            this.mapperProvider = mapperProvider;
        }

        @Override
        public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
            if (!this.versionDetails.maySupportModel(type)) {
                throw Exceptions.unsupportedModel(type, this.versionDetails.getVersion());
            }
            Class<?> protocolType = this.modelMapping.getProtocolType(type);
            Object model = this.buildActionRunner.run(protocolType, operationParameters).getModel();
            return this.mapperProvider.applyCompatibilityMapping(this.adapter.builder(type), operationParameters).build(model);
        }
    }
}

