/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CatalogModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionModelEx;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class DefaultModelProvider
extends CompletionModelProvider {
    @Override
    public synchronized List<CompletionModelProvider.CompletionModel> getModels(CompletionContext context) {
        if (context.getPrimaryFile() == null) {
            return null;
        }
        CompletionContextImpl contextImpl = (CompletionContextImpl)context;
        List<URI> uris = contextImpl.getSchemas();
        if (uris.isEmpty()) {
            return null;
        }
        ArrayList<CompletionModelProvider.CompletionModel> models = new ArrayList<CompletionModelProvider.CompletionModel>();
        for (URI uri : uris) {
            CompletionModelProvider.CompletionModel model = DefaultModelProvider.getCompletionModel(uri, true, contextImpl);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    static CompletionModelProvider.CompletionModel getCompletionModel(URI schemaURI, boolean fetch, CompletionContextImpl context) {
        CompletionModelEx model = null;
        try {
            ModelSource modelSource = null;
            CatalogModel catalogModel = null;
            CatalogModelProvider catalogModelProvider = DefaultModelProvider.getCatalogModelProvider();
            if (catalogModelProvider == null) {
                modelSource = Utilities.getModelSource((FileObject)context.getPrimaryFile(), (boolean)true);
                CatalogModelFactory factory = CatalogModelFactory.getDefault();
                catalogModel = factory.getCatalogModel(modelSource);
            } else {
                modelSource = catalogModelProvider.getModelSource(context.getPrimaryFile(), true);
                catalogModel = catalogModelProvider.getCatalogModel();
            }
            String uriString = schemaURI.toString();
            String addParams = "fetch=" + fetch + "&sync=true";
            int index = uriString.indexOf(63);
            uriString = index > -1 ? uriString.substring(0, index + 1) + addParams + '&' + uriString.substring(index + 1) : ((index = uriString.indexOf(35)) > -1 ? uriString.substring(0, index) + '?' + addParams + uriString.substring(index) : uriString + '?' + addParams);
            URI uri = new URI(uriString);
            ModelSource schemaModelSource = catalogModel.getModelSource(uri, modelSource);
            SchemaModel sm = null;
            sm = schemaModelSource.getLookup().lookup(FileObject.class) == null ? (SchemaModel)SchemaModelFactory.getDefault().createFreshModel(schemaModelSource) : SchemaModelFactory.getDefault().getModel(schemaModelSource);
            String tns = sm.getSchema().getTargetNamespace();
            List<String> prefixes = CompletionUtil.getPrefixesAgainstNamespace(context, tns);
            model = prefixes != null && prefixes.size() > 0 ? new CompletionModelEx(context, prefixes.get(0), sm) : new CompletionModelEx(context, context.suggestPrefix(tns), sm);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return model;
    }

    private static CatalogModelProvider getCatalogModelProvider() {
        Lookup.Template templ = new Lookup.Template(CatalogModelProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(templ);
        Collection impls = result.allInstances();
        if (impls.isEmpty()) {
            return null;
        }
        return (CatalogModelProvider)impls.iterator().next();
    }
}

