/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.java.plugins.DeleteFile;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveClassTransformer;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MoveFileRefactoringPlugin
extends JavaRefactoringPlugin {
    private Map packagePostfix = new HashMap();
    final AbstractRefactoring refactoring;
    final boolean isRenameRefactoring;
    ArrayList<FileObject> filesToMove = new ArrayList();
    Set<ElementHandle<TypeElement>> classes;
    Set<ElementHandle<PackageElement>> packages;
    List<List<FileObject>> foldersToMove = new ArrayList<List<FileObject>>();
    Set<String> packageNames;
    private Set<ElementHandle<TypeElement>> elementHandles;
    private Set<ElementHandle<TypeElement>> handlesToMove;

    public MoveFileRefactoringPlugin(MoveRefactoring move) {
        this((AbstractRefactoring)move, false);
        this.setup(move.getRefactoringSource().lookupAll(FileObject.class), "", true);
    }

    public MoveFileRefactoringPlugin(RenameRefactoring rename) {
        this((AbstractRefactoring)rename, true);
        FileObject fo = (FileObject)rename.getRefactoringSource().lookup(FileObject.class);
        if (fo != null) {
            this.setup(Collections.singletonList(fo), "", true);
        } else {
            this.setup(Collections.singletonList(((NonRecursiveFolder)rename.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder()), "", false);
        }
    }

    private MoveFileRefactoringPlugin(AbstractRefactoring refactoring, boolean isRenameRefactoring) {
        this.refactoring = refactoring;
        if (refactoring == null) {
            throw new NullPointerException();
        }
        this.isRenameRefactoring = isRenameRefactoring;
        this.elementHandles = new HashSet<ElementHandle<TypeElement>>();
        this.handlesToMove = new HashSet<ElementHandle<TypeElement>>();
    }

    @Override
    public Problem preCheck() {
        this.cancelRequest = false;
        this.cancelRequested.set(false);
        Problem preCheckProblem = null;
        for (FileObject file : this.filesToMove) {
            if (RefactoringUtils.isFileInOpenProject(file)) continue;
            preCheckProblem = MoveFileRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_ProjectNotOpened", (Object)FileUtil.getFileDisplayName((FileObject)file)));
        }
        for (TreePathHandle tph : this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class)) {
            ElementHandle elementHandle = tph.getElementHandle();
            if (elementHandle == null || !elementHandle.getKind().isClass() && !elementHandle.getKind().isInterface()) {
                preCheckProblem = MoveFileRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_NotClass"));
                continue;
            }
            FileObject file = tph.getFileObject();
            if (RefactoringUtils.isFileInOpenProject(file)) continue;
            preCheckProblem = MoveFileRefactoringPlugin.createProblem(preCheckProblem, true, NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_ProjectNotOpened", (Object)FileUtil.getFileDisplayName((FileObject)file)));
        }
        return preCheckProblem;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        block25: {
            if (this.isRenameRefactoring) {
                FileObject f = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
                if (f != null) {
                    String newName = ((RenameRefactoring)this.refactoring).getNewName();
                    if (!RefactoringUtils.isValidPackageName(newName) || newName.indexOf(46) > 0) {
                        String msg = new MessageFormat(NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_InvalidFolder")).format(new Object[]{newName});
                        return new Problem(true, msg);
                    }
                    FileObject fileObject = f.getParent().getFileObject(newName, f.getExt());
                    if (fileObject != null && fileObject.getName().contentEquals(newName)) {
                        String msg = new MessageFormat(NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_PackageExists")).format(new Object[]{newName});
                        return new Problem(true, msg);
                    }
                }
                return super.fastCheckParameters();
            }
            if (!this.isRenameRefactoring) {
                try {
                    URL targetUrl = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
                    if (targetUrl != null) {
                        FileObject rootFO = null;
                        try {
                            rootFO = RefactoringUtils.getRootFileObject(targetUrl);
                        }
                        catch (IOException | IllegalArgumentException fileObject) {
                            // empty catch block
                        }
                        if (rootFO == null || ClassPath.getClassPath((FileObject)rootFO, (String)"classpath/source") == null) {
                            return new Problem(true, Bundle.ERR_ClasspathNotFound(rootFO));
                        }
                        for (FileObject f : this.filesToMove) {
                            if (!RefactoringUtils.isJavaFile(f)) continue;
                            String targetPackageName = this.getTargetPackageName(f);
                            if (!RefactoringUtils.isValidPackageName(targetPackageName)) {
                                String s = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage");
                                String msg = new MessageFormat(s).format(new Object[]{targetPackageName});
                                return new Problem(true, msg);
                            }
                            FileObject targetRoot = RefactoringUtils.getClassPathRoot(targetUrl);
                            FileObject targetF = targetRoot.getFileObject(targetPackageName.replace('.', '/'));
                            String pkgName = null;
                            if (targetF != null && !targetF.canWrite()) {
                                return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_PackageIsReadOnly")).format(new Object[]{targetPackageName}));
                            }
                            pkgName = targetPackageName;
                            if (pkgName == null) {
                                pkgName = "";
                            } else if (pkgName.length() > 0) {
                                pkgName = pkgName + '.';
                            }
                            String fileName = f.getName();
                            if (targetF == null) continue;
                            FileObject[] children = targetF.getChildren();
                            for (int x = 0; x < children.length; ++x) {
                                if (!children[x].getName().equals(fileName) || !"java".equals(children[x].getExt()) || children[x].equals(f) || children[x].isVirtual()) continue;
                                return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_ClassToMoveClashes")).format(new Object[]{fileName}));
                            }
                        }
                        break block25;
                    }
                    for (TreePathHandle tph : this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class)) {
                        String s;
                        FileObject f = tph.getFileObject();
                        if (!RefactoringUtils.isJavaFile(f)) {
                            return new Problem(true, NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_NotJava", (Object)f));
                        }
                        if (targetUrl != null) {
                            String targetPackageName;
                            String string = targetPackageName = targetUrl != null ? RefactoringUtils.getPackageName(targetUrl) : null;
                            if (targetPackageName == null || !RefactoringUtils.isValidPackageName(targetPackageName)) {
                                s = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage");
                                String msg = new MessageFormat(s).format(new Object[]{targetPackageName});
                                return new Problem(true, msg);
                            }
                            FileObject targetRoot = RefactoringUtils.getClassPathRoot(targetUrl);
                            FileObject targetF = targetRoot.getFileObject(targetPackageName.replace('.', '/'));
                            if (targetF != null && !targetF.canWrite()) {
                                return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_PackageIsReadOnly")).format(new Object[]{targetPackageName}));
                            }
                            String fileName = f.getName();
                            if (targetF == null) continue;
                            FileObject[] children = targetF.getChildren();
                            for (int i = 0; i < children.length; ++i) {
                                if (!children[i].getName().equals(fileName) || !"java".equals(children[i].getExt()) || children[i].equals(f) || children[i].isVirtual()) continue;
                                return new Problem(true, new MessageFormat(NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_ClassToMoveClashes")).format(new Object[]{fileName}));
                            }
                            continue;
                        }
                        TreePathHandle target = (TreePathHandle)((MoveRefactoring)this.refactoring).getTarget().lookup(TreePathHandle.class);
                        if (target != null) continue;
                        s = NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_NoTargetFound");
                        return new Problem(true, s);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (this.refactoring.getRefactoringSource().lookup(TreePathHandle.class) != null) {
            return super.fastCheckParameters();
        }
        return null;
    }

    @Override
    protected Problem fastCheckParameters(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        for (TreePathHandle tph : this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class)) {
            FileObject f = tph.getFileObject();
            Element resolveElement = tph.resolveElement((CompilationInfo)javac);
            URL targetUrl = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
            if (targetUrl != null) {
                FileObject targetRoot = RefactoringUtils.getClassPathRoot(targetUrl);
                String targetPackageName = RefactoringUtils.getPackageName(targetUrl);
                FileObject targetF = targetRoot.getFileObject(targetPackageName.replace('.', '/'));
                if (!f.getParent().equals(targetF) || !resolveElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                return new Problem(true, NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_CannotMovePublicIntoSamePackage"));
            }
            TreePathHandle target = (TreePathHandle)((MoveRefactoring)this.refactoring).getTarget().lookup(TreePathHandle.class);
            ElementHandle elementHandle = target.getElementHandle();
            assert (elementHandle != null);
            TypeElement targetType = (TypeElement)elementHandle.resolve((CompilationInfo)javac);
            List<? extends Element> enclosedElements = targetType.getEnclosedElements();
            for (Element element : enclosedElements) {
                switch (element.getKind()) {
                    case ENUM: 
                    case CLASS: 
                    case ANNOTATION_TYPE: 
                    case INTERFACE: {
                        if (!element.getSimpleName().contentEquals(resolveElement.getSimpleName())) break;
                        return new Problem(true, Bundle.ERR_ClassToMoveClashesInner(element.getSimpleName(), targetType.getSimpleName()));
                    }
                }
            }
        }
        return super.fastCheckParameters(javac);
    }

    private Problem checkProjectDeps() {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        HashSet<FileObject> sourceRoots = new HashSet<FileObject>();
        for (TreePathHandle tph : this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class)) {
            FileObject file = tph.getFileObject();
            ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
            if (cp == null) continue;
            FileObject root = cp.findOwnerRoot(file);
            sourceRoots.add(root);
        }
        URL target = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
        if (target == null) {
            return null;
        }
        try {
            FileObject r = RefactoringUtils.getClassPathRoot(target);
            URL targetUrl = URLMapper.findURL((FileObject)r, (int)1);
            Project targetProject = FileOwnerQuery.getOwner((FileObject)r);
            Set deps = SourceUtils.getDependentRoots((URL)targetUrl);
            for (FileObject sourceRoot : sourceRoots) {
                URL sourceUrl = URLMapper.findURL((FileObject)sourceRoot, (int)0);
                if (deps.contains(sourceUrl)) continue;
                Project sourceProject = FileOwnerQuery.getOwner((FileObject)sourceRoot);
                for (ElementHandle<TypeElement> affected : this.elementHandles) {
                    FileObject affectedFile = SourceUtils.getFile(affected, (ClasspathInfo)cpInfo);
                    if (!FileOwnerQuery.getOwner((FileObject)affectedFile).equals(sourceProject) || this.handlesToMove.contains(affected) || sourceProject.equals(targetProject)) continue;
                    assert (sourceProject != null);
                    assert (targetProject != null);
                    String sourceName = ProjectUtils.getInformation((Project)sourceProject).getDisplayName();
                    String targetName = ProjectUtils.getInformation((Project)targetProject).getDisplayName();
                    return MoveFileRefactoringPlugin.createProblem(null, false, NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_MissingProjectDeps", (Object)sourceName, (Object)targetName));
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    private Problem checkProjectDeps(Set<FileObject> a) {
        if (!this.isRenameRefactoring) {
            HashSet<FileObject> sourceRoots = new HashSet<FileObject>();
            for (FileObject file : this.filesToMove) {
                ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
                if (cp == null) continue;
                FileObject root = cp.findOwnerRoot(file);
                sourceRoots.add(root);
            }
            URL target = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
            if (target == null) {
                return null;
            }
            try {
                FileObject r = RefactoringUtils.getClassPathRoot(target);
                URL targetUrl = URLMapper.findURL((FileObject)r, (int)1);
                Project targetProject = FileOwnerQuery.getOwner((FileObject)r);
                Set deps = SourceUtils.getDependentRoots((URL)targetUrl);
                for (FileObject sourceRoot : sourceRoots) {
                    URL sourceUrl = URLMapper.findURL((FileObject)sourceRoot, (int)0);
                    if (deps.contains(sourceUrl)) continue;
                    Project sourceProject = FileOwnerQuery.getOwner((FileObject)sourceRoot);
                    for (FileObject affected : a) {
                        if (!FileOwnerQuery.getOwner((FileObject)affected).equals(sourceProject) || this.filesToMove.contains(affected) || sourceProject.equals(targetProject)) continue;
                        assert (sourceProject != null);
                        assert (targetProject != null);
                        String sourceName = ProjectUtils.getInformation((Project)sourceProject).getDisplayName();
                        String targetName = ProjectUtils.getInformation((Project)targetProject).getDisplayName();
                        return MoveFileRefactoringPlugin.createProblem(null, false, NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_MissingProjectDeps", (Object)sourceName, (Object)targetName));
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles(TreePathHandle tph) {
        Set files;
        Object targetHandle;
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        ClassIndex idx = cpInfo.getClassIndex();
        LinkedHashSet<FileObject> set = new LinkedHashSet<FileObject>();
        if (!this.isRenameRefactoring && (targetHandle = (TreePathHandle)((MoveRefactoring)this.refactoring).getTarget().lookup(TreePathHandle.class)) != null) {
            set.add(targetHandle.getFileObject());
        }
        for (ElementHandle elementHandle : this.classes) {
            files = idx.getResources(elementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            set.addAll(files);
        }
        for (ElementHandle elementHandle : this.packages) {
            files = idx.getResourcesForPackage(elementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            set.addAll(files);
        }
        set.addAll(this.filesToMove);
        this.elementHandles.clear();
        if (tph != null) {
            ElementHandle elementHandle = tph.getElementHandle();
            this.handlesToMove.add((ElementHandle<TypeElement>)elementHandle);
            set.add(SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)cpInfo));
            Set set2 = idx.getResources(elementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            set.addAll(set2);
            Set handles = idx.getElements(elementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            this.elementHandles.addAll(handles);
        }
        return set;
    }

    private void initClasses() {
        this.classes = new HashSet<ElementHandle<TypeElement>>();
        this.packages = new HashSet<ElementHandle<PackageElement>>();
        for (int i = 0; i < this.filesToMove.size(); ++i) {
            int j = i;
            try {
                JavaSource source = JavaSource.forFileObject((FileObject)this.filesToMove.get(i));
                source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void run(CompilationController parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        List<? extends Tree> trees = parameter.getCompilationUnit().getTypeDecls();
                        for (Tree tree : trees) {
                            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
                            TypeElement klass = (TypeElement)parameter.getTrees().getElement(TreePath.getPath(parameter.getCompilationUnit(), tree));
                            MoveFileRefactoringPlugin.this.classes.add((ElementHandle<TypeElement>)ElementHandle.create((Element)klass));
                            PackageElement packageOf = parameter.getElements().getPackageOf(klass);
                            MoveFileRefactoringPlugin.this.packages.add((ElementHandle<PackageElement>)ElementHandle.create((Element)packageOf));
                        }
                    }
                }, true);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private Problem initPackages() {
        if (this.foldersToMove.isEmpty()) {
            this.packageNames = Collections.emptySet();
            return null;
        }
        this.packageNames = new HashSet<String>();
        for (List<FileObject> folders : this.foldersToMove) {
            ClassPath cp = ClassPath.getClassPath((FileObject)folders.get(0), (String)"classpath/source");
            if (cp == null) {
                return new Problem(true, NbBundle.getMessage(MoveFileRefactoringPlugin.class, (String)"ERR_ClasspathNotFound", (Object)folders.get(0)));
            }
            for (FileObject folder : folders) {
                String pkgName = cp.getResourceName(folder, '.', false);
                this.packageNames.add(pkgName);
            }
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        RefactoringVisitor transformer;
        this.fireProgressListenerStart(3, -1);
        this.initClasses();
        Problem p = this.initPackages();
        if (p != null) {
            return p;
        }
        TreePathHandle sourceTph = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        Set<FileObject> a = this.getRelevantFiles(sourceTph);
        if (!this.isRenameRefactoring) {
            URL targetUrl = (URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class);
            TreePathHandle targetTph = (TreePathHandle)((MoveRefactoring)this.refactoring).getTarget().lookup(TreePathHandle.class);
            if (targetUrl != null && sourceTph == null) {
                p = this.checkProjectDeps(a);
                transformer = new MoveTransformer(this);
            } else {
                p = this.checkProjectDeps();
                transformer = targetUrl != null ? new MoveClassTransformer(sourceTph, targetUrl) : (sourceTph != null ? new MoveClassTransformer(sourceTph, (ElementHandle<TypeElement>)targetTph.getElementHandle()) : new MoveClassTransformer(this.classes.iterator().next(), (ElementHandle<TypeElement>)targetTph.getElementHandle()));
            }
        } else {
            p = this.checkProjectDeps(a);
            transformer = new MoveTransformer(this);
        }
        this.fireProgressListenerStep(a.size());
        JavaRefactoringPlugin.TransformTask task = new JavaRefactoringPlugin.TransformTask(this, transformer, null);
        Problem prob = this.createAndAddElements(a, task, elements, this.refactoring);
        Problem problem = null;
        if (transformer instanceof MoveClassTransformer) {
            MoveClassTransformer moveClassTransformer = (MoveClassTransformer)transformer;
            if (moveClassTransformer.deleteFile()) {
                DeleteFile deleteFile = sourceTph != null ? new DeleteFile(sourceTph.getFileObject(), elements) : new DeleteFile(this.filesToMove.get(0), elements);
                elements.add(this.refactoring, (RefactoringElementImplementation)deleteFile);
            }
            problem = moveClassTransformer.getProblem();
        } else if (transformer instanceof MoveTransformer) {
            RefactoringVisitor moveTransformer = transformer;
            problem = ((MoveTransformer)moveTransformer).getProblem();
        }
        this.fireProgressListenerStop();
        return prob != null ? prob : JavaPluginUtils.chainProblems(p, problem);
    }

    String getNewPackageName() {
        if (this.isRenameRefactoring) {
            return ((RenameRefactoring)this.refactoring).getNewName();
        }
        return RefactoringUtils.getPackageName((URL)((MoveRefactoring)this.refactoring).getTarget().lookup(URL.class));
    }

    String getTargetPackageName(FileObject fo) {
        if (this.isRenameRefactoring) {
            if (this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class) != null) {
                return this.getNewPackageName();
            }
            FileObject folder = (FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class);
            ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
            FileObject root = cp.findOwnerRoot(folder);
            String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)folder.getParent());
            String prefix = relativePath == null ? "" : relativePath.replace('/', '.');
            String relativePath1 = FileUtil.getRelativePath((FileObject)folder, (FileObject)(fo.isFolder() ? fo : fo.getParent()));
            String postfix = relativePath1 == null ? "" : relativePath1.replace('/', '.');
            String t = this.concat(prefix, this.getNewPackageName(), postfix);
            return t;
        }
        if (this.packagePostfix != null) {
            if (fo == null) {
                return this.getNewPackageName();
            }
            String postfix = (String)this.packagePostfix.get(fo);
            String packageName = this.concat(null, this.getNewPackageName(), postfix);
            return packageName;
        }
        return this.getNewPackageName();
    }

    private void setup(Collection fileObjects, String postfix, boolean recursively) {
        this.setup(fileObjects, postfix, recursively, null);
    }

    private void setup(Collection fileObjects, String postfix, boolean recursively, List<FileObject> sameRootList) {
        for (FileObject fo : fileObjects) {
            if (RefactoringUtils.isJavaFile(fo)) {
                this.packagePostfix.put(fo, postfix.replace('/', '.'));
                this.filesToMove.add(fo);
                continue;
            }
            if (!fo.isFolder()) {
                this.packagePostfix.put(fo, postfix.replace('/', '.'));
                continue;
            }
            if (!VisibilityQuery.getDefault().isVisible(fo)) continue;
            boolean addDot = !"".equals(postfix);
            ArrayList<FileObject> col = new ArrayList<FileObject>();
            for (FileObject fo2 : fo.getChildren()) {
                if (fo2.isFolder() && (!fo2.isFolder() || !recursively)) continue;
                col.add(fo2);
            }
            List<FileObject> curRootList = sameRootList;
            if (sameRootList == null) {
                curRootList = new ArrayList<FileObject>();
                this.foldersToMove.add(curRootList);
            }
            curRootList.add(fo);
            this.setup(col, postfix + (addDot ? "." : "") + fo.getName(), recursively, curRootList);
        }
    }

    private String concat(String s1, String s2, String s3) {
        String result = "";
        if (s1 != null && !"".equals(s1)) {
            result = result + s1 + ".";
        }
        result = result + s2;
        if (s3 != null && !"".equals(s3)) {
            result = result + ("".equals(result) ? "" : ".") + s3;
        }
        return result;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        TreePathHandle tph = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (tph == null) {
            return null;
        }
        switch (p) {
            case FASTCHECKPARAMETERS: {
                ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
                return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{tph.getFileObject()});
            }
        }
        return JavaSource.forFileObject((FileObject)tph.getFileObject());
    }
}

