/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.KeyComparator;
import org.netbeans.modules.properties.MultiBundleStructure;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.netbeans.modules.properties.PropertiesDataLoader;
import org.netbeans.modules.properties.PropertiesDataNode;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesEncoding;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.netbeans.modules.properties.Util;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public final class PropertiesDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = 4795737295255253334L;
    static final Logger LOG = Logger.getLogger(PropertiesDataObject.class.getName());
    private transient BundleStructure bundleStructure;
    private transient PropertiesOpen openSupport;
    private final transient Object OPEN_SUPPORT_LOCK = new Object();
    private transient String pasteSuffix;
    private Lookup lookup;

    public PropertiesDataObject(FileObject primaryFile, PropertiesDataLoader loader) throws DataObjectExistsException {
        super(primaryFile, (MultiFileLoader)loader);
        this.initialize();
    }

    PropertiesEncoding getEncoding() {
        return ((PropertiesDataLoader)this.getLoader()).getEncoding();
    }

    protected int associateLookup() {
        return 1;
    }

    private void initialize() {
        this.bundleStructure = null;
        Class[] arr = new Class[]{PropertiesOpen.class, PropertiesEditorSupport.class};
        this.getCookieSet().add(arr, (CookieSet.Factory)this);
        this.getCookieSet().assign(PropertiesEncoding.class, (Object[])new PropertiesEncoding[]{this.getEncoding()});
    }

    public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
        if (clazz.isAssignableFrom(PropertiesOpen.class)) {
            return (T)((Object)this.getOpenSupport());
        }
        if (clazz.isAssignableFrom(PropertiesEditorSupport.class)) {
            return (T)((PropertiesFileEntry)this.getPrimaryEntry()).getPropertiesEditor();
        }
        return null;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleRename(String name) throws IOException {
        boolean baseNameChanged = false;
        MultiBundleStructure oldStructure = (MultiBundleStructure)this.bundleStructure;
        FileObject fo = this.getPrimaryFile();
        PropertiesOpen openCookie = (PropertiesOpen)this.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.removeModifiedListener(this);
            openCookie.close();
        }
        if (this.bundleStructure != null && this.bundleStructure.getEntryCount() > 1 && !Util.getBaseName(name).equals(Util.getBaseName(this.getName()))) {
            baseNameChanged = true;
            this.bundleStructure = null;
            this.openSupport = null;
        }
        try {
            FileObject fileObject = super.handleRename(name);
            return fileObject;
        }
        finally {
            if (baseNameChanged && oldStructure != null && ((BundleStructure)oldStructure).getEntryCount() > 1) {
                ((BundleStructure)oldStructure).updateEntries();
                oldStructure.notifyOneFileChanged(fo);
            }
            this.bundleStructure = null;
            this.openSupport = null;
        }
    }

    protected synchronized DataObject handleCopy(DataFolder df) throws IOException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("handleCopy(" + FileUtil.getFileDisplayName((FileObject)df.getPrimaryFile()) + ')');
        }
        try {
            DataObject dataObject = super.handleCopy(df);
            return dataObject;
        }
        finally {
            this.pasteSuffix = null;
            this.bundleStructure = null;
        }
    }

    protected void handleDelete() throws IOException {
        PropertiesOpen openCookie;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("handleDelete()");
        }
        if ((openCookie = (PropertiesOpen)this.getCookie(OpenCookie.class)) != null) {
            openCookie.removeModifiedListener(this);
            this.bundleStructure = null;
            this.openSupport = null;
        }
        super.handleDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleMove(DataFolder df) throws IOException {
        PropertiesOpen openCookie;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("handleMove(" + FileUtil.getFileDisplayName((FileObject)df.getPrimaryFile()) + ')');
        }
        MultiBundleStructure oldStructure = (MultiBundleStructure)this.bundleStructure;
        FileObject fo = this.getPrimaryFile();
        SaveCookie saveCookie = (SaveCookie)this.getCookie(SaveCookie.class);
        if (saveCookie != null) {
            saveCookie.save();
        }
        if ((openCookie = (PropertiesOpen)this.getCookie(OpenCookie.class)) != null) {
            openCookie.removeModifiedListener(this);
            openCookie.close();
            this.bundleStructure = null;
            this.openSupport = null;
        }
        try {
            FileObject fileObject = super.handleMove(df);
            return fileObject;
        }
        finally {
            if (oldStructure != null && ((BundleStructure)oldStructure).getEntryCount() > 1) {
                ((BundleStructure)oldStructure).updateEntries();
                oldStructure.notifyOneFileChanged(fo);
            }
            this.pasteSuffix = null;
            this.bundleStructure = null;
            this.openSupport = null;
        }
    }

    String getPasteSuffix() {
        return this.pasteSuffix;
    }

    void removeSecondaryEntry2(MultiDataObject.Entry fe) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("removeSecondaryEntry2(Entry " + FileUtil.getFileDisplayName((FileObject)fe.getFile()) + ')');
        }
        this.removeSecondaryEntry(fe);
    }

    private String createPasteSuffix(DataFolder folder) {
        String basicName = this.getPrimaryFile().getName();
        DataObject[] children = folder.getChildren();
        int i = 0;
        while (true) {
            String newName = i == 0 ? basicName : basicName + i;
            boolean exist = false;
            for (int j = 0; j < children.length; ++j) {
                if (!(children[j] instanceof PropertiesDataObject) || !newName.equals(children[j].getName())) continue;
                exist = true;
                break;
            }
            if (!exist) {
                if (i == 0) {
                    return "";
                }
                return "" + i;
            }
            ++i;
        }
    }

    public PropertiesOpen getOpenSupport() {
        if (this.openSupport == null) {
            this.openSupport = ((MultiBundleStructure)this.getBundleStructure()).getOpenSupport();
            if (this.isValid()) {
                this.openSupport.addDataObject(this);
            }
        }
        return this.openSupport;
    }

    void updateModificationStatus() {
        LOG.finer("updateModificationStatus()");
        boolean modif = false;
        if (((PresentableFileEntry)this.getPrimaryEntry()).isModified()) {
            modif = true;
        } else {
            Iterator it = this.secondaryEntries().iterator();
            while (it.hasNext()) {
                if (!((PresentableFileEntry)((Object)it.next())).isModified()) continue;
                modif = true;
                break;
            }
        }
        super.setModified(modif);
    }

    protected Node createNodeDelegate() {
        return new PropertiesDataNode(this, this.getLookup());
    }

    Children getChildren() {
        return new PropertiesChildren();
    }

    boolean isMultiLocale() {
        return this.secondaryEntries().size() > 0;
    }

    protected synchronized BundleStructure findBundleStructure() {
        PropertiesDataObject dataObject = null;
        try {
            dataObject = Util.findPrimaryDataObject(this);
        }
        catch (DataObjectNotFoundException doe) {
            Exceptions.printStackTrace((Throwable)doe);
        }
        if (this == dataObject) {
            MultiBundleStructure structure = new MultiBundleStructure(this);
            return structure;
        }
        return dataObject.getBundleStructure();
    }

    protected BundleStructure getBundleStructureOrNull() {
        return this.bundleStructure;
    }

    public BundleStructure getBundleStructure() {
        if (this.bundleStructure == null) {
            try {
                this.bundleStructure = Util.findBundleStructure(this.getPrimaryFile(), this.getPrimaryFile().getParent(), Util.getBaseName(this.getName()));
                if (this.bundleStructure == null) {
                    this.bundleStructure = new MultiBundleStructure(this);
                }
                this.bundleStructure.updateEntries();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
        return this.bundleStructure;
    }

    protected void setBundleStructure(BundleStructure structure) {
        if (this.bundleStructure != structure) {
            this.bundleStructure = structure;
        }
    }

    public static Comparator<String> getSecondaryFilesComparator() {
        return new KeyComparator();
    }

    void fireNameChange() {
        LOG.finer("fireNameChange()");
        this.firePropertyChange("name", null, null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initialize();
    }

    private class PropertiesChildren
    extends Children.Keys<String> {
        private PropertyChangeListener propertyListener = null;
        private PropertyChangeListener weakPropListener = null;

        PropertiesChildren() {
        }

        protected void mySetKeys() {
            TreeSet<String> newKeys = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
            newKeys.add(PropertiesDataObject.this.getPrimaryEntry().getFile().getName());
            for (MultiDataObject.Entry entry : PropertiesDataObject.this.secondaryEntries()) {
                newKeys.add(entry.getFile().getName());
            }
            this.setKeys(newKeys);
        }

        protected void addNotify() {
            this.mySetKeys();
            if (this.propertyListener == null) {
                this.propertyListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("files".equals(evt.getPropertyName())) {
                            if (PropertiesDataObject.this.isMultiLocale()) {
                                PropertiesChildren.this.mySetKeys();
                            } else if (PropertiesChildren.this.propertyListener != null) {
                                PropertiesDataObject.this.removePropertyChangeListener(PropertiesChildren.this.weakPropListener);
                                PropertiesChildren.this.propertyListener = null;
                            }
                        }
                    }
                };
                this.weakPropListener = WeakListeners.propertyChange((PropertyChangeListener)this.propertyListener, (Object)((Object)PropertiesDataObject.this));
                PropertiesDataObject.this.addPropertyChangeListener(this.weakPropListener);
            }
        }

        protected void removeNotify() {
            this.setKeys(new ArrayList());
        }

        protected Node[] createNodes(String entryName) {
            if (entryName == null) {
                return null;
            }
            PropertiesFileEntry entry2 = (PropertiesFileEntry)PropertiesDataObject.this.getPrimaryEntry();
            if (entryName.equals(entry2.getFile().getName())) {
                return new Node[]{entry2.getNodeDelegate()};
            }
            for (PropertiesFileEntry entry2 : PropertiesDataObject.this.secondaryEntries()) {
                if (!entryName.equals(entry2.getFile().getName())) continue;
                return new Node[]{entry2.getNodeDelegate()};
            }
            return null;
        }
    }
}

