/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.model;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.javafx2.editor.completion.beans.FxDefinition;
import org.netbeans.modules.javafx2.editor.completion.model.Dummy;
import org.netbeans.modules.javafx2.editor.completion.model.EventHandler;
import org.netbeans.modules.javafx2.editor.completion.model.FxInclude;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstanceCopy;
import org.netbeans.modules.javafx2.editor.completion.model.FxNewInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.FxObjectBase;
import org.netbeans.modules.javafx2.editor.completion.model.FxReference;
import org.netbeans.modules.javafx2.editor.completion.model.FxScriptFragment;
import org.netbeans.modules.javafx2.editor.completion.model.HasContent;
import org.netbeans.modules.javafx2.editor.completion.model.HasResource;
import org.netbeans.modules.javafx2.editor.completion.model.ImportDecl;
import org.netbeans.modules.javafx2.editor.completion.model.LanguageDecl;
import org.netbeans.modules.javafx2.editor.completion.model.MapProperty;
import org.netbeans.modules.javafx2.editor.completion.model.PropertySetter;
import org.netbeans.modules.javafx2.editor.completion.model.PropertyValue;
import org.netbeans.modules.javafx2.editor.completion.model.StaticProperty;
import org.netbeans.modules.javafx2.editor.completion.model.XmlNode;
import org.netbeans.modules.javafx2.editor.parser.ModelAccessor;
import org.netbeans.modules.javafx2.editor.parser.NodeInfo;

public final class FxModel
extends FxNode {
    private URL baseURL;
    private List<ImportDecl> imports = Collections.emptyList();
    private Map<String, FxNewInstance> definitions = Collections.emptyMap();
    private LanguageDecl language;
    @NullAllowed
    private FxObjectBase rootComponent;
    private String controller;
    private ElementHandle<TypeElement> controllerType;
    private Map<String, ? extends FxInstance> namedInstances = Collections.emptyMap();

    public List<ImportDecl> getImports() {
        return this.imports;
    }

    public Collection<FxNewInstance> getDefinitions() {
        return this.definitions.values();
    }

    @CheckForNull
    public LanguageDecl getLanguage() {
        return this.language;
    }

    @CheckForNull
    public FxObjectBase getRootComponent() {
        return this.rootComponent;
    }

    FxModel(URL baseURL) {
        this.baseURL = baseURL;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    void setLanguage(LanguageDecl lang) {
        this.language = lang;
    }

    void setImports(List<ImportDecl> decls) {
        this.imports = Collections.unmodifiableList(decls);
    }

    void addDefinitions(Collection<FxNewInstance> defs) {
        if (defs.isEmpty()) {
            return;
        }
        LinkedHashMap<String, FxNewInstance> newInstances = new LinkedHashMap<String, FxNewInstance>(this.definitions.size() + defs.size());
        newInstances.putAll(this.definitions);
        this.addDefinitions(defs, newInstances);
        this.definitions = Collections.unmodifiableMap(newInstances);
    }

    private void addDefinitions(Collection<FxNewInstance> defs, Map<String, FxNewInstance> instances) {
        for (FxNewInstance i : defs) {
            if (i.getId() == null) continue;
            instances.put(i.getId(), i);
        }
    }

    void setDefinitions(List<FxNewInstance> defs) {
        LinkedHashMap<String, FxNewInstance> newInstances = new LinkedHashMap<String, FxNewInstance>(defs.size());
        this.addDefinitions(defs, newInstances);
        this.definitions = Collections.unmodifiableMap(newInstances);
    }

    void setRootComponent(FxObjectBase root) {
        this.rootComponent = root;
    }

    @Override
    public String getSourceName() {
        return "<source>";
    }

    @Override
    public FxNode.Kind getKind() {
        return FxNode.Kind.Source;
    }

    @Override
    public void accept(FxNodeVisitor v) {
        v.visitSource(this);
    }

    @Override
    void detachChild(FxNode child) {
        if (child instanceof ImportDecl) {
            this.imports.add((ImportDecl)child);
        } else if (child instanceof LanguageDecl) {
            this.language = null;
        }
        super.detachChild(child);
    }

    void setNamedInstances(Map<String, ? extends FxInstance> instances) {
        this.namedInstances = instances;
    }

    @NonNull
    public Set<String> getInstanceNames() {
        return Collections.unmodifiableSet(this.namedInstances.keySet());
    }

    @CheckForNull
    public FxInstance getInstance(String id) {
        return this.namedInstances.get(id);
    }

    public String getController() {
        return this.controller;
    }

    void setController(String controller) {
        this.controller = controller;
    }

    public ElementHandle<TypeElement> getControllerType() {
        return this.controllerType;
    }

    void setControllerType(ElementHandle<TypeElement> controllerType) {
        this.controllerType = controllerType;
    }

    @Override
    void resolve(ElementHandle nameHandle, TypeMirrorHandle typeHandle, ElementHandle<TypeElement> sourceTypeHandle, FxDefinition info) {
        this.controllerType = nameHandle;
    }

    static {
        ModelAccessor.setInstance(new AccessorImpl());
    }

    private static final class AccessorImpl
    extends ModelAccessor {
        private AccessorImpl() {
        }

        @Override
        public FxModel newModel(URL baseURL, List<ImportDecl> imports, List<FxNewInstance> defs) {
            FxModel m = new FxModel(baseURL);
            m.setImports(imports);
            m.setDefinitions(defs);
            return m;
        }

        @Override
        public ImportDecl createImport(String imported, boolean wildcard) {
            return new ImportDecl(imported, wildcard);
        }

        @Override
        public LanguageDecl createLanguage(String lang) {
            return new LanguageDecl(lang);
        }

        @Override
        public FxInclude createInclude(String included, String id) {
            return (FxInclude)new FxInclude(included).withId(id);
        }

        @Override
        public FxScriptFragment createScript(String sourceRef) {
            return new FxScriptFragment(sourceRef);
        }

        @Override
        public FxNewInstance createCustomRoot(String sourceName, String id) {
            FxNewInstance n = new FxNewInstance(sourceName, true);
            n.withId(id);
            return n;
        }

        @Override
        public FxNewInstance createInstance(String sourceName, CharSequence value, boolean constant, String factory, String id) {
            FxNewInstance n = new FxNewInstance(sourceName);
            n.fromValue(value).usingFactory(factory).withId(id);
            n.setConstant(constant);
            return n;
        }

        @Override
        public FxObjectBase createCopyReference(boolean copy, String targetName) {
            return copy ? new FxInstanceCopy(targetName) : new FxReference(targetName);
        }

        @Override
        public PropertySetter createProperty(String name, boolean implicit) {
            PropertySetter s = new PropertySetter(name);
            if (implicit) {
                s = s.asImplicitDefault();
            }
            return s;
        }

        @Override
        public StaticProperty createStaticProperty(String name, String sourceClassName) {
            return new StaticProperty(sourceClassName, name);
        }

        @Override
        public MapProperty createMapProperty(String name, Map<String, CharSequence> values) {
            MapProperty m = new MapProperty(name);
            m.setValues(values);
            return m;
        }

        @Override
        public EventHandler createEventHandler(String eventName) {
            return new EventHandler(eventName);
        }

        @Override
        public FxNode createErrorElement(String localName) {
            return new Dummy(localName);
        }

        @Override
        public EventHandler asMethodRef(EventHandler h) {
            return h.asMethodRef();
        }

        @Override
        public void initModel(FxModel model, String controller, FxInstance rootInstance, LanguageDecl language) {
            model.setController(controller);
            model.setRootComponent(rootInstance);
            model.setLanguage(language);
        }

        @Override
        public void resolve(FxNode n, ElementHandle nameHandle, TypeMirrorHandle typeHandle, ElementHandle<TypeElement> sourceTypeHandle, FxDefinition info) {
            n.resolve(nameHandle, typeHandle, sourceTypeHandle, info);
        }

        @Override
        public void addContent(HasContent content, CharSequence additionalContent) {
            if (content instanceof EventHandler) {
                ((EventHandler)content).addContent(additionalContent);
            } else if (content instanceof PropertySetter) {
                ((PropertySetter)content).addContent(additionalContent);
            } else if (content instanceof FxScriptFragment) {
                ((FxScriptFragment)content).addContent(additionalContent);
            } else {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void addChild(FxNode parent, FxNode child) throws IllegalArgumentException {
            parent.addChild(child);
        }

        @Override
        public void resolveResource(HasResource decl, URL resolved) {
            if (decl instanceof FxInclude) {
                ((FxInclude)decl).resolveFile(resolved);
            } else if (decl instanceof FxScriptFragment) {
                ((FxScriptFragment)decl).resolveSource(resolved);
            }
        }

        @Override
        public NodeInfo i(FxNode n) {
            return n.i();
        }

        @Override
        public <T extends FxNode> T makeBroken(T n) {
            n.markError();
            return n;
        }

        @Override
        public void setNamedInstances(FxModel model, Map<String, FxInstance> instances) {
            model.setNamedInstances(instances);
        }

        @Override
        public void addDefinitions(FxModel model, Collection<FxNewInstance> definitions) {
            model.addDefinitions(definitions);
        }

        @Override
        public void resolveReference(FxObjectBase copyOrReference, FxInstance original) {
            if (copyOrReference instanceof FxInstanceCopy) {
                ((FxInstanceCopy)copyOrReference).resolveBlueprint(original);
            } else if (copyOrReference instanceof FxReference) {
                ((FxReference)copyOrReference).resolveTarget((FxNewInstance)original);
            } else if (copyOrReference instanceof FxInclude) {
                ((FxInclude)copyOrReference).resolveTarget((FxNewInstance)original);
            } else {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public FxNode createElement(String localName) {
            return new XmlNode(localName);
        }

        @Override
        public void attach(FxNode node, FxModel model) {
            node.setModel(model);
        }

        @Override
        public void rename(FxInstance instance, PropertyValue value, String newName) {
            instance.propertyRenamed(value);
        }
    }
}

