/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.internal.grammar.ScopeMetadata;
import org.eclipse.tm4e.core.theme.IThemeProvider;
import org.eclipse.tm4e.core.theme.ThemeTrieElementRule;

public class ScopeMetadataProvider {
    private static final ScopeMetadata _NULL_SCOPE_METADATA = new ScopeMetadata("", 0, 0, null);
    private static Pattern STANDARD_TOKEN_TYPE_REGEXP = Pattern.compile("\\b(comment|string|regex)\\b");
    private static final String COMMENT_TOKEN_TYPE = "comment";
    private static final String STRING_TOKEN_TYPE = "string";
    private static final String REGEX_TOKEN_TYPE = "regex";
    private final int _initialLanguage;
    private final IThemeProvider _themeProvider;
    private final Map<String, ScopeMetadata> _cache;
    private ScopeMetadata _defaultMetaData;
    private final Map<String, Integer> _embeddedLanguages;
    private Pattern _embeddedLanguagesRegex;

    public ScopeMetadataProvider(int initialLanguage, IThemeProvider themeProvider, Map<String, Integer> embeddedLanguages) {
        Set escapedScopes;
        this._initialLanguage = initialLanguage;
        this._themeProvider = themeProvider;
        this._cache = new HashMap<String, ScopeMetadata>();
        this.onDidChangeTheme();
        this._embeddedLanguages = new HashMap<String, Integer>();
        if (embeddedLanguages != null) {
            Set<Map.Entry<String, Integer>> languages = embeddedLanguages.entrySet();
            for (Map.Entry<String, Integer> language : languages) {
                String scope = language.getKey();
                int languageId = language.getValue();
                this._embeddedLanguages.put(scope, languageId);
            }
        }
        this._embeddedLanguagesRegex = (escapedScopes = this._embeddedLanguages.keySet().stream().map(scopeName -> ScopeMetadataProvider._escapeRegExpCharacters(scopeName)).collect(Collectors.toSet())).isEmpty() ? null : null;
    }

    public void onDidChangeTheme() {
        this._cache.clear();
        this._defaultMetaData = new ScopeMetadata("", this._initialLanguage, 0, Arrays.asList(this._themeProvider.getDefaults()));
    }

    public ScopeMetadata getDefaultMetadata() {
        return this._defaultMetaData;
    }

    private static String _escapeRegExpCharacters(String value) {
        return value;
    }

    public ScopeMetadata getMetadataForScope(String scopeName) {
        if (scopeName == null) {
            return _NULL_SCOPE_METADATA;
        }
        ScopeMetadata value = this._cache.get(scopeName);
        if (value != null) {
            return value;
        }
        value = this._doGetMetadataForScope(scopeName);
        this._cache.put(scopeName, value);
        return value;
    }

    private ScopeMetadata _doGetMetadataForScope(String scopeName) {
        int languageId = this._scopeToLanguage(scopeName);
        int standardTokenType = ScopeMetadataProvider._toStandardTokenType(scopeName);
        List<ThemeTrieElementRule> themeData = this._themeProvider.themeMatch(scopeName);
        return new ScopeMetadata(scopeName, languageId, standardTokenType, themeData);
    }

    private int _scopeToLanguage(String scope) {
        if (scope == null) {
            return 0;
        }
        if (this._embeddedLanguagesRegex == null) {
            return 0;
        }
        return 0;
    }

    private static int _toStandardTokenType(String tokenType) {
        Matcher m = STANDARD_TOKEN_TYPE_REGEXP.matcher(tokenType);
        if (!m.find()) {
            return 0;
        }
        String group = m.group();
        if (COMMENT_TOKEN_TYPE.equals(group)) {
            return 1;
        }
        if (STRING_TOKEN_TYPE.equals(group)) {
            return 2;
        }
        if (REGEX_TOKEN_TYPE.equals(group)) {
            return 4;
        }
        throw new TMException("Unexpected match for standard token type!");
    }
}

