/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.support;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ChannelInterceptorChain;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractMessageChannel
implements MessageChannel,
BeanNameAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ChannelInterceptorChain interceptorChain = new ChannelInterceptorChain();
    private String beanName = this.getClass().getSimpleName() + "@" + ObjectUtils.getIdentityHexString((Object)this);

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setInterceptors(List<ChannelInterceptor> interceptors) {
        this.interceptorChain.set(interceptors);
    }

    public void addInterceptor(ChannelInterceptor interceptor) {
        this.interceptorChain.add(interceptor);
    }

    public List<ChannelInterceptor> getInterceptors() {
        return this.interceptorChain.getInterceptors();
    }

    protected ChannelInterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Override
    public final boolean send(Message<?> message) {
        return this.send(message, -1L);
    }

    @Override
    public final boolean send(Message<?> message, long timeout) {
        Assert.notNull(message, (String)"Message must not be null");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("[" + this.beanName + "] sending message id=" + message.getHeaders().getId()));
        }
        if ((message = this.interceptorChain.preSend(message, this)) == null) {
            return false;
        }
        try {
            boolean sent = this.sendInternal(message, timeout);
            this.interceptorChain.postSend(message, this, sent);
            return sent;
        }
        catch (Exception e) {
            if (e instanceof MessagingException) {
                throw (MessagingException)e;
            }
            throw new MessageDeliveryException(message, "Failed to send message to channel '" + this.getBeanName() + "'", e);
        }
    }

    protected abstract boolean sendInternal(Message<?> var1, long var2);

    public String toString() {
        return "MessageChannel [name=" + this.beanName + "]";
    }
}

