/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.init;

import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.util.StringUtils;

public class ResourceDatabasePopulator
implements DatabasePopulator {
    private static final String DEFAULT_COMMENT_PREFIX = "--";
    private static final String DEFAULT_STATEMENT_SEPARATOR = ";";
    private static final Log logger = LogFactory.getLog(ResourceDatabasePopulator.class);
    private List<Resource> scripts = new ArrayList<Resource>();
    private String sqlScriptEncoding;
    private String separator;
    private String commentPrefix = "--";
    private boolean continueOnError = false;
    private boolean ignoreFailedDrops = false;

    public void addScript(Resource script) {
        this.scripts.add(script);
    }

    public void setScripts(Resource ... scripts) {
        this.scripts = Arrays.asList(scripts);
    }

    public void setSqlScriptEncoding(String sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setCommentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setIgnoreFailedDrops(boolean ignoreFailedDrops) {
        this.ignoreFailedDrops = ignoreFailedDrops;
    }

    @Override
    public void populate(Connection connection) throws SQLException {
        for (Resource script : this.scripts) {
            this.executeSqlScript(connection, this.applyEncodingIfNecessary(script), this.continueOnError, this.ignoreFailedDrops);
        }
    }

    private EncodedResource applyEncodingIfNecessary(Resource script) {
        if (script instanceof EncodedResource) {
            return (EncodedResource)script;
        }
        return new EncodedResource(script, this.sqlScriptEncoding);
    }

    /*
     * Exception decompiling
     */
    private void executeSqlScript(Connection connection, EncodedResource resource, boolean continueOnError, boolean ignoreFailedDrops) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readScript(EncodedResource resource) throws IOException {
        LineNumberReader lnr = new LineNumberReader(resource.getReader());
        try {
            String currentStatement = lnr.readLine();
            StringBuilder scriptBuilder = new StringBuilder();
            while (currentStatement != null) {
                if (StringUtils.hasText((String)currentStatement) && this.commentPrefix != null && !currentStatement.startsWith(this.commentPrefix)) {
                    if (scriptBuilder.length() > 0) {
                        scriptBuilder.append('\n');
                    }
                    scriptBuilder.append(currentStatement);
                }
                currentStatement = lnr.readLine();
            }
            this.maybeAddSeparatorToScript(scriptBuilder);
            String string = scriptBuilder.toString();
            return string;
        }
        finally {
            lnr.close();
        }
    }

    private void maybeAddSeparatorToScript(StringBuilder scriptBuilder) {
        if (this.separator == null) {
            return;
        }
        String trimmed = this.separator.trim();
        if (trimmed.length() == this.separator.length()) {
            return;
        }
        if (scriptBuilder.lastIndexOf(trimmed) == scriptBuilder.length() - trimmed.length()) {
            scriptBuilder.append(this.separator.substring(trimmed.length()));
        }
    }

    private boolean containsSqlScriptDelimiters(String script, String delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (inLiteral || !script.startsWith(delim, i)) continue;
            return true;
        }
        return false;
    }

    private void splitSqlScript(String script, String delim, String commentPrefix, List<String> statements) {
        StringBuilder sb = new StringBuilder();
        boolean inLiteral = false;
        boolean inEscape = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            int c = content[i];
            if (inEscape) {
                inEscape = false;
                sb.append((char)c);
                continue;
            }
            if (c == 92) {
                inEscape = true;
                sb.append((char)c);
                continue;
            }
            if (c == 39) {
                boolean bl = inLiteral = !inLiteral;
            }
            if (!inLiteral) {
                if (script.startsWith(delim, i)) {
                    if (sb.length() > 0) {
                        statements.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    i += delim.length() - 1;
                    continue;
                }
                if (script.startsWith(commentPrefix, i)) {
                    int indexOfNextNewline = script.indexOf("\n", i);
                    if (indexOfNextNewline <= i) break;
                    i = indexOfNextNewline;
                    continue;
                }
                if (c == 32 || c == 10 || c == 9) {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    c = 32;
                }
            }
            sb.append((char)c);
        }
        if (StringUtils.hasText((CharSequence)sb)) {
            statements.add(sb.toString());
        }
    }
}

