/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.classpath.AbstractBootPathImpl;
import org.netbeans.modules.maven.classpath.EndorsedClassPathImpl;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class BootClassPathImpl
extends AbstractBootPathImpl {
    private final EndorsedClassPathImpl ecpImpl;

    BootClassPathImpl(@NonNull NbMavenProjectImpl project, EndorsedClassPathImpl ecpImpl) {
        super(project);
        this.ecpImpl = ecpImpl;
        ecpImpl.setBCP(this);
        ecpImpl.addPropertyChangeListener(this);
    }

    @Override
    protected List<PathResourceImplementation> createResources() {
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        boolean[] includeJDK = new boolean[]{true};
        boolean[] includeFX = new boolean[]{false};
        result.addAll(this.ecpImpl.getResources(includeJDK, includeFX));
        this.lastHintValue = this.project.getAuxProps().get("netbeans.hint.jdkPlatform", true);
        if (includeJDK[0]) {
            PathResourceImplementation fxcp;
            JavaPlatform pat = this.findActivePlatform();
            boolean hasFx = false;
            for (ClassPath.Entry entry : pat.getBootstrapLibraries().entries()) {
                if (entry.getURL().getPath().endsWith("/jfxrt.jar!/")) {
                    hasFx = true;
                }
                result.add(ClassPathSupport.createResource((URL)entry.getURL()));
            }
            if (includeFX[0] && !hasFx && (fxcp = this.createFxCPImpl(pat)) != null) {
                result.add(fxcp);
            }
            result.addAll(this.nbPlatformJavaFxCp(this.project, pat));
        }
        return result;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String newVal = this.project.getAuxProps().get("netbeans.hint.jdkPlatform", true);
        if (evt.getSource() == this.project && evt.getPropertyName().equals("MavenProject")) {
            if (this.ecpImpl.resetCache()) {
                this.resetCache();
            } else if (newVal == null && this.lastHintValue != null || newVal != null && !newVal.equals(this.lastHintValue)) {
                this.resetCache();
            }
        } else if (evt.getSource() == this.ecpImpl) {
            this.resetCache();
        }
    }

    private Collection<? extends PathResourceImplementation> nbPlatformJavaFxCp(NbMavenProjectImpl project, JavaPlatform pat) {
        ArrayList<PathResourceImplementation> toRet = new ArrayList<PathResourceImplementation>();
        for (Artifact a : project.getOriginalMavenProject().getArtifacts()) {
            PathResourceImplementation fxcp;
            if (!"org.netbeans.api".equals(a.getGroupId()) || !"org-netbeans-libs-javafx".equals(a.getArtifactId()) || (fxcp = this.createFxCPImpl(pat)) == null) continue;
            toRet.add(fxcp);
        }
        return toRet;
    }

    private PathResourceImplementation createFxCPImpl(JavaPlatform pat) {
        for (FileObject fo : pat.getInstallFolders()) {
            FileObject jdk7;
            FileObject jdk8 = fo.getFileObject("jre/lib/ext/jfxrt.jar");
            if (jdk8 != null || (jdk7 = fo.getFileObject("jre/lib/jfxrt.jar")) == null || !FileUtil.isArchiveFile((FileObject)jdk7)) continue;
            return ClassPathSupport.createResource((URL)FileUtil.getArchiveRoot((URL)jdk7.toURL()));
        }
        return null;
    }
}

