/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.wizards;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.common.wizards.Util;
import org.openide.util.NbBundle;

public class Retriever
implements Runnable {
    private static final Logger LOGGER = PayaraLogger.get(Retriever.class);
    public static final int LOCATION_DOWNLOAD_TIMEOUT = 20000;
    public static final int LOCATION_TRIES = 3;
    public static final int ZIP_DOWNLOAD_TIMEOUT = 120000;
    public static final int STATUS_START = 0;
    public static final int STATUS_CONNECTING = 1;
    public static final int STATUS_DOWNLOADING = 2;
    public static final int STATUS_COMPLETE = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_TERMINATED = 5;
    public static final int STATUS_BAD_DOWNLOAD = 6;
    private static final TrustManager[] trustManager = new TrustManager[]{new RetrieverTrustManager()};
    private static final RetrieverHostnameVerifier hostnameVerifier = new RetrieverHostnameVerifier();
    private static final String[] STATUS_MESSAGE = new String[]{NbBundle.getMessage(Retriever.class, (String)"STATUS_Ready"), NbBundle.getMessage(Retriever.class, (String)"STATUS_Connecting"), NbBundle.getMessage(Retriever.class, (String)"STATUS_Downloading"), NbBundle.getMessage(Retriever.class, (String)"STATUS_Complete"), NbBundle.getMessage(Retriever.class, (String)"STATUS_Failed"), NbBundle.getMessage(Retriever.class, (String)"STATUS_Terminated"), NbBundle.getMessage(Retriever.class, (String)"STATUS_InvalidWsdl")};
    private Updater updater;
    private final String locationUrl;
    private final String targetUrlPrefix;
    private final String defaultTargetUrl;
    private File targetInstallDir;
    private String topLevelPrefix;
    private volatile boolean shutdown;
    private volatile int status;
    private static final int READ_BUF_SIZE = 131072;
    private static final int WRITE_BUF_SIZE = 131072;

    protected static void handleSecureConnection(HttpsURLConnection conn) {
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, trustManager, null);
            conn.setSSLSocketFactory(context.getSocketFactory());
            conn.setHostnameVerifier(hostnameVerifier);
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            LOGGER.log(Level.INFO, "Cannot handle HTTPS connection", ex);
        }
    }

    public Retriever(File installDir, String locationUrl, String urlPrefix, String defaultTargetUrl, Updater u, String topLevelPrefix) {
        this.targetInstallDir = installDir;
        this.locationUrl = locationUrl;
        this.targetUrlPrefix = urlPrefix;
        this.defaultTargetUrl = defaultTargetUrl;
        this.updater = u;
        this.topLevelPrefix = topLevelPrefix;
    }

    public void stopRetrieval() {
        this.shutdown = true;
    }

    public int getDownloadState() {
        return this.status;
    }

    private void setDownloadState(int newState) {
        this.setDownloadState(newState, true);
    }

    private void setDownloadState(int newState, boolean display) {
        this.status = newState;
        if (display) {
            this.updateMessage(STATUS_MESSAGE[newState]);
        }
    }

    private void setDownloadState(int newState, String msg, Exception ex) {
        this.status = newState;
        Object[] args = new Object[]{msg, ex.getMessage()};
        this.updateStatus(MessageFormat.format(STATUS_MESSAGE[newState], args));
    }

    private void updateMessage(String msg) {
        this.updater.updateMessageText(msg);
    }

    private void updateStatus(String status) {
        this.updater.updateStatusText(status);
    }

    private String countAsString(int c) {
        String size;
        if (c < 1024) {
            size = NbBundle.getMessage(Retriever.class, (String)"MSG_SizeBytes", (Object)c);
        } else if (c < 1048676) {
            size = NbBundle.getMessage(Retriever.class, (String)"MSG_SizeKb", (Object)(c / 1024));
        } else {
            int m = c / 1048676;
            int d = (c - m * 1048676) * 10 / 1048676;
            size = NbBundle.getMessage(Retriever.class, (String)"MSG_SizeMb", (Object)m, (Object)d);
        }
        return size;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getDownloadLocation() {
        String location = this.locationUrl;
        String result = this.defaultTargetUrl;
        int retries = 0;
        boolean run = true;
        while (run) {
            try {
                URL url = new URL(location);
                URLConnection conn = url.openConnection();
                if (conn instanceof HttpURLConnection) {
                    HttpURLConnection hconn = (HttpURLConnection)conn;
                    hconn.setConnectTimeout(20000);
                    hconn.setReadTimeout(20000);
                    hconn.setRequestMethod("HEAD");
                    if (hconn instanceof HttpsURLConnection) {
                        Retriever.handleSecureConnection((HttpsURLConnection)hconn);
                    }
                    hconn.connect();
                    int responseCode = hconn.getResponseCode();
                    LOGGER.log(Level.FINE, "URL Response code: {0} {1}", new String[]{Integer.toString(responseCode), hconn.getResponseMessage()});
                    switch (responseCode) {
                        case 301: 
                        case 302: {
                            location = hconn.getHeaderField("Location");
                            if (location == null || location.trim().isEmpty()) {
                                run = false;
                                break;
                            }
                            LOGGER.log(Level.FINE, "URL Redirrection: {0}", location);
                            run = retries++ < 3;
                            break;
                        }
                        case 200: {
                            int len = hconn.getContentLength();
                            if (len > 0) {
                                result = location;
                                LOGGER.log(Level.FINE, "New Payara Location: {0}", result);
                            }
                        }
                        default: {
                            run = false;
                            break;
                        }
                    }
                    continue;
                }
                LOGGER.log(Level.INFO, "Unexpected connection type: {0}", location);
            }
            catch (MalformedURLException mue) {
                LOGGER.log(Level.INFO, "Error opening URL connection", mue);
                run = false;
            }
            catch (IOException ioe) {
                LOGGER.log(Level.INFO, "Error reading from URL", ioe);
                run = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadAndInstall(InputStream in, File targetFolder, int filelen) throws IOException {
        BufferedInputStream bufferedStream = null;
        ZipInputStream jarStream = null;
        try {
            JarEntry entry;
            byte[] buffer = new byte[131072];
            bufferedStream = new BufferedInputStream(in, 131072);
            ZipInputStream entryStream = jarStream = new JarInputStream(bufferedStream);
            int totalBytesRead = 0;
            while (!this.shutdown && jarStream != null && (entry = (JarEntry)((JarInputStream)jarStream).getNextEntry()) != null) {
                String entryName = this.stripTopLevelDir(entry.getName());
                if (entryName == null || entryName.length() == 0) continue;
                File entryFile = new File(targetFolder, entryName);
                if (entryFile.exists()) {
                    throw new RuntimeException(NbBundle.getMessage(Retriever.class, (String)"ERR_TargetExists", (Object)entryFile.getPath()));
                }
                if (entry.isDirectory()) {
                    if (entryFile.mkdirs()) continue;
                    throw new RuntimeException(NbBundle.getMessage(Retriever.class, (String)"ERR_FolderCreationFailed", (Object)entryFile.getName()));
                }
                File parentFile = entryFile.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    throw new RuntimeException(NbBundle.getMessage(Retriever.class, (String)"ERR_FolderCreationFailed", (Object)parentFile.getName()));
                }
                int bytesRead = 0;
                FileOutputStream os = null;
                try {
                    int len;
                    os = new FileOutputStream(entryFile);
                    long lastUpdate = 1L;
                    while (!this.shutdown && (len = ((InputStream)entryStream).read(buffer)) >= 0) {
                        bytesRead += len;
                        long update = System.currentTimeMillis() / 333L;
                        if (update != lastUpdate) {
                            if (filelen < 1) {
                                this.updateMessage(NbBundle.getMessage(Retriever.class, (String)"MSG_Installing", (Object)entryName, (Object)this.countAsString(bytesRead)));
                            } else {
                                this.updateMessage(NbBundle.getMessage(Retriever.class, (String)"MSG_Installing2", (Object)entryName, (Object)this.countAsString(totalBytesRead), (Object)this.countAsString(filelen)));
                            }
                            lastUpdate = update;
                        }
                        os.write(buffer, 0, len);
                    }
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                totalBytesRead = (int)((long)totalBytesRead + entry.getCompressedSize());
            }
        }
        finally {
            if (bufferedStream != null) {
                try {
                    bufferedStream.close();
                }
                catch (IOException iOException) {}
            }
            if (jarStream != null) {
                try {
                    jarStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.shutdown;
    }

    private String stripTopLevelDir(String name) {
        int slashIndex;
        if (name.startsWith(this.topLevelPrefix) && (slashIndex = Retriever.slashIndexOf(name, this.topLevelPrefix.length())) >= 0) {
            name = name.substring(slashIndex + 1);
        }
        return name;
    }

    private static int slashIndexOf(String s, int offset) {
        int len = s.length();
        for (int i = offset; i < len; ++i) {
            char c = s.charAt(i);
            if (c != '/' && c != '\\') continue;
            return i;
        }
        return -1;
    }

    private File backupInstallDir(File installDir) throws IOException {
        if (installDir.exists()) {
            File parent = installDir.getParentFile();
            String tempName = installDir.getName();
            for (int i = 1; i < 100; ++i) {
                File target = new File(parent, tempName + i);
                if (target.exists()) continue;
                if (!installDir.renameTo(target)) {
                    throw new IOException(NbBundle.getMessage(Retriever.class, (String)(installDir.isDirectory() ? "ERR_FolderCreationFailed" : "ERR_FileCreationFailed"), (Object)installDir.getAbsolutePath()));
                }
                return target;
            }
            throw new IOException(NbBundle.getMessage(Retriever.class, (String)"ERR_TooManyBackups", (Object)installDir.getAbsolutePath()));
        }
        return null;
    }

    private void restoreInstallDir(File installDir, File backupDir) {
        if (installDir != null && installDir.exists()) {
            Util.deleteFolder(installDir);
        }
        if (backupDir != null && backupDir.exists()) {
            backupDir.renameTo(installDir);
        }
    }

    static String getDurationString(int time) {
        StringBuilder builder = new StringBuilder(100);
        if (time < 0) {
            builder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_ETERNITY"));
        } else if (time == 0) {
            builder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_NO_TIME"));
        } else {
            String separator = NbBundle.getMessage(Retriever.class, (String)"TIME_SEPARATOR");
            if (time >= 3600000) {
                int hours = time / 3600000;
                time %= 3600000;
                builder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_HOURS", (Object)hours));
            }
            if (time >= 60000) {
                if (builder.length() > 0) {
                    builder.append(separator);
                }
                int minutes = time / 60000;
                time %= 60000;
                builder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_MINUTES", (Object)minutes));
            }
            if (time >= 1000) {
                if (builder.length() > 0) {
                    builder.append(separator);
                }
                int seconds = (time + 500) / 1000;
                time %= 1000;
                if (seconds > 0) {
                    builder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_SECONDS", (Object)seconds));
                }
            } else if (time > 0 && builder.length() < 1) {
                builder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_MILISECONDS", (Object)time));
            }
        }
        return builder.toString();
    }

    public static interface Updater {
        public void updateMessageText(String var1);

        public void updateStatusText(String var1);

        public void clearCancelState();
    }

    private static class RetrieverHostnameVerifier
    implements HostnameVerifier {
        private RetrieverHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession ssls) {
            return true;
        }
    }

    private static class RetrieverTrustManager
    implements X509TrustManager {
        private RetrieverTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

