/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.ArrayList;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.codegen.CGSGenerator;
import org.netbeans.modules.php.editor.codegen.CGSInfo;
import org.netbeans.modules.php.editor.codegen.CodegenUtils;
import org.netbeans.modules.php.editor.codegen.MethodProperty;
import org.netbeans.modules.php.editor.codegen.Property;

public interface SinglePropertyMethodCreator<T extends Property> {
    public String create(T var1);

    public static final class SingleSetterCreator
    extends SinglePropertyMethodCreatorImpl {
        private static final String PARAM_TYPE = "${PARAM_TYPE}";
        private static final String FLUENT_SETTER = "${FluentSetter}";
        private static final String SETTER_TEMPLATE = "${MODIFIER}${FUNCTION_MODIFIER} function ${TEMPLATE_NAME}(${PARAM_TYPE}$$${PARAM_NAME}) {" + CGSGenerator.ASSIGNMENT_TEMPLATE + CGSGenerator.NEW_LINE + "${FluentSetter}" + "}" + CGSGenerator.NEW_LINE;
        private final FluentSetterReturnPartCreator fluentSetterCreator;

        public SingleSetterCreator(CGSInfo cgsInfo) {
            super(cgsInfo);
            this.fluentSetterCreator = new FluentSetterReturnPartCreator(cgsInfo.isFluentSetter());
        }

        @Override
        public String create(Property property) {
            StringBuilder setter = new StringBuilder();
            String name = property.getName();
            String paramName = this.cgsInfo.getHowToGenerate() == CGSGenerator.GenWay.WITHOUT_UNDERSCORE ? CodegenUtils.withoutUnderscore(name) : name;
            String type = property.getType();
            String methodName = this.getMethodName(property);
            setter.append(SETTER_TEMPLATE.replace("${TEMPLATE_NAME}", this.cgsInfo.getHowToGenerate().getSetterTemplate()).replace("${MODIFIER}", this.getAccessModifier()).replace("${FUNCTION_MODIFIER}", property.getFunctionModifier()).replace("${UNDERSCORED_METHOD_NAME}", name).replace("${ACCESSOR}", property.getAccessor()).replace("${PROPERTY}", property.getAccessedName()).replace(FLUENT_SETTER, this.fluentSetterCreator.create(property)).replace("${PARAM_NAME}", paramName).replace("${UpFirstLetterProperty}", methodName).replace("${UpFirstLetterPropertyWithoutUnderscore}", methodName).replace(PARAM_TYPE, type.isEmpty() ? type : property.getTypeForTemplate()));
            setter.append(CGSGenerator.NEW_LINE);
            return setter.toString();
        }

        private static final class FluentSetterReturnPartCreator {
            private final boolean isStatic;

            FluentSetterReturnPartCreator(boolean isStatic) {
                this.isStatic = isStatic;
            }

            public String create(Property property) {
                assert (property != null);
                return this.isStatic ? "return " + property.getFluentReturnAccessor() + ";" + CGSGenerator.NEW_LINE : "";
            }
        }
    }

    public static final class SingleGetterCreator
    extends SinglePropertyMethodCreatorImpl {
        private static final String RETURN_TYPE = "${returnType}";
        private static final String GETTER_TEMPLATE = "${MODIFIER}${FUNCTION_MODIFIER} function ${TEMPLATE_NAME}()${returnType} {" + CGSGenerator.NEW_LINE + "return " + "${ACCESSOR}" + "${PROPERTY}" + ";" + CGSGenerator.NEW_LINE + "}" + CGSGenerator.NEW_LINE;

        public SingleGetterCreator(CGSInfo cgsInfo) {
            super(cgsInfo);
        }

        @Override
        public String create(Property property) {
            StringBuilder getter = new StringBuilder();
            String methodName = this.getMethodName(property);
            String type = "";
            if (this.cgsInfo.getPhpVersion().compareTo((Enum)PhpVersion.PHP_70) >= 0) {
                type = property.getType();
            }
            getter.append(GETTER_TEMPLATE.replace("${TEMPLATE_NAME}", this.cgsInfo.getHowToGenerate().getGetterTemplate()).replace("${MODIFIER}", this.getAccessModifier()).replace("${FUNCTION_MODIFIER}", property.getFunctionModifier()).replace("${UNDERSCORED_METHOD_NAME}", property.getName()).replace("${ACCESSOR}", property.getAccessor()).replace("${PROPERTY}", property.getAccessedName()).replace("${UpFirstLetterProperty}", methodName).replace("${UpFirstLetterPropertyWithoutUnderscore}", methodName).replace(RETURN_TYPE, type.isEmpty() ? "" : ": " + property.getTypeForTemplate()));
            getter.append(CGSGenerator.NEW_LINE);
            return getter.toString();
        }
    }

    public static abstract class SinglePropertyMethodCreatorImpl
    implements SinglePropertyMethodCreator<Property> {
        protected static final String TEMPLATE_NAME = "${TEMPLATE_NAME}";
        protected static final String FUNCTION_MODIFIER = "${FUNCTION_MODIFIER}";
        protected final CGSInfo cgsInfo;

        public SinglePropertyMethodCreatorImpl(CGSInfo cgsInfo) {
            assert (cgsInfo != null);
            this.cgsInfo = cgsInfo;
        }

        @Override
        public abstract String create(Property var1);

        protected String getMethodName(Property property) {
            String changedName = this.cgsInfo.getHowToGenerate() == CGSGenerator.GenWay.WITHOUT_UNDERSCORE ? CodegenUtils.upFirstLetterWithoutUnderscore(property.getName()) : CodegenUtils.upFirstLetter(property.getName());
            return CodegenUtils.getUnusedMethodName(new ArrayList<String>(), changedName);
        }

        protected String getAccessModifier() {
            return this.cgsInfo.isPublicModifier() ? "public " : "";
        }
    }

    public static final class InheritedMethodCreator
    implements SinglePropertyMethodCreator<MethodProperty> {
        private final CGSInfo cgsInfo;

        public InheritedMethodCreator(CGSInfo cgsInfo) {
            assert (cgsInfo != null);
            this.cgsInfo = cgsInfo;
        }

        @Override
        public String create(MethodProperty property) {
            StringBuilder inheritedMethod = new StringBuilder();
            MethodElement method = property.getMethod();
            if (method.isAbstract() || method.isMagic() || method.getType().isInterface()) {
                inheritedMethod.append(method.asString(BaseFunctionElement.PrintAs.DeclarationWithEmptyBody, this.cgsInfo.createTypeNameResolver(method), this.cgsInfo.getPhpVersion()).replace("abstract ", ""));
            } else {
                inheritedMethod.append(method.asString(BaseFunctionElement.PrintAs.DeclarationWithParentCallInBody, this.cgsInfo.createTypeNameResolver(method), this.cgsInfo.getPhpVersion()).replace("abstract ", ""));
            }
            inheritedMethod.append(CGSGenerator.NEW_LINE);
            return inheritedMethod.toString();
        }
    }
}

