/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.jtreg;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.openjdk.common.ShortcutUtils;
import org.netbeans.modules.java.openjdk.jtreg.Utilities;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class ClassPathProviderImpl
implements ClassPathProvider {
    public ClassPath findClassPath(FileObject file, String type) {
        FileObject testProperties = null;
        for (FileObject search = file.getParent(); search != null; search = search.getParent()) {
            LinkedHashSet<FileObject> roots;
            block69: {
                Throwable ex2;
                FileObject testRoot;
                if (testProperties == null) {
                    testProperties = search.getFileObject("TEST.properties");
                }
                if ((testRoot = search.getFileObject("TEST.ROOT")) == null) continue;
                boolean javac = (Utilities.isLangtoolsRepository(search.getParent()) || search.getNameExt().equals("langtools")) && ShortcutUtils.getDefault().shouldUseCustomTest("langtools", FileUtil.getRelativePath((FileObject)search.getParent(), (FileObject)file));
                switch (type) {
                    case "classpath/compile": {
                        if (javac) {
                            ClassPath langtoolsCP = ClassPath.getClassPath((FileObject)Utilities.getLangtoolsKeyRoot(search.getParent()), (String)"classpath/compile");
                            Library testngLib = LibraryManager.getDefault().getLibrary("testng");
                            if (testngLib != null) {
                                return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPathSupport.createClassPath((URL[])testngLib.getContent("classpath").toArray(new URL[0])), langtoolsCP});
                            }
                            if (langtoolsCP == null) {
                                return ClassPath.EMPTY;
                            }
                            return langtoolsCP;
                        }
                        return null;
                    }
                    case "classpath/boot": {
                        if (javac) {
                            try {
                                ClassPath langtoolsBCP = ClassPath.getClassPath((FileObject)Utilities.getLangtoolsKeyRoot(search.getParent()), (String)"classpath/boot");
                                ArrayList<URL> roots2 = new ArrayList<URL>();
                                for (String rootPaths : new String[]{"build/classes/", "build/java.compiler/classes/", "build/jdk.compiler/classes/", "build/jdk.javadoc/classes/", "build/jdk.dev/classes/"}) {
                                    roots2.add(search.getParent().toURI().resolve(rootPaths).toURL());
                                }
                                return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPathSupport.createClassPath((URL[])roots2.toArray(new URL[roots2.size()])), langtoolsBCP});
                            }
                            catch (MalformedURLException ex2) {
                                Exceptions.printStackTrace((Throwable)ex2);
                            }
                        }
                        return null;
                    }
                    case "classpath/source": {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                roots = new LinkedHashSet<FileObject>();
                if (testProperties != null) {
                    roots.add(testProperties.getParent());
                    try {
                        ex2 = null;
                        try (InputStream in = testProperties.getInputStream();){
                            FileObject libDirsRoot;
                            Properties p = new Properties();
                            p.load(in);
                            String libDirsText = p.getProperty("lib.dirs");
                            FileObject fileObject = libDirsRoot = libDirsText != null ? this.resolve(testProperties, search, libDirsText) : null;
                            if (libDirsRoot != null) {
                                roots.add(libDirsRoot);
                            }
                        }
                        catch (Throwable p) {
                            ex2 = p;
                            throw p;
                        }
                    }
                    catch (IOException ex3) {
                        Exceptions.printStackTrace((Throwable)ex3);
                    }
                } else {
                    if (file.isFolder()) {
                        return null;
                    }
                    roots.add(file.getParent());
                    try {
                        ex2 = null;
                        try (InputStreamReader r = new InputStreamReader(file.getInputStream(), FileEncodingQuery.getEncoding((FileObject)file));){
                            int read;
                            StringBuilder content = new StringBuilder();
                            while ((read = ((Reader)r).read()) != -1) {
                                content.append((char)read);
                            }
                            Pattern library = Pattern.compile("@library (.*)\n");
                            Matcher m = library.matcher(content.toString());
                            if (!m.find()) break block69;
                            ArrayList<FileObject> libDirs = new ArrayList<FileObject>();
                            String[] stringArray = null;
                            try (InputStream in = testRoot.getInputStream();){
                                Properties p = new Properties();
                                p.load(in);
                                String externalLibRoots = p.getProperty("external.lib.roots");
                                if (externalLibRoots != null) {
                                    for (String extLib : externalLibRoots.split("\\s+")) {
                                        FileObject libDir = search.getFileObject(extLib);
                                        if (libDir == null) continue;
                                        libDirs.add(libDir);
                                    }
                                }
                            }
                            catch (Throwable object) {
                                stringArray = object;
                                throw object;
                            }
                            libDirs.add(search);
                            String libraryPaths = m.group(1).trim();
                            for (String libraryPath : libraryPaths.split(" ")) {
                                for (FileObject libDir : libDirs) {
                                    FileObject libFO = this.resolve(file, libDir, libraryPath);
                                    if (libFO == null) continue;
                                    roots.add(libFO);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            ex2 = throwable;
                            throw throwable;
                        }
                    }
                    catch (IOException ex4) {
                        Exceptions.printStackTrace((Throwable)ex4);
                    }
                }
            }
            for (FileObject root : roots) {
                this.initializeUsagesQuery(root);
            }
            return ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[0]));
        }
        return null;
    }

    private FileObject resolve(FileObject file, FileObject root, String spec) {
        if (spec.startsWith("/")) {
            return root.getFileObject(spec.substring(1));
        }
        return file.getParent().getFileObject(spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeUsagesQuery(FileObject root) {
        try {
            Object[] cietcCreateParams;
            Method cietcCreate;
            ClassLoader cl = JavaSource.class.getClassLoader();
            Class<?> transactionContextClass = Class.forName("org.netbeans.modules.java.source.indexing.TransactionContext", false, cl);
            Class<?> serviceClass = Class.forName("org.netbeans.modules.java.source.indexing.TransactionContext$Service", false, cl);
            Method beginTrans = transactionContextClass.getDeclaredMethod("beginTrans", new Class[0]);
            Method commit = transactionContextClass.getDeclaredMethod("commit", new Class[0]);
            Method register = transactionContextClass.getDeclaredMethod("register", Class.class, serviceClass);
            Class<?> classIndexEventsTransactionClass = Class.forName("org.netbeans.modules.java.source.usages.ClassIndexEventsTransaction", false, cl);
            try {
                cietcCreate = classIndexEventsTransactionClass.getDeclaredMethod("create", Boolean.TYPE);
                cietcCreateParams = new Object[]{true};
            }
            catch (NoSuchMethodException ex) {
                cietcCreate = classIndexEventsTransactionClass.getDeclaredMethod("create", Boolean.TYPE, Supplier.class);
                cietcCreateParams = new Object[]{true, () -> true};
            }
            Class<?> classIndexManagerClass = Class.forName("org.netbeans.modules.java.source.usages.ClassIndexManager", false, cl);
            Method cimcGetDefault = classIndexManagerClass.getDeclaredMethod("getDefault", new Class[0]);
            Method createUsagesQuery = classIndexManagerClass.getDeclaredMethod("createUsagesQuery", URL.class, Boolean.TYPE);
            Class<?> classIndexImplClass = Class.forName("org.netbeans.modules.java.source.usages.ClassIndexImpl", false, cl);
            Class<?> stateClass = Class.forName("org.netbeans.modules.java.source.usages.ClassIndexImpl$State", false, cl);
            Method setState = classIndexImplClass.getDeclaredMethod("setState", stateClass);
            Field initialized = stateClass.getDeclaredField("INITIALIZED");
            Object transaction = beginTrans.invoke(null, new Object[0]);
            register.invoke(transaction, classIndexEventsTransactionClass, cietcCreate.invoke(null, cietcCreateParams));
            try {
                Object classIndexImpl = createUsagesQuery.invoke(cimcGetDefault.invoke(null, new Object[0]), root.toURL(), true);
                setState.invoke(classIndexImpl, initialized.get(null));
            }
            finally {
                commit.invoke(transaction, new Object[0]);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

