/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.semantic;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UsesTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.java.editor.base.imports.UnusedImports;
import org.netbeans.modules.java.editor.base.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.base.semantic.TokenList;
import org.netbeans.modules.java.editor.base.semantic.Utilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class SemanticHighlighterBase
extends JavaParserResultTask {
    private AtomicBoolean cancel = new AtomicBoolean();
    private static final Set<String> SERIALIZABLE_SIGNATURES = new HashSet<String>(Arrays.asList("writeObject(Ljava/io/ObjectOutputStream;)V", "readObject(Ljava/io/ObjectInputStream;)V", "readResolve()Ljava/lang/Object;", "writeReplace()Ljava/lang/Object;", "readObjectNoData()V"));
    private static Field signatureAccessField;

    protected SemanticHighlighterBase() {
        super(JavaSource.Phase.RESOLVED, TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        CompilationInfo info = CompilationInfo.get((Parser.Result)result);
        if (info == null) {
            return;
        }
        this.cancel.set(false);
        Document doc = result.getSnapshot().getSource().getDocument(false);
        if (!SemanticHighlighterBase.verifyDocument(doc)) {
            return;
        }
        this.process(info, doc);
    }

    private static boolean verifyDocument(final Document doc) {
        if (doc == null) {
            Logger.getLogger(SemanticHighlighterBase.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return false;
        }
        final boolean[] tokenSequenceNull = new boolean[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                tokenSequenceNull[0] = TokenHierarchy.get((Document)doc).tokenSequence() == null;
            }
        });
        return !tokenSequenceNull[0];
    }

    public void cancel() {
        this.cancel.set(true);
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    protected abstract boolean process(CompilationInfo var1, Document var2);

    private static boolean isInSerializableOrExternalizable(CompilationInfo info, Element e) {
        Element encl = e.getEnclosingElement();
        if (encl == null || !encl.getKind().isClass()) {
            return true;
        }
        TypeMirror m = encl.asType();
        if (m == null || m.getKind() != TypeKind.DECLARED) {
            return true;
        }
        TypeElement serEl = info.getElements().getTypeElement("java.io.Serializable");
        TypeElement extEl = info.getElements().getTypeElement("java.io.Externalizable");
        if (serEl == null || extEl == null) {
            return true;
        }
        if (info.getTypes().isSubtype(m, serEl.asType())) {
            return true;
        }
        return info.getTypes().isSubtype(m, extEl.asType());
    }

    private static String _getSignatureHack(ElementHandle<ExecutableElement> eh) {
        try {
            String[] signs;
            if (signatureAccessField == null) {
                try {
                    Field f = ElementHandle.class.getDeclaredField("signatures");
                    f.setAccessible(true);
                    signatureAccessField = f;
                }
                catch (NoSuchFieldException | SecurityException ex) {
                    return "";
                }
            }
            if ((signs = (String[])signatureAccessField.get(eh)) == null || signs.length != 3) {
                return "";
            }
            return signs[1] + signs[2];
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            return "";
        }
    }

    private boolean isSerializationMethod(CompilationInfo info, ExecutableElement method) {
        if (!SemanticHighlighterBase.isInSerializableOrExternalizable(info, method)) {
            return false;
        }
        ElementHandle eh = ElementHandle.create((Element)method);
        String sign = SemanticHighlighterBase._getSignatureHack((ElementHandle<ExecutableElement>)eh);
        return SERIALIZABLE_SIGNATURES.contains(sign);
    }

    protected boolean process(CompilationInfo info, Document doc, ErrorDescriptionSetter setter) {
        ArrayList<int[]> imports;
        DetectorVisitor v = new DetectorVisitor(info, doc, this.cancel);
        IdentityHashMap<Token, ColoringAttributes.Coloring> newColoring = new IdentityHashMap<Token, ColoringAttributes.Coloring>();
        CompilationUnitTree cu = info.getCompilationUnit();
        v.scan(cu, null);
        if (this.cancel.get()) {
            return true;
        }
        boolean computeUnusedImports = "text/x-java".equals(FileUtil.getMIMEType((FileObject)info.getFileObject()));
        ArrayList<int[]> arrayList = imports = computeUnusedImports ? new ArrayList<int[]>() : null;
        if (computeUnusedImports) {
            Collection<TreePath> unusedImports = UnusedImports.process(info, this.cancel);
            if (unusedImports == null) {
                return true;
            }
            for (TreePath tree : unusedImports) {
                if (this.cancel.get()) {
                    return true;
                }
                imports.add(new int[]{(int)info.getTrees().getSourcePositions().getStartPosition(cu, tree.getLeaf()), (int)info.getTrees().getSourcePositions().getEndPosition(cu, tree.getLeaf())});
            }
        }
        for (Element decl : v.type2Uses.keySet()) {
            if (this.cancel.get()) {
                return true;
            }
            List uses = (List)v.type2Uses.get(decl);
            for (Use u : uses) {
                if (u.spec == null) continue;
                if (u.type.contains((Object)UseTypes.DECLARATION) && Utilities.isPrivateElement(decl)) {
                    if ((decl.getKind().isField() && !SemanticHighlighterBase.isSerialSpecField(info, decl) || SemanticHighlighterBase.isLocalVariableClosure(decl)) && !this.hasAllTypes(uses, EnumSet.of(UseTypes.READ, UseTypes.WRITE))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                    if (!((decl.getKind() != ElementKind.CONSTRUCTOR || decl.getModifiers().contains((Object)Modifier.PRIVATE)) && decl.getKind() != ElementKind.METHOD || this.hasAllTypes(uses, EnumSet.of(UseTypes.EXECUTE)) || this.isSerializationMethod(info, (ExecutableElement)decl))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                    if ((decl.getKind().isClass() || decl.getKind().isInterface()) && !this.hasAllTypes(uses, EnumSet.of(UseTypes.CLASS_USE))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                }
                ColoringAttributes.Coloring c = SemanticHighlighterBase.collection2Coloring(u.spec);
                List tl = (List)v.tree2Tokens.get(u.tree.getLeaf());
                if (tl == null) continue;
                for (Token t : tl) {
                    newColoring.put(t, c);
                }
            }
        }
        ColoringAttributes.Coloring kwc = SemanticHighlighterBase.collection2Coloring(EnumSet.of(ColoringAttributes.KEYWORD));
        for (Token kw : v.contextKeywords) {
            newColoring.put(kw, kwc);
        }
        if (this.cancel.get()) {
            return true;
        }
        if (computeUnusedImports) {
            setter.setHighlights(doc, imports, v.preText);
        }
        setter.setColorings(doc, newColoring);
        return false;
    }

    private boolean hasAllTypes(List<Use> uses, Collection<UseTypes> types) {
        EnumSet<UseTypes> e = EnumSet.copyOf(types);
        for (Use u : uses) {
            if (types.isEmpty()) {
                return true;
            }
            types.removeAll(u.type);
        }
        return types.isEmpty();
    }

    private static ColoringAttributes.Coloring collection2Coloring(Collection<ColoringAttributes> attr) {
        ColoringAttributes.Coloring c = ColoringAttributes.empty();
        for (ColoringAttributes a : attr) {
            c = ColoringAttributes.add(c, a);
        }
        return c;
    }

    private static boolean isLocalVariableClosure(Element el) {
        return el.getKind() == ElementKind.PARAMETER || el.getKind() == ElementKind.LOCAL_VARIABLE || el.getKind() == ElementKind.RESOURCE_VARIABLE || el.getKind() == ElementKind.EXCEPTION_PARAMETER;
    }

    private static boolean isSerialSpecField(CompilationInfo info, Element el) {
        if (el.getModifiers().contains((Object)Modifier.FINAL) && el.getModifiers().contains((Object)Modifier.STATIC)) {
            if (!SemanticHighlighterBase.isInSerializableOrExternalizable(info, el)) {
                return false;
            }
            if (info.getTypes().getPrimitiveType(TypeKind.LONG).equals(el.asType()) && el.getSimpleName().toString().equals("serialVersionUID")) {
                return true;
            }
            if (el.getSimpleName().contentEquals("serialPersistentFields")) {
                return true;
            }
        }
        return false;
    }

    public static interface ErrorDescriptionSetter {
        public void setHighlights(Document var1, Collection<int[]> var2, Map<int[], String> var3);

        public void setColorings(Document var1, Map<Token, ColoringAttributes.Coloring> var2);
    }

    private static class DetectorVisitor
    extends CancellableTreePathScanner<Void, Void> {
        private CompilationInfo info;
        private Document doc;
        private Map<Element, List<Use>> type2Uses;
        private Map<Tree, List<Token>> tree2Tokens;
        private List<Token> contextKeywords;
        private Map<int[], String> preText;
        private TokenList tl;
        private long memberSelectBypass = -1L;
        private SourcePositions sourcePositions;
        private ExecutableElement recursionDetector;
        private static final Set<Tree.Kind> LITERALS = EnumSet.of(Tree.Kind.BOOLEAN_LITERAL, new Tree.Kind[]{Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.STRING_LITERAL});

        private DetectorVisitor(CompilationInfo info, Document doc, AtomicBoolean cancel) {
            super(cancel);
            this.info = info;
            this.doc = doc;
            this.type2Uses = new HashMap<Element, List<Use>>();
            this.tree2Tokens = new IdentityHashMap<Tree, List<Token>>();
            this.contextKeywords = new ArrayList<Token>();
            this.preText = new HashMap<int[], String>();
            this.tl = new TokenList(info, doc, cancel);
            this.sourcePositions = info.getTrees().getSourcePositions();
        }

        private void firstIdentifier(String name) {
            this.tl.firstIdentifier(this.getCurrentPath(), name, this.tree2Tokens);
        }

        private Token firstIdentifierToken(String ... names) {
            for (String name : names) {
                Token t = this.tl.firstIdentifier(this.getCurrentPath(), name);
                if (t == null) continue;
                return t;
            }
            return null;
        }

        public Void visitMemberSelect(MemberSelectTree tree, Void p) {
            long memberSelectBypassLoc = this.memberSelectBypass;
            this.memberSelectBypass = -1L;
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null && el.getKind() == ElementKind.MODULE) {
                this.handlePossibleIdentifier(this.getCurrentPath(), false);
                this.tl.moduleNameHere(tree, this.tree2Tokens);
                return null;
            }
            super.visitMemberSelect(tree, (Object)p);
            this.tl.moveToEnd(tree.getExpression());
            if (memberSelectBypassLoc != -1L) {
                this.tl.moveToOffset(memberSelectBypassLoc);
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), false);
            this.firstIdentifier(tree.getIdentifier().toString());
            return null;
        }

        private void addModifiers(Element decl, Collection<ColoringAttributes> c) {
            if (decl.getModifiers().contains((Object)Modifier.STATIC)) {
                c.add(ColoringAttributes.STATIC);
            }
            if (decl.getModifiers().contains((Object)Modifier.ABSTRACT) && !decl.getKind().isInterface()) {
                c.add(ColoringAttributes.ABSTRACT);
            }
            boolean accessModifier = false;
            if (decl.getModifiers().contains((Object)Modifier.PUBLIC)) {
                c.add(ColoringAttributes.PUBLIC);
                accessModifier = true;
            }
            if (decl.getModifiers().contains((Object)Modifier.PROTECTED)) {
                c.add(ColoringAttributes.PROTECTED);
                accessModifier = true;
            }
            if (decl.getModifiers().contains((Object)Modifier.PRIVATE)) {
                c.add(ColoringAttributes.PRIVATE);
                accessModifier = true;
            }
            if (!accessModifier && !SemanticHighlighterBase.isLocalVariableClosure(decl)) {
                c.add(ColoringAttributes.PACKAGE_PRIVATE);
            }
            if (this.info.getElements().isDeprecated(decl)) {
                c.add(ColoringAttributes.DEPRECATED);
            }
        }

        private Collection<ColoringAttributes> getMethodColoring(ExecutableElement mdecl) {
            ArrayList<ColoringAttributes> c = new ArrayList<ColoringAttributes>();
            this.addModifiers(mdecl, c);
            if (mdecl.getKind() == ElementKind.CONSTRUCTOR) {
                c.add(ColoringAttributes.CONSTRUCTOR);
            } else {
                c.add(ColoringAttributes.METHOD);
            }
            return c;
        }

        private Collection<ColoringAttributes> getVariableColoring(Element decl) {
            ArrayList<ColoringAttributes> c = new ArrayList<ColoringAttributes>();
            this.addModifiers(decl, c);
            if (decl.getKind().isField()) {
                c.add(ColoringAttributes.FIELD);
                return c;
            }
            if (decl.getKind() == ElementKind.LOCAL_VARIABLE || decl.getKind() == ElementKind.RESOURCE_VARIABLE || decl.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                c.add(ColoringAttributes.LOCAL_VARIABLE);
                return c;
            }
            if (decl.getKind() == ElementKind.PARAMETER) {
                c.add(ColoringAttributes.PARAMETER);
                return c;
            }
            assert (false);
            return null;
        }

        private void handlePossibleIdentifier(TreePath expr, boolean declaration) {
            this.handlePossibleIdentifier(expr, declaration, null);
        }

        private void handlePossibleIdentifier(TreePath expr, boolean declaration, Element decl) {
            if (Utilities.isKeyword(expr.getLeaf())) {
                return;
            }
            if (expr.getLeaf().getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                return;
            }
            if (LITERALS.contains((Object)expr.getLeaf().getKind())) {
                return;
            }
            decl = decl == null ? this.info.getTrees().getElement(expr) : decl;
            ElementKind declKind = decl != null ? decl.getKind() : null;
            boolean isDeclType = decl != null && (declKind.isClass() || declKind.isInterface());
            TreePath currentPath = this.getCurrentPath();
            TreePath parent = currentPath.getParentPath();
            if (isDeclType && parent.getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                decl = this.info.getTrees().getElement(parent);
            }
            if (isDeclType && parent.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE && ((ParameterizedTypeTree)parent.getLeaf()).getType() == currentPath.getLeaf() && parent.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS) {
                decl = this.info.getTrees().getElement(parent.getParentPath());
            }
            if (decl == null) {
                return;
            }
            isDeclType = decl.getKind().isClass() || decl.getKind().isInterface();
            Collection<ColoringAttributes> c = null;
            if (decl.getKind().isField() || SemanticHighlighterBase.isLocalVariableClosure(decl)) {
                c = this.getVariableColoring(decl);
            }
            if (decl instanceof ExecutableElement) {
                c = this.getMethodColoring((ExecutableElement)decl);
            }
            if (decl.getKind() == ElementKind.MODULE) {
                c = new ArrayList<ColoringAttributes>();
                c.add(ColoringAttributes.MODULE);
            }
            if (isDeclType) {
                c = new ArrayList<ColoringAttributes>();
                this.addModifiers(decl, c);
                switch (decl.getKind()) {
                    case CLASS: {
                        c.add(ColoringAttributes.CLASS);
                        break;
                    }
                    case INTERFACE: {
                        c.add(ColoringAttributes.INTERFACE);
                        break;
                    }
                    case ANNOTATION_TYPE: {
                        c.add(ColoringAttributes.ANNOTATION_TYPE);
                        break;
                    }
                    case ENUM: {
                        c.add(ColoringAttributes.ENUM);
                    }
                }
            }
            if (declaration) {
                if (c == null) {
                    c = new ArrayList<ColoringAttributes>();
                }
                c.add(ColoringAttributes.DECLARATION);
            }
            if (c != null) {
                EnumSet<UseTypes> type = EnumSet.noneOf(UseTypes.class);
                if (isDeclType) {
                    if (!declaration) {
                        type.add(UseTypes.CLASS_USE);
                    }
                } else if (decl.getKind().isField() || SemanticHighlighterBase.isLocalVariableClosure(decl)) {
                    if (!declaration) {
                        while (true) {
                            if (parent.getLeaf().getKind() == Tree.Kind.POSTFIX_DECREMENT || parent.getLeaf().getKind() == Tree.Kind.POSTFIX_INCREMENT || parent.getLeaf().getKind() == Tree.Kind.PREFIX_DECREMENT || parent.getLeaf().getKind() == Tree.Kind.PREFIX_INCREMENT) {
                                type.add(UseTypes.WRITE);
                                currentPath = parent;
                                parent = currentPath.getParentPath();
                                continue;
                            }
                            if (!CompoundAssignmentTree.class.isAssignableFrom(parent.getLeaf().getKind().asInterface()) || ((CompoundAssignmentTree)parent.getLeaf()).getVariable() != currentPath.getLeaf()) break;
                            type.add(UseTypes.WRITE);
                            currentPath = parent;
                            parent = currentPath.getParentPath();
                        }
                        if (parent.getLeaf().getKind() == Tree.Kind.ASSIGNMENT && ((AssignmentTree)parent.getLeaf()).getVariable() == currentPath.getLeaf()) {
                            type.add(UseTypes.WRITE);
                        } else if (parent.getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
                            type.add(UseTypes.READ);
                        }
                    } else if (decl.getKind() == ElementKind.PARAMETER) {
                        Element method = decl.getEnclosingElement();
                        type.add(UseTypes.WRITE);
                        if (!(parent.getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION && ((LambdaExpressionTree)parent.getLeaf()).getParameters().contains(currentPath.getLeaf()) || !method.getModifiers().contains((Object)Modifier.ABSTRACT) && !method.getModifiers().contains((Object)Modifier.NATIVE) && method.getModifiers().contains((Object)Modifier.PRIVATE))) {
                            type.add(UseTypes.READ);
                        }
                    } else if (decl.getKind().isField() || decl.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                        type.add(UseTypes.WRITE);
                    } else if (parent.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP && ((EnhancedForLoopTree)parent.getLeaf()).getVariable() == currentPath.getLeaf()) {
                        type.add(UseTypes.WRITE);
                    } else {
                        VariableTree vt = (VariableTree)currentPath.getLeaf();
                        if (vt.getInitializer() != null) {
                            type.add(UseTypes.WRITE);
                        }
                    }
                } else if (decl.getKind() == ElementKind.METHOD) {
                    if (!declaration) {
                        type.add(UseTypes.EXECUTE);
                    }
                } else if (decl.getKind() == ElementKind.CONSTRUCTOR && !declaration) {
                    if (this.info.getElements().isDeprecated(decl.getEnclosingElement())) {
                        c.add(ColoringAttributes.DEPRECATED);
                    }
                    type.add(UseTypes.EXECUTE);
                }
                if (declaration) {
                    type.add(UseTypes.DECLARATION);
                }
                this.addUse(decl, type, expr, c);
            }
        }

        private void addUse(Element decl, Collection<UseTypes> useTypes, TreePath t, Collection<ColoringAttributes> c) {
            List<Use> uses;
            if (decl == this.recursionDetector) {
                useTypes.remove((Object)UseTypes.EXECUTE);
            }
            if ((uses = this.type2Uses.get(decl)) == null) {
                uses = new ArrayList<Use>();
                this.type2Uses.put(decl, uses);
            }
            Use u = new Use(useTypes, t, c);
            uses.add(u);
        }

        public Void visitCompilationUnit(CompilationUnitTree tree, Void p) {
            this.tl.moveBefore(tree.getImports());
            this.scan(tree.getImports(), p);
            this.tl.moveBefore(tree.getPackageAnnotations());
            this.scan(tree.getPackageAnnotations(), p);
            this.tl.moveToEnd(tree.getImports());
            this.scan(tree.getTypeDecls(), p);
            return null;
        }

        public Void visitModule(ModuleTree tree, Void p) {
            Element e;
            Token t;
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            this.scan(tree.getAnnotations(), p);
            this.tl.moveToEnd(tree.getAnnotations());
            if (tree.getModuleType() == ModuleTree.ModuleKind.OPEN) {
                t = this.firstIdentifierToken("open");
                if (t != null) {
                    this.contextKeywords.add(t);
                }
                this.tl.moveNext();
            }
            if ((t = this.firstIdentifierToken("module")) != null) {
                this.contextKeywords.add(t);
            }
            if ((e = this.info.getTrees().getElement(this.getCurrentPath())) != null && e.getKind() == ElementKind.MODULE) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getName()), true, e);
                this.tl.moduleNameHere(tree.getName(), this.tree2Tokens);
            }
            this.scan(tree.getDirectives(), p);
            return null;
        }

        public Void visitExports(ExportsTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            Token t = this.firstIdentifierToken("exports");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            this.scan(tree.getPackageName(), p);
            this.tl.moveToOffset(this.sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree.getPackageName()));
            t = this.firstIdentifierToken("to");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            return (Void)this.scan(tree.getModuleNames(), p);
        }

        public Void visitOpens(OpensTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            Token t = this.firstIdentifierToken("opens");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            this.scan(tree.getPackageName(), p);
            this.tl.moveToOffset(this.sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree.getPackageName()));
            t = this.firstIdentifierToken("to");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            return (Void)this.scan(tree.getModuleNames(), p);
        }

        public Void visitProvides(ProvidesTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            Token t = this.firstIdentifierToken("provides");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            this.scan(tree.getServiceName(), p);
            this.tl.moveToOffset(this.sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree.getServiceName()));
            t = this.firstIdentifierToken("with");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            return (Void)this.scan(tree.getImplementationNames(), p);
        }

        public Void visitRequires(RequiresTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            Token t = this.firstIdentifierToken("requires");
            if (t != null) {
                this.contextKeywords.add(t);
                this.tl.moveNext();
                if (tree.isStatic() && tree.isTransitive()) {
                    t = this.firstIdentifierToken("static", "transitive");
                    if (t != null) {
                        this.contextKeywords.add(t);
                    }
                    this.tl.moveNext();
                    t = this.firstIdentifierToken("static", "transitive");
                    if (t != null) {
                        this.contextKeywords.add(t);
                    }
                } else if (tree.isStatic()) {
                    t = this.firstIdentifierToken("static");
                    if (t != null) {
                        this.contextKeywords.add(t);
                    }
                } else if (tree.isTransitive() && (t = this.firstIdentifierToken("transitive")) != null) {
                    this.contextKeywords.add(t);
                }
            }
            return (Void)super.visitRequires(tree, (Object)p);
        }

        public Void visitUses(UsesTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            Token t = this.firstIdentifierToken("uses");
            if (t != null) {
                this.contextKeywords.add(t);
            }
            return (Void)super.visitUses(tree, (Object)p);
        }

        public Void visitMethodInvocation(MethodInvocationTree tree, Void p) {
            List<? extends Tree> ta;
            String ident;
            ExpressionTree possibleIdent = tree.getMethodSelect();
            if (possibleIdent.getKind() == Tree.Kind.IDENTIFIER && ("super".equals(ident = ((IdentifierTree)possibleIdent).getName().toString()) || "this".equals(ident))) {
                Element resolved = this.info.getTrees().getElement(this.getCurrentPath());
                this.addUse(resolved, EnumSet.of(UseTypes.EXECUTE), null, null);
            }
            long afterTypeArguments = (ta = tree.getTypeArguments()).isEmpty() ? -1L : this.info.getTrees().getSourcePositions().getEndPosition(this.info.getCompilationUnit(), ta.get(ta.size() - 1));
            switch (tree.getMethodSelect().getKind()) {
                case IDENTIFIER: 
                case MEMBER_SELECT: {
                    this.memberSelectBypass = afterTypeArguments;
                    this.scan(tree.getMethodSelect(), p);
                    this.memberSelectBypass = -1L;
                    break;
                }
                default: {
                    this.scan(tree.getMethodSelect(), p);
                }
            }
            this.tl.moveBefore(tree.getTypeArguments());
            this.scan(tree.getTypeArguments(), null);
            this.scan(tree.getArguments(), p);
            return null;
        }

        public Void visitIdentifier(IdentifierTree tree, Void p) {
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return null;
            }
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            if (this.memberSelectBypass != -1L) {
                this.tl.moveToOffset(this.memberSelectBypass);
                this.memberSelectBypass = -1L;
            }
            this.tl.identifierHere(tree, this.tree2Tokens);
            this.handlePossibleIdentifier(this.getCurrentPath(), false);
            super.visitIdentifier(tree, null);
            return null;
        }

        public Void visitMethod(MethodTree tree, Void p) {
            String name;
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return (Void)super.visitMethod(tree, (Object)p);
            }
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            this.handlePossibleIdentifier(this.getCurrentPath(), true);
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            this.scan(tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            this.scan(tree.getTypeParameters(), null);
            this.tl.moveToEnd(tree.getTypeParameters());
            this.scan(tree.getReturnType(), p);
            this.tl.moveToEnd(tree.getReturnType());
            if (tree.getReturnType() != null) {
                name = tree.getName().toString();
            } else {
                TreePath tp;
                for (tp = this.getCurrentPath(); tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()); tp = tp.getParentPath()) {
                }
                name = tp != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()) ? ((ClassTree)tp.getLeaf()).getSimpleName().toString() : null;
            }
            if (name != null) {
                this.firstIdentifier(name);
            }
            this.scan(tree.getParameters(), null);
            this.scan(tree.getThrows(), null);
            this.scan(tree.getDefaultValue(), null);
            this.recursionDetector = el != null && el.getKind() == ElementKind.METHOD ? (ExecutableElement)el : null;
            this.scan(tree.getBody(), null);
            this.recursionDetector = null;
            return null;
        }

        public Void visitVariable(VariableTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            this.handlePossibleIdentifier(this.getCurrentPath(), true);
            this.scan(tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            this.scan(tree.getType(), null);
            int[] span = this.info.getTreeUtilities().findNameSpan(tree);
            if (span != null) {
                this.tl.moveToOffset(span[0]);
            } else {
                this.tl.moveToEnd(tree.getType());
            }
            this.firstIdentifier(tree.getName().toString());
            this.tl.moveNext();
            this.scan(tree.getInitializer(), p);
            return null;
        }

        public Void visitNewClass(NewClassTree tree, Void p) {
            ExpressionTree ident = tree.getIdentifier();
            TreePath tp = ident.getKind() == Tree.Kind.PARAMETERIZED_TYPE ? new TreePath(new TreePath(this.getCurrentPath(), ident), ((ParameterizedTypeTree)((Object)ident)).getType()) : new TreePath(this.getCurrentPath(), ident);
            Element clazz = this.info.getTrees().getElement(tp);
            if (clazz != null) {
                this.addUse(clazz, EnumSet.of(UseTypes.CLASS_USE), null, null);
            }
            this.scan(tree.getEnclosingExpression(), null);
            this.scan(tree.getIdentifier(), null);
            this.scan(tree.getTypeArguments(), null);
            this.scan(tree.getArguments(), p);
            this.scan(tree.getClassBody(), null);
            return null;
        }

        public Void visitClass(ClassTree tree, Void p) {
            this.tl.moveToOffset(this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree));
            this.handlePossibleIdentifier(this.getCurrentPath(), true);
            this.scan(tree.getModifiers(), null);
            this.tl.moveToEnd(tree.getModifiers());
            this.firstIdentifier(tree.getSimpleName().toString());
            this.scan(tree.getTypeParameters(), null);
            this.scan(tree.getExtendsClause(), null);
            this.scan(tree.getImplementsClause(), null);
            ExecutableElement prevRecursionDetector = this.recursionDetector;
            this.recursionDetector = null;
            this.scan(tree.getMembers(), null);
            this.recursionDetector = prevRecursionDetector;
            return null;
        }

        public Void visitMemberReference(MemberReferenceTree node, Void p) {
            this.scan(node.getQualifierExpression(), p);
            this.tl.moveToEnd(node.getQualifierExpression());
            this.scan(node.getTypeArguments(), null);
            this.tl.moveToEnd(node.getTypeArguments());
            this.handlePossibleIdentifier(this.getCurrentPath(), false);
            this.firstIdentifier(node.getName().toString());
            return null;
        }

        public Void visitLiteral(LiteralTree node, Void p) {
            Element invoked;
            MethodInvocationTree inv;
            int pos;
            TreePath pp = this.getCurrentPath().getParentPath();
            if (pp.getLeaf() != null && pp.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION && (pos = (inv = (MethodInvocationTree)pp.getLeaf()).getArguments().indexOf(node)) != -1 && (invoked = this.info.getTrees().getElement(pp)) != null && (invoked.getKind() == ElementKind.METHOD || invoked.getKind() == ElementKind.CONSTRUCTOR)) {
                long start = this.sourcePositions.getStartPosition(this.info.getCompilationUnit(), node);
                long end = start + 1L;
                ExecutableElement invokedMethod = (ExecutableElement)invoked;
                pos = Math.min(pos, invokedMethod.getParameters().size() - 1);
                this.preText.put(new int[]{(int)start, (int)end}, invokedMethod.getParameters().get(pos).getSimpleName() + ":");
            }
            return (Void)super.visitLiteral(node, (Object)p);
        }
    }

    private static class Use {
        private Collection<UseTypes> type;
        private TreePath tree;
        private Collection<ColoringAttributes> spec;

        public Use(Collection<UseTypes> type, TreePath tree, Collection<ColoringAttributes> spec) {
            this.type = type;
            this.tree = tree;
            this.spec = spec;
        }

        public String toString() {
            return "Use: " + this.type;
        }
    }

    private static enum UseTypes {
        READ,
        WRITE,
        EXECUTE,
        DECLARATION,
        CLASS_USE,
        MODULE_USE;

    }
}

